/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.AzureFunctionActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.AzureFunctionActivityMethod;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="AzureFunctionActivity")
public final class AzureFunctionActivity
extends ExecutionActivity {
    @JsonProperty(value="typeProperties", required=true)
    private AzureFunctionActivityTypeProperties innerTypeProperties = new AzureFunctionActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(AzureFunctionActivity.class);

    private AzureFunctionActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AzureFunctionActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AzureFunctionActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public AzureFunctionActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public AzureFunctionActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AzureFunctionActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public AzureFunctionActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public AzureFunctionActivityMethod method() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().method();
    }

    public AzureFunctionActivity withMethod(AzureFunctionActivityMethod method) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFunctionActivityTypeProperties();
        }
        this.innerTypeProperties().withMethod(method);
        return this;
    }

    public Object functionName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().functionName();
    }

    public AzureFunctionActivity withFunctionName(Object functionName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFunctionActivityTypeProperties();
        }
        this.innerTypeProperties().withFunctionName(functionName);
        return this;
    }

    public Object headers() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().headers();
    }

    public AzureFunctionActivity withHeaders(Object headers) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFunctionActivityTypeProperties();
        }
        this.innerTypeProperties().withHeaders(headers);
        return this;
    }

    public Object body() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().body();
    }

    public AzureFunctionActivity withBody(Object body) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFunctionActivityTypeProperties();
        }
        this.innerTypeProperties().withBody(body);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model AzureFunctionActivity"));
        }
        this.innerTypeProperties().validate();
    }
}

