/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1Affinity;
import io.kubernetes.client.openapi.models.V1AffinityBuilder;
import io.kubernetes.client.openapi.models.V1AffinityFluentImpl;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ContainerBuilder;
import io.kubernetes.client.openapi.models.V1ContainerFluentImpl;
import io.kubernetes.client.openapi.models.V1EphemeralContainer;
import io.kubernetes.client.openapi.models.V1EphemeralContainerBuilder;
import io.kubernetes.client.openapi.models.V1EphemeralContainerFluentImpl;
import io.kubernetes.client.openapi.models.V1HostAlias;
import io.kubernetes.client.openapi.models.V1HostAliasBuilder;
import io.kubernetes.client.openapi.models.V1HostAliasFluentImpl;
import io.kubernetes.client.openapi.models.V1LocalObjectReference;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceFluentImpl;
import io.kubernetes.client.openapi.models.V1PodDNSConfig;
import io.kubernetes.client.openapi.models.V1PodDNSConfigBuilder;
import io.kubernetes.client.openapi.models.V1PodDNSConfigFluentImpl;
import io.kubernetes.client.openapi.models.V1PodReadinessGate;
import io.kubernetes.client.openapi.models.V1PodReadinessGateBuilder;
import io.kubernetes.client.openapi.models.V1PodReadinessGateFluentImpl;
import io.kubernetes.client.openapi.models.V1PodSecurityContext;
import io.kubernetes.client.openapi.models.V1PodSecurityContextBuilder;
import io.kubernetes.client.openapi.models.V1PodSecurityContextFluentImpl;
import io.kubernetes.client.openapi.models.V1PodSpec;
import io.kubernetes.client.openapi.models.V1PodSpecFluent;
import io.kubernetes.client.openapi.models.V1Toleration;
import io.kubernetes.client.openapi.models.V1TolerationBuilder;
import io.kubernetes.client.openapi.models.V1TolerationFluentImpl;
import io.kubernetes.client.openapi.models.V1TopologySpreadConstraint;
import io.kubernetes.client.openapi.models.V1TopologySpreadConstraintBuilder;
import io.kubernetes.client.openapi.models.V1TopologySpreadConstraintFluentImpl;
import io.kubernetes.client.openapi.models.V1Volume;
import io.kubernetes.client.openapi.models.V1VolumeBuilder;
import io.kubernetes.client.openapi.models.V1VolumeFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class V1PodSpecFluentImpl<A extends V1PodSpecFluent<A>>
extends BaseFluent<A>
implements V1PodSpecFluent<A> {
    private Long activeDeadlineSeconds;
    private V1AffinityBuilder affinity;
    private Boolean automountServiceAccountToken;
    private List<V1ContainerBuilder> containers;
    private V1PodDNSConfigBuilder dnsConfig;
    private String dnsPolicy;
    private Boolean enableServiceLinks;
    private List<V1EphemeralContainerBuilder> ephemeralContainers;
    private List<V1HostAliasBuilder> hostAliases;
    private Boolean hostIPC;
    private Boolean hostNetwork;
    private Boolean hostPID;
    private String hostname;
    private List<V1LocalObjectReferenceBuilder> imagePullSecrets;
    private List<V1ContainerBuilder> initContainers;
    private String nodeName;
    private Map<String, String> nodeSelector;
    private Map<String, Quantity> overhead;
    private String preemptionPolicy;
    private Integer priority;
    private String priorityClassName;
    private List<V1PodReadinessGateBuilder> readinessGates;
    private String restartPolicy;
    private String runtimeClassName;
    private String schedulerName;
    private V1PodSecurityContextBuilder securityContext;
    private String serviceAccount;
    private String serviceAccountName;
    private Boolean setHostnameAsFQDN;
    private Boolean shareProcessNamespace;
    private String subdomain;
    private Long terminationGracePeriodSeconds;
    private List<V1TolerationBuilder> tolerations;
    private List<V1TopologySpreadConstraintBuilder> topologySpreadConstraints;
    private List<V1VolumeBuilder> volumes;

    public V1PodSpecFluentImpl() {
    }

    public V1PodSpecFluentImpl(V1PodSpec instance) {
        this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        this.withAffinity(instance.getAffinity());
        this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
        this.withContainers(instance.getContainers());
        this.withDnsConfig(instance.getDnsConfig());
        this.withDnsPolicy(instance.getDnsPolicy());
        this.withEnableServiceLinks(instance.getEnableServiceLinks());
        this.withEphemeralContainers(instance.getEphemeralContainers());
        this.withHostAliases(instance.getHostAliases());
        this.withHostIPC(instance.getHostIPC());
        this.withHostNetwork(instance.getHostNetwork());
        this.withHostPID(instance.getHostPID());
        this.withHostname(instance.getHostname());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withInitContainers(instance.getInitContainers());
        this.withNodeName(instance.getNodeName());
        this.withNodeSelector(instance.getNodeSelector());
        this.withOverhead(instance.getOverhead());
        this.withPreemptionPolicy(instance.getPreemptionPolicy());
        this.withPriority(instance.getPriority());
        this.withPriorityClassName(instance.getPriorityClassName());
        this.withReadinessGates(instance.getReadinessGates());
        this.withRestartPolicy(instance.getRestartPolicy());
        this.withRuntimeClassName(instance.getRuntimeClassName());
        this.withSchedulerName(instance.getSchedulerName());
        this.withSecurityContext(instance.getSecurityContext());
        this.withServiceAccount(instance.getServiceAccount());
        this.withServiceAccountName(instance.getServiceAccountName());
        this.withSetHostnameAsFQDN(instance.getSetHostnameAsFQDN());
        this.withShareProcessNamespace(instance.getShareProcessNamespace());
        this.withSubdomain(instance.getSubdomain());
        this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
        this.withTolerations(instance.getTolerations());
        this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    @Override
    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds != null;
    }

    @Override
    @Deprecated
    public V1Affinity getAffinity() {
        return this.affinity != null ? this.affinity.build() : null;
    }

    @Override
    public V1Affinity buildAffinity() {
        return this.affinity != null ? this.affinity.build() : null;
    }

    @Override
    public A withAffinity(V1Affinity affinity) {
        this._visitables.get("affinity").remove(this.affinity);
        if (affinity != null) {
            this.affinity = new V1AffinityBuilder(affinity);
            this._visitables.get("affinity").add(this.affinity);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    @Override
    public V1PodSpecFluent.AffinityNested<A> withNewAffinity() {
        return new AffinityNestedImpl();
    }

    @Override
    public V1PodSpecFluent.AffinityNested<A> withNewAffinityLike(V1Affinity item) {
        return new AffinityNestedImpl(item);
    }

    @Override
    public V1PodSpecFluent.AffinityNested<A> editAffinity() {
        return this.withNewAffinityLike(this.getAffinity());
    }

    @Override
    public V1PodSpecFluent.AffinityNested<A> editOrNewAffinity() {
        return this.withNewAffinityLike(this.getAffinity() != null ? this.getAffinity() : new V1AffinityBuilder().build());
    }

    @Override
    public V1PodSpecFluent.AffinityNested<A> editOrNewAffinityLike(V1Affinity item) {
        return this.withNewAffinityLike(this.getAffinity() != null ? this.getAffinity() : item);
    }

    @Override
    public Boolean getAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    @Override
    public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
        return (A)this;
    }

    @Override
    public Boolean hasAutomountServiceAccountToken() {
        return this.automountServiceAccountToken != null;
    }

    @Override
    public A addToContainers(int index, V1Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList<V1ContainerBuilder>();
        }
        V1ContainerBuilder builder = new V1ContainerBuilder(item);
        this._visitables.get("containers").add(index >= 0 ? index : this._visitables.get("containers").size(), builder);
        this.containers.add(index >= 0 ? index : this.containers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToContainers(int index, V1Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList<V1ContainerBuilder>();
        }
        V1ContainerBuilder builder = new V1ContainerBuilder(item);
        if (index < 0 || index >= this._visitables.get("containers").size()) {
            this._visitables.get("containers").add(builder);
        } else {
            this._visitables.get("containers").set(index, builder);
        }
        if (index < 0 || index >= this.containers.size()) {
            this.containers.add(builder);
        } else {
            this.containers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToContainers(V1Container ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList<V1ContainerBuilder>();
        }
        for (V1Container item : items) {
            V1ContainerBuilder builder = new V1ContainerBuilder(item);
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainers(Collection<V1Container> items) {
        if (this.containers == null) {
            this.containers = new ArrayList<V1ContainerBuilder>();
        }
        for (V1Container item : items) {
            V1ContainerBuilder builder = new V1ContainerBuilder(item);
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainers(V1Container ... items) {
        for (V1Container item : items) {
            V1ContainerBuilder builder = new V1ContainerBuilder(item);
            this._visitables.get("containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainers(Collection<V1Container> items) {
        for (V1Container item : items) {
            V1ContainerBuilder builder = new V1ContainerBuilder(item);
            this._visitables.get("containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromContainers(Predicate<V1ContainerBuilder> predicate) {
        if (this.containers == null) {
            return (A)this;
        }
        Iterator<V1ContainerBuilder> each = this.containers.iterator();
        Object visitables = this._visitables.get("containers");
        while (each.hasNext()) {
            V1ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1Container> getContainers() {
        return V1PodSpecFluentImpl.build(this.containers);
    }

    @Override
    public List<V1Container> buildContainers() {
        return V1PodSpecFluentImpl.build(this.containers);
    }

    @Override
    public V1Container buildContainer(int index) {
        return this.containers.get(index).build();
    }

    @Override
    public V1Container buildFirstContainer() {
        return this.containers.get(0).build();
    }

    @Override
    public V1Container buildLastContainer() {
        return this.containers.get(this.containers.size() - 1).build();
    }

    @Override
    public V1Container buildMatchingContainer(Predicate<V1ContainerBuilder> predicate) {
        for (V1ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainer(Predicate<V1ContainerBuilder> predicate) {
        for (V1ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainers(List<V1Container> containers) {
        if (this.containers != null) {
            this._visitables.get("containers").removeAll(this.containers);
        }
        if (containers != null) {
            this.containers = new ArrayList<V1ContainerBuilder>();
            for (V1Container item : containers) {
                this.addToContainers(item);
            }
        } else {
            this.containers = null;
        }
        return (A)this;
    }

    @Override
    public A withContainers(V1Container ... containers) {
        if (this.containers != null) {
            this.containers.clear();
        }
        if (containers != null) {
            for (V1Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    @Override
    public V1PodSpecFluent.ContainersNested<A> addNewContainer() {
        return new ContainersNestedImpl();
    }

    @Override
    public V1PodSpecFluent.ContainersNested<A> addNewContainerLike(V1Container item) {
        return new ContainersNestedImpl(-1, item);
    }

    @Override
    public V1PodSpecFluent.ContainersNested<A> setNewContainerLike(int index, V1Container item) {
        return new ContainersNestedImpl(index, item);
    }

    @Override
    public V1PodSpecFluent.ContainersNested<A> editContainer(int index) {
        if (this.containers.size() <= index) {
            throw new RuntimeException("Can't edit containers. Index exceeds size.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public V1PodSpecFluent.ContainersNested<A> editFirstContainer() {
        if (this.containers.size() == 0) {
            throw new RuntimeException("Can't edit first containers. The list is empty.");
        }
        return this.setNewContainerLike(0, this.buildContainer(0));
    }

    @Override
    public V1PodSpecFluent.ContainersNested<A> editLastContainer() {
        int index = this.containers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containers. The list is empty.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public V1PodSpecFluent.ContainersNested<A> editMatchingContainer(Predicate<V1ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containers.size(); ++i) {
            if (!predicate.test(this.containers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containers. No match found.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    @Deprecated
    public V1PodDNSConfig getDnsConfig() {
        return this.dnsConfig != null ? this.dnsConfig.build() : null;
    }

    @Override
    public V1PodDNSConfig buildDnsConfig() {
        return this.dnsConfig != null ? this.dnsConfig.build() : null;
    }

    @Override
    public A withDnsConfig(V1PodDNSConfig dnsConfig) {
        this._visitables.get("dnsConfig").remove(this.dnsConfig);
        if (dnsConfig != null) {
            this.dnsConfig = new V1PodDNSConfigBuilder(dnsConfig);
            this._visitables.get("dnsConfig").add(this.dnsConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDnsConfig() {
        return this.dnsConfig != null;
    }

    @Override
    public V1PodSpecFluent.DnsConfigNested<A> withNewDnsConfig() {
        return new DnsConfigNestedImpl();
    }

    @Override
    public V1PodSpecFluent.DnsConfigNested<A> withNewDnsConfigLike(V1PodDNSConfig item) {
        return new DnsConfigNestedImpl(item);
    }

    @Override
    public V1PodSpecFluent.DnsConfigNested<A> editDnsConfig() {
        return this.withNewDnsConfigLike(this.getDnsConfig());
    }

    @Override
    public V1PodSpecFluent.DnsConfigNested<A> editOrNewDnsConfig() {
        return this.withNewDnsConfigLike(this.getDnsConfig() != null ? this.getDnsConfig() : new V1PodDNSConfigBuilder().build());
    }

    @Override
    public V1PodSpecFluent.DnsConfigNested<A> editOrNewDnsConfigLike(V1PodDNSConfig item) {
        return this.withNewDnsConfigLike(this.getDnsConfig() != null ? this.getDnsConfig() : item);
    }

    @Override
    public String getDnsPolicy() {
        return this.dnsPolicy;
    }

    @Override
    public A withDnsPolicy(String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasDnsPolicy() {
        return this.dnsPolicy != null;
    }

    @Override
    @Deprecated
    public A withNewDnsPolicy(String original) {
        return this.withDnsPolicy(new String(original));
    }

    @Override
    public Boolean getEnableServiceLinks() {
        return this.enableServiceLinks;
    }

    @Override
    public A withEnableServiceLinks(Boolean enableServiceLinks) {
        this.enableServiceLinks = enableServiceLinks;
        return (A)this;
    }

    @Override
    public Boolean hasEnableServiceLinks() {
        return this.enableServiceLinks != null;
    }

    @Override
    public A addToEphemeralContainers(int index, V1EphemeralContainer item) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList<V1EphemeralContainerBuilder>();
        }
        V1EphemeralContainerBuilder builder = new V1EphemeralContainerBuilder(item);
        this._visitables.get("ephemeralContainers").add(index >= 0 ? index : this._visitables.get("ephemeralContainers").size(), builder);
        this.ephemeralContainers.add(index >= 0 ? index : this.ephemeralContainers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEphemeralContainers(int index, V1EphemeralContainer item) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList<V1EphemeralContainerBuilder>();
        }
        V1EphemeralContainerBuilder builder = new V1EphemeralContainerBuilder(item);
        if (index < 0 || index >= this._visitables.get("ephemeralContainers").size()) {
            this._visitables.get("ephemeralContainers").add(builder);
        } else {
            this._visitables.get("ephemeralContainers").set(index, builder);
        }
        if (index < 0 || index >= this.ephemeralContainers.size()) {
            this.ephemeralContainers.add(builder);
        } else {
            this.ephemeralContainers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEphemeralContainers(V1EphemeralContainer ... items) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList<V1EphemeralContainerBuilder>();
        }
        for (V1EphemeralContainer item : items) {
            V1EphemeralContainerBuilder builder = new V1EphemeralContainerBuilder(item);
            this._visitables.get("ephemeralContainers").add(builder);
            this.ephemeralContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEphemeralContainers(Collection<V1EphemeralContainer> items) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList<V1EphemeralContainerBuilder>();
        }
        for (V1EphemeralContainer item : items) {
            V1EphemeralContainerBuilder builder = new V1EphemeralContainerBuilder(item);
            this._visitables.get("ephemeralContainers").add(builder);
            this.ephemeralContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEphemeralContainers(V1EphemeralContainer ... items) {
        for (V1EphemeralContainer item : items) {
            V1EphemeralContainerBuilder builder = new V1EphemeralContainerBuilder(item);
            this._visitables.get("ephemeralContainers").remove(builder);
            if (this.ephemeralContainers == null) continue;
            this.ephemeralContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEphemeralContainers(Collection<V1EphemeralContainer> items) {
        for (V1EphemeralContainer item : items) {
            V1EphemeralContainerBuilder builder = new V1EphemeralContainerBuilder(item);
            this._visitables.get("ephemeralContainers").remove(builder);
            if (this.ephemeralContainers == null) continue;
            this.ephemeralContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEphemeralContainers(Predicate<V1EphemeralContainerBuilder> predicate) {
        if (this.ephemeralContainers == null) {
            return (A)this;
        }
        Iterator<V1EphemeralContainerBuilder> each = this.ephemeralContainers.iterator();
        Object visitables = this._visitables.get("ephemeralContainers");
        while (each.hasNext()) {
            V1EphemeralContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1EphemeralContainer> getEphemeralContainers() {
        return V1PodSpecFluentImpl.build(this.ephemeralContainers);
    }

    @Override
    public List<V1EphemeralContainer> buildEphemeralContainers() {
        return V1PodSpecFluentImpl.build(this.ephemeralContainers);
    }

    @Override
    public V1EphemeralContainer buildEphemeralContainer(int index) {
        return this.ephemeralContainers.get(index).build();
    }

    @Override
    public V1EphemeralContainer buildFirstEphemeralContainer() {
        return this.ephemeralContainers.get(0).build();
    }

    @Override
    public V1EphemeralContainer buildLastEphemeralContainer() {
        return this.ephemeralContainers.get(this.ephemeralContainers.size() - 1).build();
    }

    @Override
    public V1EphemeralContainer buildMatchingEphemeralContainer(Predicate<V1EphemeralContainerBuilder> predicate) {
        for (V1EphemeralContainerBuilder item : this.ephemeralContainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEphemeralContainer(Predicate<V1EphemeralContainerBuilder> predicate) {
        for (V1EphemeralContainerBuilder item : this.ephemeralContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEphemeralContainers(List<V1EphemeralContainer> ephemeralContainers) {
        if (this.ephemeralContainers != null) {
            this._visitables.get("ephemeralContainers").removeAll(this.ephemeralContainers);
        }
        if (ephemeralContainers != null) {
            this.ephemeralContainers = new ArrayList<V1EphemeralContainerBuilder>();
            for (V1EphemeralContainer item : ephemeralContainers) {
                this.addToEphemeralContainers(item);
            }
        } else {
            this.ephemeralContainers = null;
        }
        return (A)this;
    }

    @Override
    public A withEphemeralContainers(V1EphemeralContainer ... ephemeralContainers) {
        if (this.ephemeralContainers != null) {
            this.ephemeralContainers.clear();
        }
        if (ephemeralContainers != null) {
            for (V1EphemeralContainer item : ephemeralContainers) {
                this.addToEphemeralContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEphemeralContainers() {
        return this.ephemeralContainers != null && !this.ephemeralContainers.isEmpty();
    }

    @Override
    public V1PodSpecFluent.EphemeralContainersNested<A> addNewEphemeralContainer() {
        return new EphemeralContainersNestedImpl();
    }

    @Override
    public V1PodSpecFluent.EphemeralContainersNested<A> addNewEphemeralContainerLike(V1EphemeralContainer item) {
        return new EphemeralContainersNestedImpl(-1, item);
    }

    @Override
    public V1PodSpecFluent.EphemeralContainersNested<A> setNewEphemeralContainerLike(int index, V1EphemeralContainer item) {
        return new EphemeralContainersNestedImpl(index, item);
    }

    @Override
    public V1PodSpecFluent.EphemeralContainersNested<A> editEphemeralContainer(int index) {
        if (this.ephemeralContainers.size() <= index) {
            throw new RuntimeException("Can't edit ephemeralContainers. Index exceeds size.");
        }
        return this.setNewEphemeralContainerLike(index, this.buildEphemeralContainer(index));
    }

    @Override
    public V1PodSpecFluent.EphemeralContainersNested<A> editFirstEphemeralContainer() {
        if (this.ephemeralContainers.size() == 0) {
            throw new RuntimeException("Can't edit first ephemeralContainers. The list is empty.");
        }
        return this.setNewEphemeralContainerLike(0, this.buildEphemeralContainer(0));
    }

    @Override
    public V1PodSpecFluent.EphemeralContainersNested<A> editLastEphemeralContainer() {
        int index = this.ephemeralContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ephemeralContainers. The list is empty.");
        }
        return this.setNewEphemeralContainerLike(index, this.buildEphemeralContainer(index));
    }

    @Override
    public V1PodSpecFluent.EphemeralContainersNested<A> editMatchingEphemeralContainer(Predicate<V1EphemeralContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ephemeralContainers.size(); ++i) {
            if (!predicate.test(this.ephemeralContainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ephemeralContainers. No match found.");
        }
        return this.setNewEphemeralContainerLike(index, this.buildEphemeralContainer(index));
    }

    @Override
    public A addToHostAliases(int index, V1HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<V1HostAliasBuilder>();
        }
        V1HostAliasBuilder builder = new V1HostAliasBuilder(item);
        this._visitables.get("hostAliases").add(index >= 0 ? index : this._visitables.get("hostAliases").size(), builder);
        this.hostAliases.add(index >= 0 ? index : this.hostAliases.size(), builder);
        return (A)this;
    }

    @Override
    public A setToHostAliases(int index, V1HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<V1HostAliasBuilder>();
        }
        V1HostAliasBuilder builder = new V1HostAliasBuilder(item);
        if (index < 0 || index >= this._visitables.get("hostAliases").size()) {
            this._visitables.get("hostAliases").add(builder);
        } else {
            this._visitables.get("hostAliases").set(index, builder);
        }
        if (index < 0 || index >= this.hostAliases.size()) {
            this.hostAliases.add(builder);
        } else {
            this.hostAliases.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHostAliases(V1HostAlias ... items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<V1HostAliasBuilder>();
        }
        for (V1HostAlias item : items) {
            V1HostAliasBuilder builder = new V1HostAliasBuilder(item);
            this._visitables.get("hostAliases").add(builder);
            this.hostAliases.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHostAliases(Collection<V1HostAlias> items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<V1HostAliasBuilder>();
        }
        for (V1HostAlias item : items) {
            V1HostAliasBuilder builder = new V1HostAliasBuilder(item);
            this._visitables.get("hostAliases").add(builder);
            this.hostAliases.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHostAliases(V1HostAlias ... items) {
        for (V1HostAlias item : items) {
            V1HostAliasBuilder builder = new V1HostAliasBuilder(item);
            this._visitables.get("hostAliases").remove(builder);
            if (this.hostAliases == null) continue;
            this.hostAliases.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHostAliases(Collection<V1HostAlias> items) {
        for (V1HostAlias item : items) {
            V1HostAliasBuilder builder = new V1HostAliasBuilder(item);
            this._visitables.get("hostAliases").remove(builder);
            if (this.hostAliases == null) continue;
            this.hostAliases.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromHostAliases(Predicate<V1HostAliasBuilder> predicate) {
        if (this.hostAliases == null) {
            return (A)this;
        }
        Iterator<V1HostAliasBuilder> each = this.hostAliases.iterator();
        Object visitables = this._visitables.get("hostAliases");
        while (each.hasNext()) {
            V1HostAliasBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1HostAlias> getHostAliases() {
        return V1PodSpecFluentImpl.build(this.hostAliases);
    }

    @Override
    public List<V1HostAlias> buildHostAliases() {
        return V1PodSpecFluentImpl.build(this.hostAliases);
    }

    @Override
    public V1HostAlias buildHostAlias(int index) {
        return this.hostAliases.get(index).build();
    }

    @Override
    public V1HostAlias buildFirstHostAlias() {
        return this.hostAliases.get(0).build();
    }

    @Override
    public V1HostAlias buildLastHostAlias() {
        return this.hostAliases.get(this.hostAliases.size() - 1).build();
    }

    @Override
    public V1HostAlias buildMatchingHostAlias(Predicate<V1HostAliasBuilder> predicate) {
        for (V1HostAliasBuilder item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHostAlias(Predicate<V1HostAliasBuilder> predicate) {
        for (V1HostAliasBuilder item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHostAliases(List<V1HostAlias> hostAliases) {
        if (this.hostAliases != null) {
            this._visitables.get("hostAliases").removeAll(this.hostAliases);
        }
        if (hostAliases != null) {
            this.hostAliases = new ArrayList<V1HostAliasBuilder>();
            for (V1HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        } else {
            this.hostAliases = null;
        }
        return (A)this;
    }

    @Override
    public A withHostAliases(V1HostAlias ... hostAliases) {
        if (this.hostAliases != null) {
            this.hostAliases.clear();
        }
        if (hostAliases != null) {
            for (V1HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHostAliases() {
        return this.hostAliases != null && !this.hostAliases.isEmpty();
    }

    @Override
    public V1PodSpecFluent.HostAliasesNested<A> addNewHostAlias() {
        return new HostAliasesNestedImpl();
    }

    @Override
    public V1PodSpecFluent.HostAliasesNested<A> addNewHostAliasLike(V1HostAlias item) {
        return new HostAliasesNestedImpl(-1, item);
    }

    @Override
    public V1PodSpecFluent.HostAliasesNested<A> setNewHostAliasLike(int index, V1HostAlias item) {
        return new HostAliasesNestedImpl(index, item);
    }

    @Override
    public V1PodSpecFluent.HostAliasesNested<A> editHostAlias(int index) {
        if (this.hostAliases.size() <= index) {
            throw new RuntimeException("Can't edit hostAliases. Index exceeds size.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    @Override
    public V1PodSpecFluent.HostAliasesNested<A> editFirstHostAlias() {
        if (this.hostAliases.size() == 0) {
            throw new RuntimeException("Can't edit first hostAliases. The list is empty.");
        }
        return this.setNewHostAliasLike(0, this.buildHostAlias(0));
    }

    @Override
    public V1PodSpecFluent.HostAliasesNested<A> editLastHostAlias() {
        int index = this.hostAliases.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last hostAliases. The list is empty.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    @Override
    public V1PodSpecFluent.HostAliasesNested<A> editMatchingHostAlias(Predicate<V1HostAliasBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.hostAliases.size(); ++i) {
            if (!predicate.test(this.hostAliases.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching hostAliases. No match found.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    @Override
    public Boolean getHostIPC() {
        return this.hostIPC;
    }

    @Override
    public A withHostIPC(Boolean hostIPC) {
        this.hostIPC = hostIPC;
        return (A)this;
    }

    @Override
    public Boolean hasHostIPC() {
        return this.hostIPC != null;
    }

    @Override
    public Boolean getHostNetwork() {
        return this.hostNetwork;
    }

    @Override
    public A withHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return (A)this;
    }

    @Override
    public Boolean hasHostNetwork() {
        return this.hostNetwork != null;
    }

    @Override
    public Boolean getHostPID() {
        return this.hostPID;
    }

    @Override
    public A withHostPID(Boolean hostPID) {
        this.hostPID = hostPID;
        return (A)this;
    }

    @Override
    public Boolean hasHostPID() {
        return this.hostPID != null;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    @Deprecated
    public A withNewHostname(String original) {
        return this.withHostname(new String(original));
    }

    @Override
    public A addToImagePullSecrets(int index, V1LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<V1LocalObjectReferenceBuilder>();
        }
        V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
        this._visitables.get("imagePullSecrets").add(index >= 0 ? index : this._visitables.get("imagePullSecrets").size(), builder);
        this.imagePullSecrets.add(index >= 0 ? index : this.imagePullSecrets.size(), builder);
        return (A)this;
    }

    @Override
    public A setToImagePullSecrets(int index, V1LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<V1LocalObjectReferenceBuilder>();
        }
        V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.get("imagePullSecrets").size()) {
            this._visitables.get("imagePullSecrets").add(builder);
        } else {
            this._visitables.get("imagePullSecrets").set(index, builder);
        }
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this.imagePullSecrets.add(builder);
        } else {
            this.imagePullSecrets.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImagePullSecrets(V1LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<V1LocalObjectReferenceBuilder>();
        }
        for (V1LocalObjectReference item : items) {
            V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImagePullSecrets(Collection<V1LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<V1LocalObjectReferenceBuilder>();
        }
        for (V1LocalObjectReference item : items) {
            V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImagePullSecrets(V1LocalObjectReference ... items) {
        for (V1LocalObjectReference item : items) {
            V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").remove(builder);
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImagePullSecrets(Collection<V1LocalObjectReference> items) {
        for (V1LocalObjectReference item : items) {
            V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").remove(builder);
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromImagePullSecrets(Predicate<V1LocalObjectReferenceBuilder> predicate) {
        if (this.imagePullSecrets == null) {
            return (A)this;
        }
        Iterator<V1LocalObjectReferenceBuilder> each = this.imagePullSecrets.iterator();
        Object visitables = this._visitables.get("imagePullSecrets");
        while (each.hasNext()) {
            V1LocalObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1LocalObjectReference> getImagePullSecrets() {
        return V1PodSpecFluentImpl.build(this.imagePullSecrets);
    }

    @Override
    public List<V1LocalObjectReference> buildImagePullSecrets() {
        return V1PodSpecFluentImpl.build(this.imagePullSecrets);
    }

    @Override
    public V1LocalObjectReference buildImagePullSecret(int index) {
        return this.imagePullSecrets.get(index).build();
    }

    @Override
    public V1LocalObjectReference buildFirstImagePullSecret() {
        return this.imagePullSecrets.get(0).build();
    }

    @Override
    public V1LocalObjectReference buildLastImagePullSecret() {
        return this.imagePullSecrets.get(this.imagePullSecrets.size() - 1).build();
    }

    @Override
    public V1LocalObjectReference buildMatchingImagePullSecret(Predicate<V1LocalObjectReferenceBuilder> predicate) {
        for (V1LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImagePullSecret(Predicate<V1LocalObjectReferenceBuilder> predicate) {
        for (V1LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImagePullSecrets(List<V1LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this._visitables.get("imagePullSecrets").removeAll(this.imagePullSecrets);
        }
        if (imagePullSecrets != null) {
            this.imagePullSecrets = new ArrayList<V1LocalObjectReferenceBuilder>();
            for (V1LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        } else {
            this.imagePullSecrets = null;
        }
        return (A)this;
    }

    @Override
    public A withImagePullSecrets(V1LocalObjectReference ... imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this.imagePullSecrets.clear();
        }
        if (imagePullSecrets != null) {
            for (V1LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImagePullSecrets() {
        return this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty();
    }

    @Override
    public V1PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret() {
        return new ImagePullSecretsNestedImpl();
    }

    @Override
    public V1PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(V1LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(-1, item);
    }

    @Override
    public V1PodSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index, V1LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(index, item);
    }

    @Override
    public V1PodSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(int index) {
        if (this.imagePullSecrets.size() <= index) {
            throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public V1PodSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret() {
        if (this.imagePullSecrets.size() == 0) {
            throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(0, this.buildImagePullSecret(0));
    }

    @Override
    public V1PodSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret() {
        int index = this.imagePullSecrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public V1PodSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<V1LocalObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imagePullSecrets.size(); ++i) {
            if (!predicate.test(this.imagePullSecrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public A addToInitContainers(int index, V1Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<V1ContainerBuilder>();
        }
        V1ContainerBuilder builder = new V1ContainerBuilder(item);
        this._visitables.get("initContainers").add(index >= 0 ? index : this._visitables.get("initContainers").size(), builder);
        this.initContainers.add(index >= 0 ? index : this.initContainers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToInitContainers(int index, V1Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<V1ContainerBuilder>();
        }
        V1ContainerBuilder builder = new V1ContainerBuilder(item);
        if (index < 0 || index >= this._visitables.get("initContainers").size()) {
            this._visitables.get("initContainers").add(builder);
        } else {
            this._visitables.get("initContainers").set(index, builder);
        }
        if (index < 0 || index >= this.initContainers.size()) {
            this.initContainers.add(builder);
        } else {
            this.initContainers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToInitContainers(V1Container ... items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<V1ContainerBuilder>();
        }
        for (V1Container item : items) {
            V1ContainerBuilder builder = new V1ContainerBuilder(item);
            this._visitables.get("initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToInitContainers(Collection<V1Container> items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<V1ContainerBuilder>();
        }
        for (V1Container item : items) {
            V1ContainerBuilder builder = new V1ContainerBuilder(item);
            this._visitables.get("initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInitContainers(V1Container ... items) {
        for (V1Container item : items) {
            V1ContainerBuilder builder = new V1ContainerBuilder(item);
            this._visitables.get("initContainers").remove(builder);
            if (this.initContainers == null) continue;
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInitContainers(Collection<V1Container> items) {
        for (V1Container item : items) {
            V1ContainerBuilder builder = new V1ContainerBuilder(item);
            this._visitables.get("initContainers").remove(builder);
            if (this.initContainers == null) continue;
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromInitContainers(Predicate<V1ContainerBuilder> predicate) {
        if (this.initContainers == null) {
            return (A)this;
        }
        Iterator<V1ContainerBuilder> each = this.initContainers.iterator();
        Object visitables = this._visitables.get("initContainers");
        while (each.hasNext()) {
            V1ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1Container> getInitContainers() {
        return V1PodSpecFluentImpl.build(this.initContainers);
    }

    @Override
    public List<V1Container> buildInitContainers() {
        return V1PodSpecFluentImpl.build(this.initContainers);
    }

    @Override
    public V1Container buildInitContainer(int index) {
        return this.initContainers.get(index).build();
    }

    @Override
    public V1Container buildFirstInitContainer() {
        return this.initContainers.get(0).build();
    }

    @Override
    public V1Container buildLastInitContainer() {
        return this.initContainers.get(this.initContainers.size() - 1).build();
    }

    @Override
    public V1Container buildMatchingInitContainer(Predicate<V1ContainerBuilder> predicate) {
        for (V1ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingInitContainer(Predicate<V1ContainerBuilder> predicate) {
        for (V1ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withInitContainers(List<V1Container> initContainers) {
        if (this.initContainers != null) {
            this._visitables.get("initContainers").removeAll(this.initContainers);
        }
        if (initContainers != null) {
            this.initContainers = new ArrayList<V1ContainerBuilder>();
            for (V1Container item : initContainers) {
                this.addToInitContainers(item);
            }
        } else {
            this.initContainers = null;
        }
        return (A)this;
    }

    @Override
    public A withInitContainers(V1Container ... initContainers) {
        if (this.initContainers != null) {
            this.initContainers.clear();
        }
        if (initContainers != null) {
            for (V1Container item : initContainers) {
                this.addToInitContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasInitContainers() {
        return this.initContainers != null && !this.initContainers.isEmpty();
    }

    @Override
    public V1PodSpecFluent.InitContainersNested<A> addNewInitContainer() {
        return new InitContainersNestedImpl();
    }

    @Override
    public V1PodSpecFluent.InitContainersNested<A> addNewInitContainerLike(V1Container item) {
        return new InitContainersNestedImpl(-1, item);
    }

    @Override
    public V1PodSpecFluent.InitContainersNested<A> setNewInitContainerLike(int index, V1Container item) {
        return new InitContainersNestedImpl(index, item);
    }

    @Override
    public V1PodSpecFluent.InitContainersNested<A> editInitContainer(int index) {
        if (this.initContainers.size() <= index) {
            throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public V1PodSpecFluent.InitContainersNested<A> editFirstInitContainer() {
        if (this.initContainers.size() == 0) {
            throw new RuntimeException("Can't edit first initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(0, this.buildInitContainer(0));
    }

    @Override
    public V1PodSpecFluent.InitContainersNested<A> editLastInitContainer() {
        int index = this.initContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public V1PodSpecFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<V1ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainers.size(); ++i) {
            if (!predicate.test(this.initContainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainers. No match found.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    @Override
    public Boolean hasNodeName() {
        return this.nodeName != null;
    }

    @Override
    @Deprecated
    public A withNewNodeName(String original) {
        return this.withNodeName(new String(original));
    }

    @Override
    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    @Override
    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)this;
    }

    @Override
    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    @Override
    public A addToOverhead(String key, Quantity value) {
        if (this.overhead == null && key != null && value != null) {
            this.overhead = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.overhead.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToOverhead(Map<String, Quantity> map) {
        if (this.overhead == null && map != null) {
            this.overhead = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.overhead.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromOverhead(String key) {
        if (this.overhead == null) {
            return (A)this;
        }
        if (key != null && this.overhead != null) {
            this.overhead.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromOverhead(Map<String, Quantity> map) {
        if (this.overhead == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.overhead == null) continue;
                this.overhead.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getOverhead() {
        return this.overhead;
    }

    @Override
    public <K, V> A withOverhead(Map<String, Quantity> overhead) {
        this.overhead = overhead == null ? null : new LinkedHashMap<String, Quantity>(overhead);
        return (A)this;
    }

    @Override
    public Boolean hasOverhead() {
        return this.overhead != null;
    }

    @Override
    public String getPreemptionPolicy() {
        return this.preemptionPolicy;
    }

    @Override
    public A withPreemptionPolicy(String preemptionPolicy) {
        this.preemptionPolicy = preemptionPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasPreemptionPolicy() {
        return this.preemptionPolicy != null;
    }

    @Override
    @Deprecated
    public A withNewPreemptionPolicy(String original) {
        return this.withPreemptionPolicy(new String(original));
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public A withPriority(Integer priority) {
        this.priority = priority;
        return (A)this;
    }

    @Override
    public Boolean hasPriority() {
        return this.priority != null;
    }

    @Override
    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    @Override
    public A withPriorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
        return (A)this;
    }

    @Override
    public Boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    @Override
    @Deprecated
    public A withNewPriorityClassName(String original) {
        return this.withPriorityClassName(new String(original));
    }

    @Override
    public A addToReadinessGates(int index, V1PodReadinessGate item) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList<V1PodReadinessGateBuilder>();
        }
        V1PodReadinessGateBuilder builder = new V1PodReadinessGateBuilder(item);
        this._visitables.get("readinessGates").add(index >= 0 ? index : this._visitables.get("readinessGates").size(), builder);
        this.readinessGates.add(index >= 0 ? index : this.readinessGates.size(), builder);
        return (A)this;
    }

    @Override
    public A setToReadinessGates(int index, V1PodReadinessGate item) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList<V1PodReadinessGateBuilder>();
        }
        V1PodReadinessGateBuilder builder = new V1PodReadinessGateBuilder(item);
        if (index < 0 || index >= this._visitables.get("readinessGates").size()) {
            this._visitables.get("readinessGates").add(builder);
        } else {
            this._visitables.get("readinessGates").set(index, builder);
        }
        if (index < 0 || index >= this.readinessGates.size()) {
            this.readinessGates.add(builder);
        } else {
            this.readinessGates.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToReadinessGates(V1PodReadinessGate ... items) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList<V1PodReadinessGateBuilder>();
        }
        for (V1PodReadinessGate item : items) {
            V1PodReadinessGateBuilder builder = new V1PodReadinessGateBuilder(item);
            this._visitables.get("readinessGates").add(builder);
            this.readinessGates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToReadinessGates(Collection<V1PodReadinessGate> items) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList<V1PodReadinessGateBuilder>();
        }
        for (V1PodReadinessGate item : items) {
            V1PodReadinessGateBuilder builder = new V1PodReadinessGateBuilder(item);
            this._visitables.get("readinessGates").add(builder);
            this.readinessGates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromReadinessGates(V1PodReadinessGate ... items) {
        for (V1PodReadinessGate item : items) {
            V1PodReadinessGateBuilder builder = new V1PodReadinessGateBuilder(item);
            this._visitables.get("readinessGates").remove(builder);
            if (this.readinessGates == null) continue;
            this.readinessGates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromReadinessGates(Collection<V1PodReadinessGate> items) {
        for (V1PodReadinessGate item : items) {
            V1PodReadinessGateBuilder builder = new V1PodReadinessGateBuilder(item);
            this._visitables.get("readinessGates").remove(builder);
            if (this.readinessGates == null) continue;
            this.readinessGates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromReadinessGates(Predicate<V1PodReadinessGateBuilder> predicate) {
        if (this.readinessGates == null) {
            return (A)this;
        }
        Iterator<V1PodReadinessGateBuilder> each = this.readinessGates.iterator();
        Object visitables = this._visitables.get("readinessGates");
        while (each.hasNext()) {
            V1PodReadinessGateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1PodReadinessGate> getReadinessGates() {
        return V1PodSpecFluentImpl.build(this.readinessGates);
    }

    @Override
    public List<V1PodReadinessGate> buildReadinessGates() {
        return V1PodSpecFluentImpl.build(this.readinessGates);
    }

    @Override
    public V1PodReadinessGate buildReadinessGate(int index) {
        return this.readinessGates.get(index).build();
    }

    @Override
    public V1PodReadinessGate buildFirstReadinessGate() {
        return this.readinessGates.get(0).build();
    }

    @Override
    public V1PodReadinessGate buildLastReadinessGate() {
        return this.readinessGates.get(this.readinessGates.size() - 1).build();
    }

    @Override
    public V1PodReadinessGate buildMatchingReadinessGate(Predicate<V1PodReadinessGateBuilder> predicate) {
        for (V1PodReadinessGateBuilder item : this.readinessGates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingReadinessGate(Predicate<V1PodReadinessGateBuilder> predicate) {
        for (V1PodReadinessGateBuilder item : this.readinessGates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withReadinessGates(List<V1PodReadinessGate> readinessGates) {
        if (this.readinessGates != null) {
            this._visitables.get("readinessGates").removeAll(this.readinessGates);
        }
        if (readinessGates != null) {
            this.readinessGates = new ArrayList<V1PodReadinessGateBuilder>();
            for (V1PodReadinessGate item : readinessGates) {
                this.addToReadinessGates(item);
            }
        } else {
            this.readinessGates = null;
        }
        return (A)this;
    }

    @Override
    public A withReadinessGates(V1PodReadinessGate ... readinessGates) {
        if (this.readinessGates != null) {
            this.readinessGates.clear();
        }
        if (readinessGates != null) {
            for (V1PodReadinessGate item : readinessGates) {
                this.addToReadinessGates(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessGates() {
        return this.readinessGates != null && !this.readinessGates.isEmpty();
    }

    @Override
    public V1PodSpecFluent.ReadinessGatesNested<A> addNewReadinessGate() {
        return new ReadinessGatesNestedImpl();
    }

    @Override
    public V1PodSpecFluent.ReadinessGatesNested<A> addNewReadinessGateLike(V1PodReadinessGate item) {
        return new ReadinessGatesNestedImpl(-1, item);
    }

    @Override
    public V1PodSpecFluent.ReadinessGatesNested<A> setNewReadinessGateLike(int index, V1PodReadinessGate item) {
        return new ReadinessGatesNestedImpl(index, item);
    }

    @Override
    public V1PodSpecFluent.ReadinessGatesNested<A> editReadinessGate(int index) {
        if (this.readinessGates.size() <= index) {
            throw new RuntimeException("Can't edit readinessGates. Index exceeds size.");
        }
        return this.setNewReadinessGateLike(index, this.buildReadinessGate(index));
    }

    @Override
    public V1PodSpecFluent.ReadinessGatesNested<A> editFirstReadinessGate() {
        if (this.readinessGates.size() == 0) {
            throw new RuntimeException("Can't edit first readinessGates. The list is empty.");
        }
        return this.setNewReadinessGateLike(0, this.buildReadinessGate(0));
    }

    @Override
    public V1PodSpecFluent.ReadinessGatesNested<A> editLastReadinessGate() {
        int index = this.readinessGates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last readinessGates. The list is empty.");
        }
        return this.setNewReadinessGateLike(index, this.buildReadinessGate(index));
    }

    @Override
    public V1PodSpecFluent.ReadinessGatesNested<A> editMatchingReadinessGate(Predicate<V1PodReadinessGateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.readinessGates.size(); ++i) {
            if (!predicate.test(this.readinessGates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching readinessGates. No match found.");
        }
        return this.setNewReadinessGateLike(index, this.buildReadinessGate(index));
    }

    @Override
    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    @Override
    public A withRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasRestartPolicy() {
        return this.restartPolicy != null;
    }

    @Override
    @Deprecated
    public A withNewRestartPolicy(String original) {
        return this.withRestartPolicy(new String(original));
    }

    @Override
    public String getRuntimeClassName() {
        return this.runtimeClassName;
    }

    @Override
    public A withRuntimeClassName(String runtimeClassName) {
        this.runtimeClassName = runtimeClassName;
        return (A)this;
    }

    @Override
    public Boolean hasRuntimeClassName() {
        return this.runtimeClassName != null;
    }

    @Override
    @Deprecated
    public A withNewRuntimeClassName(String original) {
        return this.withRuntimeClassName(new String(original));
    }

    @Override
    public String getSchedulerName() {
        return this.schedulerName;
    }

    @Override
    public A withSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
        return (A)this;
    }

    @Override
    public Boolean hasSchedulerName() {
        return this.schedulerName != null;
    }

    @Override
    @Deprecated
    public A withNewSchedulerName(String original) {
        return this.withSchedulerName(new String(original));
    }

    @Override
    @Deprecated
    public V1PodSecurityContext getSecurityContext() {
        return this.securityContext != null ? this.securityContext.build() : null;
    }

    @Override
    public V1PodSecurityContext buildSecurityContext() {
        return this.securityContext != null ? this.securityContext.build() : null;
    }

    @Override
    public A withSecurityContext(V1PodSecurityContext securityContext) {
        this._visitables.get("securityContext").remove(this.securityContext);
        if (securityContext != null) {
            this.securityContext = new V1PodSecurityContextBuilder(securityContext);
            this._visitables.get("securityContext").add(this.securityContext);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    @Override
    public V1PodSpecFluent.SecurityContextNested<A> withNewSecurityContext() {
        return new SecurityContextNestedImpl();
    }

    @Override
    public V1PodSpecFluent.SecurityContextNested<A> withNewSecurityContextLike(V1PodSecurityContext item) {
        return new SecurityContextNestedImpl(item);
    }

    @Override
    public V1PodSpecFluent.SecurityContextNested<A> editSecurityContext() {
        return this.withNewSecurityContextLike(this.getSecurityContext());
    }

    @Override
    public V1PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContext() {
        return this.withNewSecurityContextLike(this.getSecurityContext() != null ? this.getSecurityContext() : new V1PodSecurityContextBuilder().build());
    }

    @Override
    public V1PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContextLike(V1PodSecurityContext item) {
        return this.withNewSecurityContextLike(this.getSecurityContext() != null ? this.getSecurityContext() : item);
    }

    @Override
    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @Override
    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    @Override
    @Deprecated
    public A withNewServiceAccount(String original) {
        return this.withServiceAccount(new String(original));
    }

    @Override
    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    @Override
    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    @Override
    @Deprecated
    public A withNewServiceAccountName(String original) {
        return this.withServiceAccountName(new String(original));
    }

    @Override
    public Boolean getSetHostnameAsFQDN() {
        return this.setHostnameAsFQDN;
    }

    @Override
    public A withSetHostnameAsFQDN(Boolean setHostnameAsFQDN) {
        this.setHostnameAsFQDN = setHostnameAsFQDN;
        return (A)this;
    }

    @Override
    public Boolean hasSetHostnameAsFQDN() {
        return this.setHostnameAsFQDN != null;
    }

    @Override
    public Boolean getShareProcessNamespace() {
        return this.shareProcessNamespace;
    }

    @Override
    public A withShareProcessNamespace(Boolean shareProcessNamespace) {
        this.shareProcessNamespace = shareProcessNamespace;
        return (A)this;
    }

    @Override
    public Boolean hasShareProcessNamespace() {
        return this.shareProcessNamespace != null;
    }

    @Override
    public String getSubdomain() {
        return this.subdomain;
    }

    @Override
    public A withSubdomain(String subdomain) {
        this.subdomain = subdomain;
        return (A)this;
    }

    @Override
    public Boolean hasSubdomain() {
        return this.subdomain != null;
    }

    @Override
    @Deprecated
    public A withNewSubdomain(String original) {
        return this.withSubdomain(new String(original));
    }

    @Override
    public Long getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    @Override
    public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds != null;
    }

    @Override
    public A addToTolerations(int index, V1Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<V1TolerationBuilder>();
        }
        V1TolerationBuilder builder = new V1TolerationBuilder(item);
        this._visitables.get("tolerations").add(index >= 0 ? index : this._visitables.get("tolerations").size(), builder);
        this.tolerations.add(index >= 0 ? index : this.tolerations.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTolerations(int index, V1Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<V1TolerationBuilder>();
        }
        V1TolerationBuilder builder = new V1TolerationBuilder(item);
        if (index < 0 || index >= this._visitables.get("tolerations").size()) {
            this._visitables.get("tolerations").add(builder);
        } else {
            this._visitables.get("tolerations").set(index, builder);
        }
        if (index < 0 || index >= this.tolerations.size()) {
            this.tolerations.add(builder);
        } else {
            this.tolerations.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTolerations(V1Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<V1TolerationBuilder>();
        }
        for (V1Toleration item : items) {
            V1TolerationBuilder builder = new V1TolerationBuilder(item);
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTolerations(Collection<V1Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<V1TolerationBuilder>();
        }
        for (V1Toleration item : items) {
            V1TolerationBuilder builder = new V1TolerationBuilder(item);
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTolerations(V1Toleration ... items) {
        for (V1Toleration item : items) {
            V1TolerationBuilder builder = new V1TolerationBuilder(item);
            this._visitables.get("tolerations").remove(builder);
            if (this.tolerations == null) continue;
            this.tolerations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTolerations(Collection<V1Toleration> items) {
        for (V1Toleration item : items) {
            V1TolerationBuilder builder = new V1TolerationBuilder(item);
            this._visitables.get("tolerations").remove(builder);
            if (this.tolerations == null) continue;
            this.tolerations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTolerations(Predicate<V1TolerationBuilder> predicate) {
        if (this.tolerations == null) {
            return (A)this;
        }
        Iterator<V1TolerationBuilder> each = this.tolerations.iterator();
        Object visitables = this._visitables.get("tolerations");
        while (each.hasNext()) {
            V1TolerationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1Toleration> getTolerations() {
        return V1PodSpecFluentImpl.build(this.tolerations);
    }

    @Override
    public List<V1Toleration> buildTolerations() {
        return V1PodSpecFluentImpl.build(this.tolerations);
    }

    @Override
    public V1Toleration buildToleration(int index) {
        return this.tolerations.get(index).build();
    }

    @Override
    public V1Toleration buildFirstToleration() {
        return this.tolerations.get(0).build();
    }

    @Override
    public V1Toleration buildLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1).build();
    }

    @Override
    public V1Toleration buildMatchingToleration(Predicate<V1TolerationBuilder> predicate) {
        for (V1TolerationBuilder item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingToleration(Predicate<V1TolerationBuilder> predicate) {
        for (V1TolerationBuilder item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTolerations(List<V1Toleration> tolerations) {
        if (this.tolerations != null) {
            this._visitables.get("tolerations").removeAll(this.tolerations);
        }
        if (tolerations != null) {
            this.tolerations = new ArrayList<V1TolerationBuilder>();
            for (V1Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)this;
    }

    @Override
    public A withTolerations(V1Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
        }
        if (tolerations != null) {
            for (V1Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    @Override
    public V1PodSpecFluent.TolerationsNested<A> addNewToleration() {
        return new TolerationsNestedImpl();
    }

    @Override
    public V1PodSpecFluent.TolerationsNested<A> addNewTolerationLike(V1Toleration item) {
        return new TolerationsNestedImpl(-1, item);
    }

    @Override
    public V1PodSpecFluent.TolerationsNested<A> setNewTolerationLike(int index, V1Toleration item) {
        return new TolerationsNestedImpl(index, item);
    }

    @Override
    public V1PodSpecFluent.TolerationsNested<A> editToleration(int index) {
        if (this.tolerations.size() <= index) {
            throw new RuntimeException("Can't edit tolerations. Index exceeds size.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    @Override
    public V1PodSpecFluent.TolerationsNested<A> editFirstToleration() {
        if (this.tolerations.size() == 0) {
            throw new RuntimeException("Can't edit first tolerations. The list is empty.");
        }
        return this.setNewTolerationLike(0, this.buildToleration(0));
    }

    @Override
    public V1PodSpecFluent.TolerationsNested<A> editLastToleration() {
        int index = this.tolerations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tolerations. The list is empty.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    @Override
    public V1PodSpecFluent.TolerationsNested<A> editMatchingToleration(Predicate<V1TolerationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tolerations.size(); ++i) {
            if (!predicate.test(this.tolerations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tolerations. No match found.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    @Override
    public A addToTopologySpreadConstraints(int index, V1TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<V1TopologySpreadConstraintBuilder>();
        }
        V1TopologySpreadConstraintBuilder builder = new V1TopologySpreadConstraintBuilder(item);
        this._visitables.get("topologySpreadConstraints").add(index >= 0 ? index : this._visitables.get("topologySpreadConstraints").size(), builder);
        this.topologySpreadConstraints.add(index >= 0 ? index : this.topologySpreadConstraints.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTopologySpreadConstraints(int index, V1TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<V1TopologySpreadConstraintBuilder>();
        }
        V1TopologySpreadConstraintBuilder builder = new V1TopologySpreadConstraintBuilder(item);
        if (index < 0 || index >= this._visitables.get("topologySpreadConstraints").size()) {
            this._visitables.get("topologySpreadConstraints").add(builder);
        } else {
            this._visitables.get("topologySpreadConstraints").set(index, builder);
        }
        if (index < 0 || index >= this.topologySpreadConstraints.size()) {
            this.topologySpreadConstraints.add(builder);
        } else {
            this.topologySpreadConstraints.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTopologySpreadConstraints(V1TopologySpreadConstraint ... items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<V1TopologySpreadConstraintBuilder>();
        }
        for (V1TopologySpreadConstraint item : items) {
            V1TopologySpreadConstraintBuilder builder = new V1TopologySpreadConstraintBuilder(item);
            this._visitables.get("topologySpreadConstraints").add(builder);
            this.topologySpreadConstraints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTopologySpreadConstraints(Collection<V1TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<V1TopologySpreadConstraintBuilder>();
        }
        for (V1TopologySpreadConstraint item : items) {
            V1TopologySpreadConstraintBuilder builder = new V1TopologySpreadConstraintBuilder(item);
            this._visitables.get("topologySpreadConstraints").add(builder);
            this.topologySpreadConstraints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTopologySpreadConstraints(V1TopologySpreadConstraint ... items) {
        for (V1TopologySpreadConstraint item : items) {
            V1TopologySpreadConstraintBuilder builder = new V1TopologySpreadConstraintBuilder(item);
            this._visitables.get("topologySpreadConstraints").remove(builder);
            if (this.topologySpreadConstraints == null) continue;
            this.topologySpreadConstraints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTopologySpreadConstraints(Collection<V1TopologySpreadConstraint> items) {
        for (V1TopologySpreadConstraint item : items) {
            V1TopologySpreadConstraintBuilder builder = new V1TopologySpreadConstraintBuilder(item);
            this._visitables.get("topologySpreadConstraints").remove(builder);
            if (this.topologySpreadConstraints == null) continue;
            this.topologySpreadConstraints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTopologySpreadConstraints(Predicate<V1TopologySpreadConstraintBuilder> predicate) {
        if (this.topologySpreadConstraints == null) {
            return (A)this;
        }
        Iterator<V1TopologySpreadConstraintBuilder> each = this.topologySpreadConstraints.iterator();
        Object visitables = this._visitables.get("topologySpreadConstraints");
        while (each.hasNext()) {
            V1TopologySpreadConstraintBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1TopologySpreadConstraint> getTopologySpreadConstraints() {
        return V1PodSpecFluentImpl.build(this.topologySpreadConstraints);
    }

    @Override
    public List<V1TopologySpreadConstraint> buildTopologySpreadConstraints() {
        return V1PodSpecFluentImpl.build(this.topologySpreadConstraints);
    }

    @Override
    public V1TopologySpreadConstraint buildTopologySpreadConstraint(int index) {
        return this.topologySpreadConstraints.get(index).build();
    }

    @Override
    public V1TopologySpreadConstraint buildFirstTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(0).build();
    }

    @Override
    public V1TopologySpreadConstraint buildLastTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(this.topologySpreadConstraints.size() - 1).build();
    }

    @Override
    public V1TopologySpreadConstraint buildMatchingTopologySpreadConstraint(Predicate<V1TopologySpreadConstraintBuilder> predicate) {
        for (V1TopologySpreadConstraintBuilder item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTopologySpreadConstraint(Predicate<V1TopologySpreadConstraintBuilder> predicate) {
        for (V1TopologySpreadConstraintBuilder item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTopologySpreadConstraints(List<V1TopologySpreadConstraint> topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this._visitables.get("topologySpreadConstraints").removeAll(this.topologySpreadConstraints);
        }
        if (topologySpreadConstraints != null) {
            this.topologySpreadConstraints = new ArrayList<V1TopologySpreadConstraintBuilder>();
            for (V1TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        } else {
            this.topologySpreadConstraints = null;
        }
        return (A)this;
    }

    @Override
    public A withTopologySpreadConstraints(V1TopologySpreadConstraint ... topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this.topologySpreadConstraints.clear();
        }
        if (topologySpreadConstraints != null) {
            for (V1TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTopologySpreadConstraints() {
        return this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty();
    }

    @Override
    public V1PodSpecFluent.TopologySpreadConstraintsNested<A> addNewTopologySpreadConstraint() {
        return new TopologySpreadConstraintsNestedImpl();
    }

    @Override
    public V1PodSpecFluent.TopologySpreadConstraintsNested<A> addNewTopologySpreadConstraintLike(V1TopologySpreadConstraint item) {
        return new TopologySpreadConstraintsNestedImpl(-1, item);
    }

    @Override
    public V1PodSpecFluent.TopologySpreadConstraintsNested<A> setNewTopologySpreadConstraintLike(int index, V1TopologySpreadConstraint item) {
        return new TopologySpreadConstraintsNestedImpl(index, item);
    }

    @Override
    public V1PodSpecFluent.TopologySpreadConstraintsNested<A> editTopologySpreadConstraint(int index) {
        if (this.topologySpreadConstraints.size() <= index) {
            throw new RuntimeException("Can't edit topologySpreadConstraints. Index exceeds size.");
        }
        return this.setNewTopologySpreadConstraintLike(index, this.buildTopologySpreadConstraint(index));
    }

    @Override
    public V1PodSpecFluent.TopologySpreadConstraintsNested<A> editFirstTopologySpreadConstraint() {
        if (this.topologySpreadConstraints.size() == 0) {
            throw new RuntimeException("Can't edit first topologySpreadConstraints. The list is empty.");
        }
        return this.setNewTopologySpreadConstraintLike(0, this.buildTopologySpreadConstraint(0));
    }

    @Override
    public V1PodSpecFluent.TopologySpreadConstraintsNested<A> editLastTopologySpreadConstraint() {
        int index = this.topologySpreadConstraints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last topologySpreadConstraints. The list is empty.");
        }
        return this.setNewTopologySpreadConstraintLike(index, this.buildTopologySpreadConstraint(index));
    }

    @Override
    public V1PodSpecFluent.TopologySpreadConstraintsNested<A> editMatchingTopologySpreadConstraint(Predicate<V1TopologySpreadConstraintBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.topologySpreadConstraints.size(); ++i) {
            if (!predicate.test(this.topologySpreadConstraints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching topologySpreadConstraints. No match found.");
        }
        return this.setNewTopologySpreadConstraintLike(index, this.buildTopologySpreadConstraint(index));
    }

    @Override
    public A addToVolumes(int index, V1Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<V1VolumeBuilder>();
        }
        V1VolumeBuilder builder = new V1VolumeBuilder(item);
        this._visitables.get("volumes").add(index >= 0 ? index : this._visitables.get("volumes").size(), builder);
        this.volumes.add(index >= 0 ? index : this.volumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumes(int index, V1Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<V1VolumeBuilder>();
        }
        V1VolumeBuilder builder = new V1VolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get("volumes").size()) {
            this._visitables.get("volumes").add(builder);
        } else {
            this._visitables.get("volumes").set(index, builder);
        }
        if (index < 0 || index >= this.volumes.size()) {
            this.volumes.add(builder);
        } else {
            this.volumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumes(V1Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<V1VolumeBuilder>();
        }
        for (V1Volume item : items) {
            V1VolumeBuilder builder = new V1VolumeBuilder(item);
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<V1Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<V1VolumeBuilder>();
        }
        for (V1Volume item : items) {
            V1VolumeBuilder builder = new V1VolumeBuilder(item);
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(V1Volume ... items) {
        for (V1Volume item : items) {
            V1VolumeBuilder builder = new V1VolumeBuilder(item);
            this._visitables.get("volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<V1Volume> items) {
        for (V1Volume item : items) {
            V1VolumeBuilder builder = new V1VolumeBuilder(item);
            this._visitables.get("volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVolumes(Predicate<V1VolumeBuilder> predicate) {
        if (this.volumes == null) {
            return (A)this;
        }
        Iterator<V1VolumeBuilder> each = this.volumes.iterator();
        Object visitables = this._visitables.get("volumes");
        while (each.hasNext()) {
            V1VolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1Volume> getVolumes() {
        return V1PodSpecFluentImpl.build(this.volumes);
    }

    @Override
    public List<V1Volume> buildVolumes() {
        return V1PodSpecFluentImpl.build(this.volumes);
    }

    @Override
    public V1Volume buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    @Override
    public V1Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    @Override
    public V1Volume buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    @Override
    public V1Volume buildMatchingVolume(Predicate<V1VolumeBuilder> predicate) {
        for (V1VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<V1VolumeBuilder> predicate) {
        for (V1VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<V1Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get("volumes").removeAll(this.volumes);
        }
        if (volumes != null) {
            this.volumes = new ArrayList<V1VolumeBuilder>();
            for (V1Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumes(V1Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
        }
        if (volumes != null) {
            for (V1Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    @Override
    public V1PodSpecFluent.VolumesNested<A> addNewVolume() {
        return new VolumesNestedImpl();
    }

    @Override
    public V1PodSpecFluent.VolumesNested<A> addNewVolumeLike(V1Volume item) {
        return new VolumesNestedImpl(-1, item);
    }

    @Override
    public V1PodSpecFluent.VolumesNested<A> setNewVolumeLike(int index, V1Volume item) {
        return new VolumesNestedImpl(index, item);
    }

    @Override
    public V1PodSpecFluent.VolumesNested<A> editVolume(int index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public V1PodSpecFluent.VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    @Override
    public V1PodSpecFluent.VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public V1PodSpecFluent.VolumesNested<A> editMatchingVolume(Predicate<V1VolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.test(this.volumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodSpecFluentImpl that = (V1PodSpecFluentImpl)o;
        if (this.activeDeadlineSeconds != null ? !this.activeDeadlineSeconds.equals(that.activeDeadlineSeconds) : that.activeDeadlineSeconds != null) {
            return false;
        }
        if (this.affinity != null ? !this.affinity.equals(that.affinity) : that.affinity != null) {
            return false;
        }
        if (this.automountServiceAccountToken != null ? !this.automountServiceAccountToken.equals(that.automountServiceAccountToken) : that.automountServiceAccountToken != null) {
            return false;
        }
        if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) {
            return false;
        }
        if (this.dnsConfig != null ? !this.dnsConfig.equals(that.dnsConfig) : that.dnsConfig != null) {
            return false;
        }
        if (this.dnsPolicy != null ? !this.dnsPolicy.equals(that.dnsPolicy) : that.dnsPolicy != null) {
            return false;
        }
        if (this.enableServiceLinks != null ? !this.enableServiceLinks.equals(that.enableServiceLinks) : that.enableServiceLinks != null) {
            return false;
        }
        if (this.ephemeralContainers != null ? !this.ephemeralContainers.equals(that.ephemeralContainers) : that.ephemeralContainers != null) {
            return false;
        }
        if (this.hostAliases != null ? !this.hostAliases.equals(that.hostAliases) : that.hostAliases != null) {
            return false;
        }
        if (this.hostIPC != null ? !this.hostIPC.equals(that.hostIPC) : that.hostIPC != null) {
            return false;
        }
        if (this.hostNetwork != null ? !this.hostNetwork.equals(that.hostNetwork) : that.hostNetwork != null) {
            return false;
        }
        if (this.hostPID != null ? !this.hostPID.equals(that.hostPID) : that.hostPID != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.imagePullSecrets != null ? !this.imagePullSecrets.equals(that.imagePullSecrets) : that.imagePullSecrets != null) {
            return false;
        }
        if (this.initContainers != null ? !this.initContainers.equals(that.initContainers) : that.initContainers != null) {
            return false;
        }
        if (this.nodeName != null ? !this.nodeName.equals(that.nodeName) : that.nodeName != null) {
            return false;
        }
        if (this.nodeSelector != null ? !this.nodeSelector.equals(that.nodeSelector) : that.nodeSelector != null) {
            return false;
        }
        if (this.overhead != null ? !this.overhead.equals(that.overhead) : that.overhead != null) {
            return false;
        }
        if (this.preemptionPolicy != null ? !this.preemptionPolicy.equals(that.preemptionPolicy) : that.preemptionPolicy != null) {
            return false;
        }
        if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) {
            return false;
        }
        if (this.priorityClassName != null ? !this.priorityClassName.equals(that.priorityClassName) : that.priorityClassName != null) {
            return false;
        }
        if (this.readinessGates != null ? !this.readinessGates.equals(that.readinessGates) : that.readinessGates != null) {
            return false;
        }
        if (this.restartPolicy != null ? !this.restartPolicy.equals(that.restartPolicy) : that.restartPolicy != null) {
            return false;
        }
        if (this.runtimeClassName != null ? !this.runtimeClassName.equals(that.runtimeClassName) : that.runtimeClassName != null) {
            return false;
        }
        if (this.schedulerName != null ? !this.schedulerName.equals(that.schedulerName) : that.schedulerName != null) {
            return false;
        }
        if (this.securityContext != null ? !this.securityContext.equals(that.securityContext) : that.securityContext != null) {
            return false;
        }
        if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) {
            return false;
        }
        if (this.serviceAccountName != null ? !this.serviceAccountName.equals(that.serviceAccountName) : that.serviceAccountName != null) {
            return false;
        }
        if (this.setHostnameAsFQDN != null ? !this.setHostnameAsFQDN.equals(that.setHostnameAsFQDN) : that.setHostnameAsFQDN != null) {
            return false;
        }
        if (this.shareProcessNamespace != null ? !this.shareProcessNamespace.equals(that.shareProcessNamespace) : that.shareProcessNamespace != null) {
            return false;
        }
        if (this.subdomain != null ? !this.subdomain.equals(that.subdomain) : that.subdomain != null) {
            return false;
        }
        if (this.terminationGracePeriodSeconds != null ? !this.terminationGracePeriodSeconds.equals(that.terminationGracePeriodSeconds) : that.terminationGracePeriodSeconds != null) {
            return false;
        }
        if (this.tolerations != null ? !this.tolerations.equals(that.tolerations) : that.tolerations != null) {
            return false;
        }
        if (this.topologySpreadConstraints != null ? !this.topologySpreadConstraints.equals(that.topologySpreadConstraints) : that.topologySpreadConstraints != null) {
            return false;
        }
        return !(this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null);
    }

    public int hashCode() {
        return Objects.hash(this.activeDeadlineSeconds, this.affinity, this.automountServiceAccountToken, this.containers, this.dnsConfig, this.dnsPolicy, this.enableServiceLinks, this.ephemeralContainers, this.hostAliases, this.hostIPC, this.hostNetwork, this.hostPID, this.hostname, this.imagePullSecrets, this.initContainers, this.nodeName, this.nodeSelector, this.overhead, this.preemptionPolicy, this.priority, this.priorityClassName, this.readinessGates, this.restartPolicy, this.runtimeClassName, this.schedulerName, this.securityContext, this.serviceAccount, this.serviceAccountName, this.setHostnameAsFQDN, this.shareProcessNamespace, this.subdomain, this.terminationGracePeriodSeconds, this.tolerations, this.topologySpreadConstraints, this.volumes, super.hashCode());
    }

    public class VolumesNestedImpl<N>
    extends V1VolumeFluentImpl<V1PodSpecFluent.VolumesNested<N>>
    implements V1PodSpecFluent.VolumesNested<N>,
    Nested<N> {
        private final V1VolumeBuilder builder;
        private final int index;

        VolumesNestedImpl(int index, V1Volume item) {
            this.index = index;
            this.builder = new V1VolumeBuilder(this, item);
        }

        VolumesNestedImpl() {
            this.index = -1;
            this.builder = new V1VolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluentImpl.this.setToVolumes(this.index, this.builder.build());
        }

        @Override
        public N endVolume() {
            return this.and();
        }
    }

    public class TopologySpreadConstraintsNestedImpl<N>
    extends V1TopologySpreadConstraintFluentImpl<V1PodSpecFluent.TopologySpreadConstraintsNested<N>>
    implements V1PodSpecFluent.TopologySpreadConstraintsNested<N>,
    Nested<N> {
        private final V1TopologySpreadConstraintBuilder builder;
        private final int index;

        TopologySpreadConstraintsNestedImpl(int index, V1TopologySpreadConstraint item) {
            this.index = index;
            this.builder = new V1TopologySpreadConstraintBuilder(this, item);
        }

        TopologySpreadConstraintsNestedImpl() {
            this.index = -1;
            this.builder = new V1TopologySpreadConstraintBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluentImpl.this.setToTopologySpreadConstraints(this.index, this.builder.build());
        }

        @Override
        public N endTopologySpreadConstraint() {
            return this.and();
        }
    }

    public class TolerationsNestedImpl<N>
    extends V1TolerationFluentImpl<V1PodSpecFluent.TolerationsNested<N>>
    implements V1PodSpecFluent.TolerationsNested<N>,
    Nested<N> {
        private final V1TolerationBuilder builder;
        private final int index;

        TolerationsNestedImpl(int index, V1Toleration item) {
            this.index = index;
            this.builder = new V1TolerationBuilder(this, item);
        }

        TolerationsNestedImpl() {
            this.index = -1;
            this.builder = new V1TolerationBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluentImpl.this.setToTolerations(this.index, this.builder.build());
        }

        @Override
        public N endToleration() {
            return this.and();
        }
    }

    public class SecurityContextNestedImpl<N>
    extends V1PodSecurityContextFluentImpl<V1PodSpecFluent.SecurityContextNested<N>>
    implements V1PodSpecFluent.SecurityContextNested<N>,
    Nested<N> {
        private final V1PodSecurityContextBuilder builder;

        SecurityContextNestedImpl(V1PodSecurityContext item) {
            this.builder = new V1PodSecurityContextBuilder(this, item);
        }

        SecurityContextNestedImpl() {
            this.builder = new V1PodSecurityContextBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluentImpl.this.withSecurityContext(this.builder.build());
        }

        @Override
        public N endSecurityContext() {
            return this.and();
        }
    }

    public class ReadinessGatesNestedImpl<N>
    extends V1PodReadinessGateFluentImpl<V1PodSpecFluent.ReadinessGatesNested<N>>
    implements V1PodSpecFluent.ReadinessGatesNested<N>,
    Nested<N> {
        private final V1PodReadinessGateBuilder builder;
        private final int index;

        ReadinessGatesNestedImpl(int index, V1PodReadinessGate item) {
            this.index = index;
            this.builder = new V1PodReadinessGateBuilder(this, item);
        }

        ReadinessGatesNestedImpl() {
            this.index = -1;
            this.builder = new V1PodReadinessGateBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluentImpl.this.setToReadinessGates(this.index, this.builder.build());
        }

        @Override
        public N endReadinessGate() {
            return this.and();
        }
    }

    public class InitContainersNestedImpl<N>
    extends V1ContainerFluentImpl<V1PodSpecFluent.InitContainersNested<N>>
    implements V1PodSpecFluent.InitContainersNested<N>,
    Nested<N> {
        private final V1ContainerBuilder builder;
        private final int index;

        InitContainersNestedImpl(int index, V1Container item) {
            this.index = index;
            this.builder = new V1ContainerBuilder(this, item);
        }

        InitContainersNestedImpl() {
            this.index = -1;
            this.builder = new V1ContainerBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluentImpl.this.setToInitContainers(this.index, this.builder.build());
        }

        @Override
        public N endInitContainer() {
            return this.and();
        }
    }

    public class ImagePullSecretsNestedImpl<N>
    extends V1LocalObjectReferenceFluentImpl<V1PodSpecFluent.ImagePullSecretsNested<N>>
    implements V1PodSpecFluent.ImagePullSecretsNested<N>,
    Nested<N> {
        private final V1LocalObjectReferenceBuilder builder;
        private final int index;

        ImagePullSecretsNestedImpl(int index, V1LocalObjectReference item) {
            this.index = index;
            this.builder = new V1LocalObjectReferenceBuilder(this, item);
        }

        ImagePullSecretsNestedImpl() {
            this.index = -1;
            this.builder = new V1LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluentImpl.this.setToImagePullSecrets(this.index, this.builder.build());
        }

        @Override
        public N endImagePullSecret() {
            return this.and();
        }
    }

    public class HostAliasesNestedImpl<N>
    extends V1HostAliasFluentImpl<V1PodSpecFluent.HostAliasesNested<N>>
    implements V1PodSpecFluent.HostAliasesNested<N>,
    Nested<N> {
        private final V1HostAliasBuilder builder;
        private final int index;

        HostAliasesNestedImpl(int index, V1HostAlias item) {
            this.index = index;
            this.builder = new V1HostAliasBuilder(this, item);
        }

        HostAliasesNestedImpl() {
            this.index = -1;
            this.builder = new V1HostAliasBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluentImpl.this.setToHostAliases(this.index, this.builder.build());
        }

        @Override
        public N endHostAlias() {
            return this.and();
        }
    }

    public class EphemeralContainersNestedImpl<N>
    extends V1EphemeralContainerFluentImpl<V1PodSpecFluent.EphemeralContainersNested<N>>
    implements V1PodSpecFluent.EphemeralContainersNested<N>,
    Nested<N> {
        private final V1EphemeralContainerBuilder builder;
        private final int index;

        EphemeralContainersNestedImpl(int index, V1EphemeralContainer item) {
            this.index = index;
            this.builder = new V1EphemeralContainerBuilder(this, item);
        }

        EphemeralContainersNestedImpl() {
            this.index = -1;
            this.builder = new V1EphemeralContainerBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluentImpl.this.setToEphemeralContainers(this.index, this.builder.build());
        }

        @Override
        public N endEphemeralContainer() {
            return this.and();
        }
    }

    public class DnsConfigNestedImpl<N>
    extends V1PodDNSConfigFluentImpl<V1PodSpecFluent.DnsConfigNested<N>>
    implements V1PodSpecFluent.DnsConfigNested<N>,
    Nested<N> {
        private final V1PodDNSConfigBuilder builder;

        DnsConfigNestedImpl(V1PodDNSConfig item) {
            this.builder = new V1PodDNSConfigBuilder(this, item);
        }

        DnsConfigNestedImpl() {
            this.builder = new V1PodDNSConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluentImpl.this.withDnsConfig(this.builder.build());
        }

        @Override
        public N endDnsConfig() {
            return this.and();
        }
    }

    public class ContainersNestedImpl<N>
    extends V1ContainerFluentImpl<V1PodSpecFluent.ContainersNested<N>>
    implements V1PodSpecFluent.ContainersNested<N>,
    Nested<N> {
        private final V1ContainerBuilder builder;
        private final int index;

        ContainersNestedImpl(int index, V1Container item) {
            this.index = index;
            this.builder = new V1ContainerBuilder(this, item);
        }

        ContainersNestedImpl() {
            this.index = -1;
            this.builder = new V1ContainerBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluentImpl.this.setToContainers(this.index, this.builder.build());
        }

        @Override
        public N endContainer() {
            return this.and();
        }
    }

    public class AffinityNestedImpl<N>
    extends V1AffinityFluentImpl<V1PodSpecFluent.AffinityNested<N>>
    implements V1PodSpecFluent.AffinityNested<N>,
    Nested<N> {
        private final V1AffinityBuilder builder;

        AffinityNestedImpl(V1Affinity item) {
            this.builder = new V1AffinityBuilder(this, item);
        }

        AffinityNestedImpl() {
            this.builder = new V1AffinityBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluentImpl.this.withAffinity(this.builder.build());
        }

        @Override
        public N endAffinity() {
            return this.and();
        }
    }
}

