/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1PodDNSConfig;
import io.kubernetes.client.openapi.models.V1PodDNSConfigFluent;
import io.kubernetes.client.openapi.models.V1PodDNSConfigOption;
import io.kubernetes.client.openapi.models.V1PodDNSConfigOptionBuilder;
import io.kubernetes.client.openapi.models.V1PodDNSConfigOptionFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1PodDNSConfigFluentImpl<A extends V1PodDNSConfigFluent<A>>
extends BaseFluent<A>
implements V1PodDNSConfigFluent<A> {
    private List<String> nameservers;
    private List<V1PodDNSConfigOptionBuilder> options;
    private List<String> searches;

    public V1PodDNSConfigFluentImpl() {
    }

    public V1PodDNSConfigFluentImpl(V1PodDNSConfig instance) {
        this.withNameservers(instance.getNameservers());
        this.withOptions(instance.getOptions());
        this.withSearches(instance.getSearches());
    }

    @Override
    public A addToNameservers(int index, String item) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNameservers(int index, String item) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNameservers(String ... items) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameservers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNameservers(Collection<String> items) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameservers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNameservers(String ... items) {
        for (String item : items) {
            if (this.nameservers == null) continue;
            this.nameservers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNameservers(Collection<String> items) {
        for (String item : items) {
            if (this.nameservers == null) continue;
            this.nameservers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNameservers() {
        return this.nameservers;
    }

    @Override
    public String getNameserver(int index) {
        return this.nameservers.get(index);
    }

    @Override
    public String getFirstNameserver() {
        return this.nameservers.get(0);
    }

    @Override
    public String getLastNameserver() {
        return this.nameservers.get(this.nameservers.size() - 1);
    }

    @Override
    public String getMatchingNameserver(Predicate<String> predicate) {
        for (String item : this.nameservers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNameserver(Predicate<String> predicate) {
        for (String item : this.nameservers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNameservers(List<String> nameservers) {
        if (this.nameservers != null) {
            this._visitables.get("nameservers").removeAll(this.nameservers);
        }
        if (nameservers != null) {
            this.nameservers = new ArrayList<String>();
            for (String item : nameservers) {
                this.addToNameservers(item);
            }
        } else {
            this.nameservers = null;
        }
        return (A)this;
    }

    @Override
    public A withNameservers(String ... nameservers) {
        if (this.nameservers != null) {
            this.nameservers.clear();
        }
        if (nameservers != null) {
            for (String item : nameservers) {
                this.addToNameservers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNameservers() {
        return this.nameservers != null && !this.nameservers.isEmpty();
    }

    @Override
    public A addNewNameserver(String original) {
        return this.addToNameservers(new String(original));
    }

    @Override
    public A addToOptions(int index, V1PodDNSConfigOption item) {
        if (this.options == null) {
            this.options = new ArrayList<V1PodDNSConfigOptionBuilder>();
        }
        V1PodDNSConfigOptionBuilder builder = new V1PodDNSConfigOptionBuilder(item);
        this._visitables.get("options").add(index >= 0 ? index : this._visitables.get("options").size(), builder);
        this.options.add(index >= 0 ? index : this.options.size(), builder);
        return (A)this;
    }

    @Override
    public A setToOptions(int index, V1PodDNSConfigOption item) {
        if (this.options == null) {
            this.options = new ArrayList<V1PodDNSConfigOptionBuilder>();
        }
        V1PodDNSConfigOptionBuilder builder = new V1PodDNSConfigOptionBuilder(item);
        if (index < 0 || index >= this._visitables.get("options").size()) {
            this._visitables.get("options").add(builder);
        } else {
            this._visitables.get("options").set(index, builder);
        }
        if (index < 0 || index >= this.options.size()) {
            this.options.add(builder);
        } else {
            this.options.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToOptions(V1PodDNSConfigOption ... items) {
        if (this.options == null) {
            this.options = new ArrayList<V1PodDNSConfigOptionBuilder>();
        }
        for (V1PodDNSConfigOption item : items) {
            V1PodDNSConfigOptionBuilder builder = new V1PodDNSConfigOptionBuilder(item);
            this._visitables.get("options").add(builder);
            this.options.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToOptions(Collection<V1PodDNSConfigOption> items) {
        if (this.options == null) {
            this.options = new ArrayList<V1PodDNSConfigOptionBuilder>();
        }
        for (V1PodDNSConfigOption item : items) {
            V1PodDNSConfigOptionBuilder builder = new V1PodDNSConfigOptionBuilder(item);
            this._visitables.get("options").add(builder);
            this.options.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromOptions(V1PodDNSConfigOption ... items) {
        for (V1PodDNSConfigOption item : items) {
            V1PodDNSConfigOptionBuilder builder = new V1PodDNSConfigOptionBuilder(item);
            this._visitables.get("options").remove(builder);
            if (this.options == null) continue;
            this.options.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOptions(Collection<V1PodDNSConfigOption> items) {
        for (V1PodDNSConfigOption item : items) {
            V1PodDNSConfigOptionBuilder builder = new V1PodDNSConfigOptionBuilder(item);
            this._visitables.get("options").remove(builder);
            if (this.options == null) continue;
            this.options.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromOptions(Predicate<V1PodDNSConfigOptionBuilder> predicate) {
        if (this.options == null) {
            return (A)this;
        }
        Iterator<V1PodDNSConfigOptionBuilder> each = this.options.iterator();
        Object visitables = this._visitables.get("options");
        while (each.hasNext()) {
            V1PodDNSConfigOptionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1PodDNSConfigOption> getOptions() {
        return V1PodDNSConfigFluentImpl.build(this.options);
    }

    @Override
    public List<V1PodDNSConfigOption> buildOptions() {
        return V1PodDNSConfigFluentImpl.build(this.options);
    }

    @Override
    public V1PodDNSConfigOption buildOption(int index) {
        return this.options.get(index).build();
    }

    @Override
    public V1PodDNSConfigOption buildFirstOption() {
        return this.options.get(0).build();
    }

    @Override
    public V1PodDNSConfigOption buildLastOption() {
        return this.options.get(this.options.size() - 1).build();
    }

    @Override
    public V1PodDNSConfigOption buildMatchingOption(Predicate<V1PodDNSConfigOptionBuilder> predicate) {
        for (V1PodDNSConfigOptionBuilder item : this.options) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingOption(Predicate<V1PodDNSConfigOptionBuilder> predicate) {
        for (V1PodDNSConfigOptionBuilder item : this.options) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withOptions(List<V1PodDNSConfigOption> options) {
        if (this.options != null) {
            this._visitables.get("options").removeAll(this.options);
        }
        if (options != null) {
            this.options = new ArrayList<V1PodDNSConfigOptionBuilder>();
            for (V1PodDNSConfigOption item : options) {
                this.addToOptions(item);
            }
        } else {
            this.options = null;
        }
        return (A)this;
    }

    @Override
    public A withOptions(V1PodDNSConfigOption ... options) {
        if (this.options != null) {
            this.options.clear();
        }
        if (options != null) {
            for (V1PodDNSConfigOption item : options) {
                this.addToOptions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOptions() {
        return this.options != null && !this.options.isEmpty();
    }

    @Override
    public V1PodDNSConfigFluent.OptionsNested<A> addNewOption() {
        return new OptionsNestedImpl();
    }

    @Override
    public V1PodDNSConfigFluent.OptionsNested<A> addNewOptionLike(V1PodDNSConfigOption item) {
        return new OptionsNestedImpl(-1, item);
    }

    @Override
    public V1PodDNSConfigFluent.OptionsNested<A> setNewOptionLike(int index, V1PodDNSConfigOption item) {
        return new OptionsNestedImpl(index, item);
    }

    @Override
    public V1PodDNSConfigFluent.OptionsNested<A> editOption(int index) {
        if (this.options.size() <= index) {
            throw new RuntimeException("Can't edit options. Index exceeds size.");
        }
        return this.setNewOptionLike(index, this.buildOption(index));
    }

    @Override
    public V1PodDNSConfigFluent.OptionsNested<A> editFirstOption() {
        if (this.options.size() == 0) {
            throw new RuntimeException("Can't edit first options. The list is empty.");
        }
        return this.setNewOptionLike(0, this.buildOption(0));
    }

    @Override
    public V1PodDNSConfigFluent.OptionsNested<A> editLastOption() {
        int index = this.options.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last options. The list is empty.");
        }
        return this.setNewOptionLike(index, this.buildOption(index));
    }

    @Override
    public V1PodDNSConfigFluent.OptionsNested<A> editMatchingOption(Predicate<V1PodDNSConfigOptionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.options.size(); ++i) {
            if (!predicate.test(this.options.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching options. No match found.");
        }
        return this.setNewOptionLike(index, this.buildOption(index));
    }

    @Override
    public A addToSearches(int index, String item) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        this.searches.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSearches(int index, String item) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        this.searches.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSearches(String ... items) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        for (String item : items) {
            this.searches.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSearches(Collection<String> items) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        for (String item : items) {
            this.searches.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSearches(String ... items) {
        for (String item : items) {
            if (this.searches == null) continue;
            this.searches.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSearches(Collection<String> items) {
        for (String item : items) {
            if (this.searches == null) continue;
            this.searches.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSearches() {
        return this.searches;
    }

    @Override
    public String getSearch(int index) {
        return this.searches.get(index);
    }

    @Override
    public String getFirstSearch() {
        return this.searches.get(0);
    }

    @Override
    public String getLastSearch() {
        return this.searches.get(this.searches.size() - 1);
    }

    @Override
    public String getMatchingSearch(Predicate<String> predicate) {
        for (String item : this.searches) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSearch(Predicate<String> predicate) {
        for (String item : this.searches) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSearches(List<String> searches) {
        if (this.searches != null) {
            this._visitables.get("searches").removeAll(this.searches);
        }
        if (searches != null) {
            this.searches = new ArrayList<String>();
            for (String item : searches) {
                this.addToSearches(item);
            }
        } else {
            this.searches = null;
        }
        return (A)this;
    }

    @Override
    public A withSearches(String ... searches) {
        if (this.searches != null) {
            this.searches.clear();
        }
        if (searches != null) {
            for (String item : searches) {
                this.addToSearches(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSearches() {
        return this.searches != null && !this.searches.isEmpty();
    }

    @Override
    public A addNewSearch(String original) {
        return this.addToSearches(new String(original));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodDNSConfigFluentImpl that = (V1PodDNSConfigFluentImpl)o;
        if (this.nameservers != null ? !this.nameservers.equals(that.nameservers) : that.nameservers != null) {
            return false;
        }
        if (this.options != null ? !this.options.equals(that.options) : that.options != null) {
            return false;
        }
        return !(this.searches != null ? !this.searches.equals(that.searches) : that.searches != null);
    }

    public int hashCode() {
        return Objects.hash(this.nameservers, this.options, this.searches, super.hashCode());
    }

    public class OptionsNestedImpl<N>
    extends V1PodDNSConfigOptionFluentImpl<V1PodDNSConfigFluent.OptionsNested<N>>
    implements V1PodDNSConfigFluent.OptionsNested<N>,
    Nested<N> {
        private final V1PodDNSConfigOptionBuilder builder;
        private final int index;

        OptionsNestedImpl(int index, V1PodDNSConfigOption item) {
            this.index = index;
            this.builder = new V1PodDNSConfigOptionBuilder(this, item);
        }

        OptionsNestedImpl() {
            this.index = -1;
            this.builder = new V1PodDNSConfigOptionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodDNSConfigFluentImpl.this.setToOptions(this.index, this.builder.build());
        }

        @Override
        public N endOption() {
            return this.and();
        }
    }
}

