/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.implementation.MetricAlertConditionBaseImpl;
import com.azure.resourcemanager.monitor.implementation.MetricAlertImpl;
import com.azure.resourcemanager.monitor.models.AggregationTypeEnum;
import com.azure.resourcemanager.monitor.models.DynamicMetricCriteria;
import com.azure.resourcemanager.monitor.models.DynamicThresholdFailingPeriods;
import com.azure.resourcemanager.monitor.models.DynamicThresholdOperator;
import com.azure.resourcemanager.monitor.models.DynamicThresholdSensitivity;
import com.azure.resourcemanager.monitor.models.MetricAlert;
import com.azure.resourcemanager.monitor.models.MetricAlertRuleTimeAggregation;
import com.azure.resourcemanager.monitor.models.MetricDynamicAlertCondition;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

class MetricDynamicAlertConditionImpl
extends MetricAlertConditionBaseImpl<DynamicMetricCriteria, MetricDynamicAlertConditionImpl>
implements MetricDynamicAlertCondition,
MetricDynamicAlertCondition.DefinitionStages,
MetricDynamicAlertCondition.DefinitionStages.Blank.MetricName<MetricAlert.DefinitionStages.WithCreate>,
MetricDynamicAlertCondition.DefinitionStages.WithCriteriaOperator<MetricAlert.DefinitionStages.WithCreate>,
MetricDynamicAlertCondition.DefinitionStages.WithFailingPeriods<MetricAlert.DefinitionStages.WithCreate>,
MetricDynamicAlertCondition.DefinitionStages.WithConditionAttach<MetricAlert.DefinitionStages.WithCreate>,
MetricDynamicAlertCondition.UpdateDefinitionStages,
MetricDynamicAlertCondition.UpdateDefinitionStages.Blank.MetricName<MetricAlert.Update>,
MetricDynamicAlertCondition.UpdateDefinitionStages.WithCriteriaOperator<MetricAlert.Update>,
MetricDynamicAlertCondition.UpdateDefinitionStages.WithFailingPeriods<MetricAlert.Update>,
MetricDynamicAlertCondition.UpdateDefinitionStages.WithConditionAttach<MetricAlert.Update>,
MetricDynamicAlertCondition.UpdateStages {
    private final ClientLogger logger = new ClientLogger(this.getClass());

    MetricDynamicAlertConditionImpl(String name, DynamicMetricCriteria innerObject, MetricAlertImpl parent) {
        super(name, innerObject, parent);
    }

    @Override
    public DynamicThresholdOperator condition() {
        return DynamicThresholdOperator.fromString(((DynamicMetricCriteria)this.innerModel()).operator().toString());
    }

    @Override
    public DynamicThresholdSensitivity alertSensitivity() {
        return DynamicThresholdSensitivity.fromString(((DynamicMetricCriteria)this.innerModel()).alertSensitivity().toString());
    }

    @Override
    public DynamicThresholdFailingPeriods failingPeriods() {
        return ((DynamicMetricCriteria)this.innerModel()).failingPeriods();
    }

    @Override
    public OffsetDateTime ignoreDataBefore() {
        return ((DynamicMetricCriteria)this.innerModel()).ignoreDataBefore();
    }

    @Override
    public MetricAlertImpl attach() {
        ((DynamicMetricCriteria)this.innerModel()).withDimensions((List)new ArrayList(this.dimensions.values()));
        return ((MetricAlertImpl)this.parent()).withDynamicAlertCriteria(this);
    }

    @Override
    public MetricDynamicAlertConditionImpl withCondition(MetricAlertRuleTimeAggregation timeAggregation, DynamicThresholdOperator condition, DynamicThresholdSensitivity alertSensitivity) {
        ((DynamicMetricCriteria)this.innerModel()).withOperator(condition);
        ((DynamicMetricCriteria)this.innerModel()).withTimeAggregation(AggregationTypeEnum.fromString(timeAggregation.toString()));
        ((DynamicMetricCriteria)this.innerModel()).withAlertSensitivity(alertSensitivity);
        return this;
    }

    @Override
    public MetricDynamicAlertConditionImpl withFailingPeriods(DynamicThresholdFailingPeriods failingPeriods) {
        if (failingPeriods.minFailingPeriodsToAlert() > failingPeriods.numberOfEvaluationPeriods()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The number of evaluation periods should be greater than or equal to the number of failing periods"));
        }
        ((DynamicMetricCriteria)this.innerModel()).withFailingPeriods(failingPeriods);
        return this;
    }

    @Override
    public MetricDynamicAlertConditionImpl withIgnoreDataBefore(OffsetDateTime date) {
        ((DynamicMetricCriteria)this.innerModel()).withIgnoreDataBefore(date);
        return this;
    }

    @Override
    public MetricDynamicAlertConditionImpl withoutIgnoreDataBefore() {
        ((DynamicMetricCriteria)this.innerModel()).withIgnoreDataBefore(null);
        return this;
    }
}

