/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.keyvault.models.AccessPolicyEntry;
import com.azure.resourcemanager.keyvault.models.CreateMode;
import com.azure.resourcemanager.keyvault.models.NetworkRuleSet;
import com.azure.resourcemanager.keyvault.models.PrivateEndpointConnectionItem;
import com.azure.resourcemanager.keyvault.models.Sku;
import com.azure.resourcemanager.keyvault.models.VaultProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.UUID;

public final class VaultProperties {
    @JsonProperty(value="tenantId", required=true)
    private UUID tenantId;
    @JsonProperty(value="sku", required=true)
    private Sku sku;
    @JsonProperty(value="accessPolicies")
    private List<AccessPolicyEntry> accessPolicies;
    @JsonProperty(value="vaultUri")
    private String vaultUri;
    @JsonProperty(value="hsmPoolResourceId", access=JsonProperty.Access.WRITE_ONLY)
    private String hsmPoolResourceId;
    @JsonProperty(value="enabledForDeployment")
    private Boolean enabledForDeployment;
    @JsonProperty(value="enabledForDiskEncryption")
    private Boolean enabledForDiskEncryption;
    @JsonProperty(value="enabledForTemplateDeployment")
    private Boolean enabledForTemplateDeployment;
    @JsonProperty(value="enableSoftDelete")
    private Boolean enableSoftDelete;
    @JsonProperty(value="softDeleteRetentionInDays")
    private Integer softDeleteRetentionInDays;
    @JsonProperty(value="enableRbacAuthorization")
    private Boolean enableRbacAuthorization;
    @JsonProperty(value="createMode")
    private CreateMode createMode;
    @JsonProperty(value="enablePurgeProtection")
    private Boolean enablePurgeProtection;
    @JsonProperty(value="networkAcls")
    private NetworkRuleSet networkAcls;
    @JsonProperty(value="provisioningState")
    private VaultProvisioningState provisioningState;
    @JsonProperty(value="privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<PrivateEndpointConnectionItem> privateEndpointConnections;
    @JsonProperty(value="publicNetworkAccess")
    private String publicNetworkAccess;
    private static final ClientLogger LOGGER = new ClientLogger(VaultProperties.class);

    public UUID tenantId() {
        return this.tenantId;
    }

    public VaultProperties withTenantId(UUID tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public VaultProperties withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public List<AccessPolicyEntry> accessPolicies() {
        return this.accessPolicies;
    }

    public VaultProperties withAccessPolicies(List<AccessPolicyEntry> accessPolicies) {
        this.accessPolicies = accessPolicies;
        return this;
    }

    public String vaultUri() {
        return this.vaultUri;
    }

    public VaultProperties withVaultUri(String vaultUri) {
        this.vaultUri = vaultUri;
        return this;
    }

    public String hsmPoolResourceId() {
        return this.hsmPoolResourceId;
    }

    public Boolean enabledForDeployment() {
        return this.enabledForDeployment;
    }

    public VaultProperties withEnabledForDeployment(Boolean enabledForDeployment) {
        this.enabledForDeployment = enabledForDeployment;
        return this;
    }

    public Boolean enabledForDiskEncryption() {
        return this.enabledForDiskEncryption;
    }

    public VaultProperties withEnabledForDiskEncryption(Boolean enabledForDiskEncryption) {
        this.enabledForDiskEncryption = enabledForDiskEncryption;
        return this;
    }

    public Boolean enabledForTemplateDeployment() {
        return this.enabledForTemplateDeployment;
    }

    public VaultProperties withEnabledForTemplateDeployment(Boolean enabledForTemplateDeployment) {
        this.enabledForTemplateDeployment = enabledForTemplateDeployment;
        return this;
    }

    public Boolean enableSoftDelete() {
        return this.enableSoftDelete;
    }

    public VaultProperties withEnableSoftDelete(Boolean enableSoftDelete) {
        this.enableSoftDelete = enableSoftDelete;
        return this;
    }

    public Integer softDeleteRetentionInDays() {
        return this.softDeleteRetentionInDays;
    }

    public VaultProperties withSoftDeleteRetentionInDays(Integer softDeleteRetentionInDays) {
        this.softDeleteRetentionInDays = softDeleteRetentionInDays;
        return this;
    }

    public Boolean enableRbacAuthorization() {
        return this.enableRbacAuthorization;
    }

    public VaultProperties withEnableRbacAuthorization(Boolean enableRbacAuthorization) {
        this.enableRbacAuthorization = enableRbacAuthorization;
        return this;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public VaultProperties withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public Boolean enablePurgeProtection() {
        return this.enablePurgeProtection;
    }

    public VaultProperties withEnablePurgeProtection(Boolean enablePurgeProtection) {
        this.enablePurgeProtection = enablePurgeProtection;
        return this;
    }

    public NetworkRuleSet networkAcls() {
        return this.networkAcls;
    }

    public VaultProperties withNetworkAcls(NetworkRuleSet networkAcls) {
        this.networkAcls = networkAcls;
        return this;
    }

    public VaultProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public VaultProperties withProvisioningState(VaultProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public List<PrivateEndpointConnectionItem> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public String publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public VaultProperties withPublicNetworkAccess(String publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public void validate() {
        if (this.tenantId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property tenantId in model VaultProperties"));
        }
        if (this.sku() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sku in model VaultProperties"));
        }
        this.sku().validate();
        if (this.accessPolicies() != null) {
            this.accessPolicies().forEach(e -> e.validate());
        }
        if (this.networkAcls() != null) {
            this.networkAcls().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }
}

