/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.graph;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAG<Node, NodeInfo, EdgeInfo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DAG.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<Node, NodeInfo> nodesMap = new HashMap<Node, NodeInfo>();
    private final Map<Node, Map<Node, EdgeInfo>> edgesMap = new HashMap<Node, Map<Node, EdgeInfo>>();
    private final Map<Node, Map<Node, EdgeInfo>> reverseEdgesMap = new HashMap<Node, Map<Node, EdgeInfo>>();

    public void addNode(Node node, NodeInfo nodeInfo) {
        this.lock.writeLock().lock();
        try {
            this.nodesMap.put(node, nodeInfo);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean addEdge(Node fromNode, Node toNode) {
        return this.addEdge(fromNode, toNode, false);
    }

    private boolean addEdge(Node fromNode, Node toNode, boolean createNode) {
        return this.addEdge(fromNode, toNode, null, createNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEdge(Node fromNode, Node toNode, EdgeInfo edge, boolean createNode) {
        this.lock.writeLock().lock();
        try {
            if (!this.isLegalAddEdge(fromNode, toNode, createNode)) {
                log.error("serious error: add edge({} -> {}) is invalid, cause cycle\uff01", fromNode, toNode);
                boolean bl = false;
                return bl;
            }
            this.addNodeIfAbsent(fromNode, null);
            this.addNodeIfAbsent(toNode, null);
            this.addEdge(fromNode, toNode, edge, this.edgesMap);
            this.addEdge(toNode, fromNode, edge, this.reverseEdgesMap);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean containsNode(Node node) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.nodesMap.containsKey(node);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEdge(Node fromNode, Node toNode) {
        this.lock.readLock().lock();
        try {
            Map<Node, EdgeInfo> endEdges = this.edgesMap.get(fromNode);
            if (endEdges == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = endEdges.containsKey(toNode);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public NodeInfo getNode(Node node) {
        this.lock.readLock().lock();
        try {
            NodeInfo NodeInfo = this.nodesMap.get(node);
            return NodeInfo;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getNodesCount() {
        this.lock.readLock().lock();
        try {
            int n = this.nodesMap.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEdgesCount() {
        this.lock.readLock().lock();
        try {
            int count = 0;
            for (Map.Entry<Node, Map<Node, EdgeInfo>> entry : this.edgesMap.entrySet()) {
                count += entry.getValue().size();
            }
            int n = count;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<Node> getBeginNode() {
        this.lock.readLock().lock();
        try {
            Collection collection = CollectionUtils.subtract(this.nodesMap.keySet(), this.reverseEdgesMap.keySet());
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<Node> getEndNode() {
        this.lock.readLock().lock();
        try {
            Collection collection = CollectionUtils.subtract(this.nodesMap.keySet(), this.edgesMap.keySet());
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<Node> getPreviousNodes(Node node) {
        this.lock.readLock().lock();
        try {
            Set<Node> set = this.getNeighborNodes(node, this.reverseEdgesMap);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<Node> getSubsequentNodes(Node node) {
        this.lock.readLock().lock();
        try {
            Set<Node> set = this.getNeighborNodes(node, this.edgesMap);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getIndegree(Node node) {
        this.lock.readLock().lock();
        try {
            int n = this.getPreviousNodes(node).size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean hasCycle() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.topologicalSortImpl().getKey() == false;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<Node> topologicalSort() throws Exception {
        this.lock.readLock().lock();
        try {
            Map.Entry<Boolean, List<Node>> entry = this.topologicalSortImpl();
            if (entry.getKey().booleanValue()) {
                List<Node> list = entry.getValue();
                return list;
            }
            throw new Exception("serious error: graph has cycle ! ");
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void addNodeIfAbsent(Node node, NodeInfo nodeInfo) {
        if (!this.containsNode(node)) {
            this.addNode(node, nodeInfo);
        }
    }

    private void addEdge(Node fromNode, Node toNode, EdgeInfo edge, Map<Node, Map<Node, EdgeInfo>> edges) {
        edges.putIfAbsent(fromNode, new HashMap());
        Map<Node, EdgeInfo> toNodeEdges = edges.get(fromNode);
        toNodeEdges.put(toNode, edge);
    }

    private boolean isLegalAddEdge(Node fromNode, Node toNode, boolean createNode) {
        if (fromNode.equals(toNode)) {
            log.error("edge fromNode({}) can't equals toNode({})", fromNode, toNode);
            return false;
        }
        if (!(createNode || this.containsNode(fromNode) && this.containsNode(toNode))) {
            log.error("edge fromNode({}) or toNode({}) is not in vertices map", fromNode, toNode);
            return false;
        }
        int verticesCount = this.getNodesCount();
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.add(toNode);
        while (!queue.isEmpty() && --verticesCount > 0) {
            Object key = queue.poll();
            for (Object subsequentNode : this.getSubsequentNodes(key)) {
                if (subsequentNode.equals(fromNode)) {
                    return false;
                }
                queue.add(subsequentNode);
            }
        }
        return true;
    }

    private Set<Node> getNeighborNodes(Node node, Map<Node, Map<Node, EdgeInfo>> edges) {
        Map<Node, EdgeInfo> neighborEdges = edges.get(node);
        if (neighborEdges == null) {
            return Collections.emptySet();
        }
        return neighborEdges.keySet();
    }

    private Map.Entry<Boolean, List<Node>> topologicalSortImpl() {
        LinkedList<Object> zeroIndegreeNodeQueue = new LinkedList<Object>();
        ArrayList<Object> topoResultList = new ArrayList<Object>();
        HashMap<Object, Integer> notZeroIndegreeNodeMap = new HashMap<Object, Integer>();
        for (Map.Entry<Node, NodeInfo> vertices : this.nodesMap.entrySet()) {
            Node node = vertices.getKey();
            int inDegree = this.getIndegree(node);
            if (inDegree == 0) {
                zeroIndegreeNodeQueue.add(node);
                topoResultList.add(node);
                continue;
            }
            notZeroIndegreeNodeMap.put(node, inDegree);
        }
        if (zeroIndegreeNodeQueue.isEmpty()) {
            return new AbstractMap.SimpleEntry<Boolean, List<Node>>(false, topoResultList);
        }
        while (!zeroIndegreeNodeQueue.isEmpty()) {
            Object v = zeroIndegreeNodeQueue.poll();
            Set subsequentNodes = this.getSubsequentNodes(v);
            for (Object subsequentNode : subsequentNodes) {
                Integer degree = (Integer)notZeroIndegreeNodeMap.get(subsequentNode);
                if ((degree = Integer.valueOf(degree - 1)) == 0) {
                    topoResultList.add(subsequentNode);
                    zeroIndegreeNodeQueue.add(subsequentNode);
                    notZeroIndegreeNodeMap.remove(subsequentNode);
                    continue;
                }
                notZeroIndegreeNodeMap.put(subsequentNode, degree);
            }
        }
        return new AbstractMap.SimpleEntry<Boolean, List<Node>>(notZeroIndegreeNodeMap.size() == 0, topoResultList);
    }

    public Set<Node> getAllNodesList() {
        return this.nodesMap.keySet();
    }

    public String toString() {
        return "DAG{nodesMap=" + this.nodesMap + ", edgesMap=" + this.edgesMap + ", reverseEdgesMap=" + this.reverseEdgesMap + '}';
    }
}

