/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.suggester;

import com.github.rvesse.airline.Channels;
import com.github.rvesse.airline.Context;
import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.help.suggester.CommandSuggester;
import com.github.rvesse.airline.help.suggester.GlobalSuggester;
import com.github.rvesse.airline.help.suggester.GroupSuggester;
import com.github.rvesse.airline.help.suggester.Suggester;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.MetadataLoader;
import com.github.rvesse.airline.model.SuggesterMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.ParserUtil;
import com.github.rvesse.airline.parser.suggester.SuggestionParser;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

@Command(name="suggest")
public class SuggestCommand<T>
implements Runnable,
Callable<Void> {
    private static final Map<Context, Class<? extends Suggester>> BUILTIN_SUGGESTERS = new HashMap<Context, Class<? extends Suggester>>();
    @Inject
    public GlobalMetadata<T> metadata;
    @Arguments
    public List<String> arguments = new ArrayList<String>();

    public Iterable<String> generateSuggestions() {
        SuggesterMetadata suggesterMetadata;
        SuggestionParser<T> parser = new SuggestionParser<T>();
        ParseState state = parser.parse(this.metadata, this.arguments);
        Class<? extends Suggester> suggesterClass = BUILTIN_SUGGESTERS.get((Object)state.getLocation());
        if (suggesterClass != null && (suggesterMetadata = MetadataLoader.loadSuggester(suggesterClass)) != null) {
            HashMap<Class<CommandMetadata>, Object> bindings = new HashMap<Class<CommandMetadata>, Object>();
            bindings.put(GlobalMetadata.class, this.metadata);
            if (state.getGroup() != null) {
                bindings.put(CommandGroupMetadata.class, state.getGroup());
            }
            if (state.getCommand() != null) {
                bindings.put(CommandMetadata.class, state.getCommand());
            }
            Suggester suggester = (Suggester)ParserUtil.createInstance(suggesterMetadata.getSuggesterClass(), Collections.emptyList(), null, null, null, suggesterMetadata.getMetadataInjections(), AirlineUtils.unmodifiableMapCopy(bindings));
            return suggester.suggest();
        }
        return Collections.emptyList();
    }

    @Override
    public void run() {
        Channels.output().println(StringUtils.join(this.generateSuggestions(), (char)'\n'));
    }

    @Override
    public Void call() {
        this.run();
        return null;
    }

    static {
        BUILTIN_SUGGESTERS.put(Context.GLOBAL, GlobalSuggester.class);
        BUILTIN_SUGGESTERS.put(Context.GROUP, GroupSuggester.class);
        BUILTIN_SUGGESTERS.put(Context.COMMAND, CommandSuggester.class);
    }
}

