/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;

public class LockResult {
    @Nullable
    private final TaskLock taskLock;
    private final boolean revoked;
    @Nullable
    private final SegmentIdWithShardSpec newSegmentId;

    public static LockResult ok(TaskLock taskLock, SegmentIdWithShardSpec newSegmentId) {
        return new LockResult(taskLock, newSegmentId, false);
    }

    public static LockResult fail() {
        return new LockResult(null, null, false);
    }

    public static LockResult revoked(TaskLock taskLock) {
        return new LockResult(taskLock, null, true);
    }

    @JsonCreator
    public LockResult(@JsonProperty(value="taskLock") @Nullable TaskLock taskLock, @JsonProperty(value="newSegmentId") @Nullable SegmentIdWithShardSpec newSegmentId, @JsonProperty(value="revoked") boolean revoked) {
        this.taskLock = taskLock;
        this.newSegmentId = newSegmentId;
        this.revoked = revoked;
    }

    @JsonProperty(value="taskLock")
    @Nullable
    public TaskLock getTaskLock() {
        return this.taskLock;
    }

    @JsonProperty(value="newSegmentId")
    @Nullable
    public SegmentIdWithShardSpec getNewSegmentId() {
        return this.newSegmentId;
    }

    @JsonProperty(value="revoked")
    public boolean isRevoked() {
        return this.revoked;
    }

    public boolean isOk() {
        return this.taskLock != null && !this.revoked;
    }
}

