/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import javax.annotation.Nullable;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.PostAggregatorVisitor;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class DirectOperatorConversion
implements SqlOperatorConversion {
    private final SqlOperator operator;
    private final String druidFunctionName;

    public DirectOperatorConversion(SqlOperator operator, String druidFunctionName) {
        this.operator = operator;
        this.druidFunctionName = druidFunctionName;
    }

    @Override
    public final SqlOperator calciteOperator() {
        return this.operator;
    }

    public final String getDruidFunctionName() {
        return this.druidFunctionName;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertDirectCall(plannerContext, rowSignature, rexNode, this.druidFunctionName);
    }

    @Override
    @Nullable
    public DruidExpression toDruidExpressionWithPostAggOperands(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, PostAggregatorVisitor postAggregatorVisitor) {
        return OperatorConversions.convertCallWithPostAggOperands(plannerContext, rowSignature, rexNode, operands -> DruidExpression.ofFunctionCall(Calcites.getColumnTypeForRelDataType(rexNode.getType()), this.druidFunctionName, operands), postAggregatorVisitor);
    }
}

