/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.ArrayContainsElementFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.builtin.BaseExpressionDimFilterOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class ArrayContainsOperatorConversion
extends BaseExpressionDimFilterOperatorConversion {
    private static final String EXPR_FUNCTION = "array_contains";
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("ARRAY_CONTAINS").operandTypeChecker(OperandTypes.sequence((String)"'ARRAY_CONTAINS(array, array)'", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}), OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC})})})).returnTypeInference(ReturnTypes.BOOLEAN_NULLABLE).build();

    public ArrayContainsOperatorConversion() {
        this((SqlOperator)SQL_FUNCTION, EXPR_FUNCTION);
    }

    protected ArrayContainsOperatorConversion(SqlOperator operator, String druidFunctionName) {
        super(operator, druidFunctionName);
    }

    @Override
    @Nullable
    public DimFilter toDruidFilter(PlannerContext plannerContext, RowSignature rowSignature, @Nullable VirtualColumnRegistry virtualColumnRegistry, RexNode rexNode) {
        Expr expr;
        Expr expr2;
        List operands = ((RexCall)rexNode).getOperands();
        List<DruidExpression> druidExpressions = Expressions.toDruidExpressions(plannerContext, rowSignature, operands);
        if (druidExpressions == null) {
            return null;
        }
        DruidExpression leftExpr = druidExpressions.get(0);
        DruidExpression rightExpr = druidExpressions.get(1);
        if (leftExpr.isSimpleExtraction() && !leftExpr.isArray() && (expr2 = plannerContext.parseExpression(rightExpr.getExpression())).isLiteral()) {
            ExprEval exprEval = expr2.eval(InputBindings.nilBindings());
            Object[] arrayElements = exprEval.asArray();
            if (arrayElements == null || arrayElements.length == 0) {
                return null;
            }
            ArrayList<Object> filters = new ArrayList<Object>(arrayElements.length);
            for (Object val : arrayElements) {
                String column;
                if (plannerContext.isUseBoundsAndSelectors()) {
                    filters.add(ArrayContainsOperatorConversion.newSelectorDimFilter(leftExpr.getSimpleExtraction(), Evals.asString((Object)val)));
                    continue;
                }
                String string = column = leftExpr.isDirectColumnAccess() ? leftExpr.getSimpleExtraction().getColumn() : virtualColumnRegistry.getOrCreateVirtualColumnForExpression(leftExpr, leftExpr.getDruidType());
                if (val == null) {
                    filters.add(NullFilter.forColumn((String)column));
                    continue;
                }
                filters.add(new EqualityFilter(column, ExpressionType.toColumnType((ExpressionType)ExpressionType.elementType((ExpressionType)exprEval.type())), val, null));
            }
            return filters.size() == 1 ? (DimFilter)filters.get(0) : new AndDimFilter(filters);
        }
        boolean isArrayContains = SQL_FUNCTION.equals((Object)this.calciteOperator());
        if (isArrayContains && leftExpr.isDirectColumnAccess() && leftExpr.isArray() && (expr = plannerContext.parseExpression(rightExpr.getExpression())).isLiteral()) {
            ExprEval exprEval = expr.eval(InputBindings.nilBindings());
            if (exprEval.isArray()) {
                Object[] arrayElements = exprEval.asArray();
                if (arrayElements.length == 0) {
                    return null;
                }
                ArrayList<ArrayContainsElementFilter> filters = new ArrayList<ArrayContainsElementFilter>(arrayElements.length);
                ColumnType elementType = ExpressionType.toColumnType((ExpressionType)ExpressionType.elementType((ExpressionType)exprEval.type()));
                for (Object val : arrayElements) {
                    filters.add(new ArrayContainsElementFilter(leftExpr.getSimpleExtraction().getColumn(), elementType, val, null));
                }
                return filters.size() == 1 ? (DimFilter)filters.get(0) : new AndDimFilter(filters);
            }
            return new ArrayContainsElementFilter(leftExpr.getSimpleExtraction().getColumn(), ExpressionType.toColumnType((ExpressionType)exprEval.type()), exprEval.value(), null);
        }
        return this.toExpressionFilter(plannerContext, druidExpressions);
    }
}

