/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.ExpressionParser;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class VirtualColumnRegistry {
    private final ExpressionParser expressionParser;
    private final RowSignature baseRowSignature;
    private final Map<ExpressionAndTypeHint, String> virtualColumnsByExpression;
    private final Map<String, ExpressionAndTypeHint> virtualColumnsByName;
    private final String virtualColumnPrefix;
    private int virtualColumnCounter;
    private boolean forceExpressionVirtualColumns;

    private VirtualColumnRegistry(RowSignature baseRowSignature, ExpressionParser expressionParser, String virtualColumnPrefix, boolean forceExpressionVirtualColumns, Map<ExpressionAndTypeHint, String> virtualColumnsByExpression, Map<String, ExpressionAndTypeHint> virtualColumnsByName) {
        this.expressionParser = expressionParser;
        this.baseRowSignature = baseRowSignature;
        this.virtualColumnPrefix = virtualColumnPrefix;
        this.virtualColumnsByExpression = virtualColumnsByExpression;
        this.virtualColumnsByName = virtualColumnsByName;
        this.forceExpressionVirtualColumns = forceExpressionVirtualColumns;
    }

    public static VirtualColumnRegistry create(RowSignature rowSignature, ExpressionParser expressionParser, boolean forceExpressionVirtualColumns) {
        return new VirtualColumnRegistry(rowSignature, expressionParser, Calcites.findUnusedPrefixForDigits("v", rowSignature.getColumnNames()), forceExpressionVirtualColumns, new HashMap<ExpressionAndTypeHint, String>(), new HashMap<String, ExpressionAndTypeHint>());
    }

    public boolean isEmpty() {
        return this.virtualColumnsByExpression.isEmpty();
    }

    public boolean isVirtualColumnDefined(String virtualColumnName) {
        return this.virtualColumnsByName.containsKey(virtualColumnName);
    }

    public String getOrCreateVirtualColumnForExpression(DruidExpression expression, ColumnType typeHint) {
        ExpressionAndTypeHint candidate = VirtualColumnRegistry.wrap(expression, typeHint);
        if (!this.virtualColumnsByExpression.containsKey(candidate)) {
            String virtualColumnName = this.virtualColumnPrefix + this.virtualColumnCounter++;
            this.virtualColumnsByExpression.put(candidate, virtualColumnName);
            this.virtualColumnsByName.put(virtualColumnName, candidate);
        }
        return this.virtualColumnsByExpression.get(candidate);
    }

    public String getOrCreateVirtualColumnForExpression(DruidExpression expression, RelDataType typeHint) {
        if (typeHint.getSqlTypeName() == SqlTypeName.OTHER && expression.getDruidType() != null) {
            return this.getOrCreateVirtualColumnForExpression(expression, expression.getDruidType());
        }
        return this.getOrCreateVirtualColumnForExpression(expression, Calcites.getColumnTypeForRelDataType(typeHint));
    }

    @Nullable
    public VirtualColumn getVirtualColumn(String virtualColumnName) {
        ExpressionAndTypeHint registeredColumn = this.virtualColumnsByName.get(virtualColumnName);
        if (registeredColumn == null) {
            return null;
        }
        DruidExpression expression = registeredColumn.getExpression();
        ColumnType columnType = registeredColumn.getTypeHint();
        return this.forceExpressionVirtualColumns ? expression.toExpressionVirtualColumn(virtualColumnName, columnType, this.expressionParser) : expression.toVirtualColumn(virtualColumnName, columnType, this.expressionParser);
    }

    public RowSignature getFullRowSignature() {
        RowSignature.Builder builder = RowSignature.builder().addAll(this.baseRowSignature);
        RowSignature baseSignature = builder.build();
        for (Map.Entry<String, ExpressionAndTypeHint> virtualColumn : this.virtualColumnsByName.entrySet()) {
            String columnName = virtualColumn.getKey();
            ColumnType typeHint = virtualColumn.getValue().getTypeHint();
            ColumnCapabilities virtualCapabilities = virtualColumn.getValue().getExpression().toVirtualColumn(columnName, typeHint, this.expressionParser).capabilities((ColumnInspector)baseSignature, columnName);
            builder.add(columnName, virtualCapabilities != null ? virtualCapabilities.toColumnType() : typeHint);
        }
        return builder.build();
    }

    public List<DruidExpression> findVirtualColumnExpressions(List<String> allColumns) {
        return allColumns.stream().filter(this::isVirtualColumnDefined).map(name -> this.virtualColumnsByName.get(name).getExpression()).collect(Collectors.toList());
    }

    public void visitAllSubExpressions(DruidExpression.DruidExpressionShuttle shuttle) {
        ArrayDeque<Map.Entry<String, ExpressionAndTypeHint>> toVisit = new ArrayDeque<Map.Entry<String, ExpressionAndTypeHint>>(this.virtualColumnsByName.entrySet());
        while (!toVisit.isEmpty()) {
            Map.Entry entry = (Map.Entry)toVisit.poll();
            String key = (String)entry.getKey();
            ExpressionAndTypeHint wrapped = (ExpressionAndTypeHint)entry.getValue();
            List<DruidExpression> newArgs = shuttle.visitAll(wrapped.getExpression().getArguments());
            ExpressionAndTypeHint newWrapped = VirtualColumnRegistry.wrap(wrapped.getExpression().withArguments(newArgs), wrapped.getTypeHint());
            this.virtualColumnsByName.put(key, newWrapped);
            this.virtualColumnsByExpression.remove(wrapped);
            this.virtualColumnsByExpression.put(newWrapped, key);
        }
    }

    public Collection<? extends VirtualColumn> getAllVirtualColumns(List<String> requiredColumns) {
        return requiredColumns.stream().filter(this::isVirtualColumnDefined).map(this::getVirtualColumn).collect(Collectors.toList());
    }

    @Deprecated
    public VirtualColumn getOrCreateVirtualColumnForExpression(PlannerContext plannerContext, DruidExpression expression, ColumnType valueType) {
        String name = this.getOrCreateVirtualColumnForExpression(expression, valueType);
        return this.getVirtualColumn(name);
    }

    private static ExpressionAndTypeHint wrap(DruidExpression expression, ColumnType typeHint) {
        return new ExpressionAndTypeHint(expression, typeHint);
    }

    public VirtualColumns build(Set<String> exclude) {
        ArrayList<VirtualColumn> columns = new ArrayList<VirtualColumn>();
        if (this.virtualColumnsByName == null) {
            return VirtualColumns.EMPTY;
        }
        for (Map.Entry<String, ExpressionAndTypeHint> entry : this.virtualColumnsByName.entrySet()) {
            if (exclude.contains(entry.getKey())) continue;
            columns.add(this.getVirtualColumn(entry.getKey()));
        }
        columns.sort(Comparator.comparing(VirtualColumn::getOutputName));
        return VirtualColumns.create(columns);
    }

    private static class ExpressionAndTypeHint {
        private final DruidExpression expression;
        private final ColumnType typeHint;

        public ExpressionAndTypeHint(DruidExpression expression, ColumnType valueType) {
            this.expression = expression;
            this.typeHint = valueType;
        }

        public DruidExpression getExpression() {
            return this.expression;
        }

        public ColumnType getTypeHint() {
            return this.typeHint;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExpressionAndTypeHint expressionAndTypeHint = (ExpressionAndTypeHint)o;
            return Objects.equals(this.typeHint, expressionAndTypeHint.typeHint) && Objects.equals(this.expression, expressionAndTypeHint.expression);
        }

        public int hashCode() {
            return Objects.hash(this.expression, this.typeHint);
        }
    }
}

