/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.TableId;
import org.apache.druid.catalog.model.TableSpec;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;

public class TableMetadata {
    private final TableId id;
    private final long creationTime;
    private final long updateTime;
    private final TableState state;
    private final TableSpec spec;

    public TableMetadata(@JsonProperty(value="id") TableId tableId, @JsonProperty(value="creationTime") long creationTime, @JsonProperty(value="updateTime") long updateTime, @JsonProperty(value="state") TableState state, @JsonProperty(value="spec") TableSpec spec) {
        this.id = tableId;
        this.creationTime = creationTime;
        this.updateTime = updateTime;
        this.state = state;
        this.spec = spec;
    }

    public static TableMetadata newTable(TableId id, TableSpec spec) {
        return new TableMetadata(id, 0L, 0L, TableState.ACTIVE, spec);
    }

    public static TableMetadata of(TableId id, TableSpec spec) {
        return new TableMetadata(id, 0L, 0L, TableState.ACTIVE, spec);
    }

    public static TableMetadata forUpdate(TableId id, long updateTime, TableSpec spec) {
        return new TableMetadata(id, 0L, updateTime, TableState.ACTIVE, spec);
    }

    public static TableMetadata empty(TableId id) {
        return new TableMetadata(id, 0L, 0L, null, null);
    }

    public TableMetadata fromInsert(long updateTime) {
        return new TableMetadata(this.id, updateTime, updateTime, this.state, this.spec);
    }

    public TableMetadata asUpdate(long updateTime) {
        return new TableMetadata(this.id, this.creationTime, updateTime, this.state, this.spec);
    }

    public TableMetadata withSpec(TableSpec spec) {
        return new TableMetadata(this.id, this.creationTime, this.updateTime, this.state, spec);
    }

    public TableMetadata withColumns(TableMetadata update) {
        return new TableMetadata(this.id, this.creationTime, update.updateTime(), this.state, this.spec.withColumns(update.spec().columns()));
    }

    public TableMetadata withProperties(TableMetadata update) {
        return new TableMetadata(this.id, this.creationTime, update.updateTime(), this.state, this.spec.withProperties(update.spec().properties()));
    }

    public TableMetadata withProperties(Map<String, Object> props) {
        return new TableMetadata(this.id, this.creationTime, this.updateTime, this.state, this.spec.withProperties(props));
    }

    @JsonProperty(value="id")
    public TableId id() {
        return this.id;
    }

    public String sqlName() {
        return this.id.sqlName();
    }

    @JsonProperty(value="state")
    public TableState state() {
        return this.state;
    }

    @JsonProperty(value="creationTime")
    public long creationTime() {
        return this.creationTime;
    }

    @JsonProperty(value="updateTime")
    public long updateTime() {
        return this.updateTime;
    }

    @JsonProperty(value="spec")
    public TableSpec spec() {
        return this.spec;
    }

    public void validate() {
        if (Strings.isNullOrEmpty((String)this.id.schema())) {
            throw new IAE("Database schema is required", new Object[0]);
        }
        if (Strings.isNullOrEmpty((String)this.id.name())) {
            throw new IAE("Table name is required", new Object[0]);
        }
        if (this.spec == null) {
            throw new IAE("A table definition must include a table spec.", new Object[0]);
        }
    }

    public String toString() {
        return CatalogUtils.toString(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        TableMetadata other = (TableMetadata)o;
        return Objects.equals(this.id, other.id) && this.creationTime == other.creationTime && this.updateTime == other.updateTime && this.state == other.state && Objects.equals(this.spec, other.spec);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.creationTime, this.updateTime, this.state, this.spec});
    }

    public static enum TableState {
        ACTIVE("A"),
        DELETING("D");

        private final String code;

        private TableState(String code) {
            this.code = code;
        }

        public String code() {
            return this.code;
        }

        public static TableState fromCode(String code) {
            for (TableState state : TableState.values()) {
                if (!state.code.equals(code)) continue;
                return state;
            }
            throw new ISE("Unknown TableState code: " + code, new Object[0]);
        }
    }
}

