/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ResourceClaimParametersReference contains enough information to let you locate the parameters for a ResourceClaim. The object must be in the same namespace as the ResourceClaim.")
public class V1alpha2ResourceClaimParametersReference {
    public static final String SERIALIZED_NAME_API_GROUP = "apiGroup";
    @SerializedName(value="apiGroup")
    private String apiGroup;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;

    public V1alpha2ResourceClaimParametersReference apiGroup(String apiGroup) {
        this.apiGroup = apiGroup;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.")
    public String getApiGroup() {
        return this.apiGroup;
    }

    public void setApiGroup(String apiGroup) {
        this.apiGroup = apiGroup;
    }

    public V1alpha2ResourceClaimParametersReference kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(required=true, value="Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata, for example \"ConfigMap\".")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1alpha2ResourceClaimParametersReference name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name is the name of resource being referenced.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2ResourceClaimParametersReference v1alpha2ResourceClaimParametersReference = (V1alpha2ResourceClaimParametersReference)o;
        return Objects.equals(this.apiGroup, v1alpha2ResourceClaimParametersReference.apiGroup) && Objects.equals(this.kind, v1alpha2ResourceClaimParametersReference.kind) && Objects.equals(this.name, v1alpha2ResourceClaimParametersReference.name);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroup, this.kind, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2ResourceClaimParametersReference {\n");
        sb.append("    apiGroup: ").append(this.toIndentedString(this.apiGroup)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

