/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.stage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.ints.Int2IntAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntSortedMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.druid.msq.input.SlicerUtils;
import org.apache.druid.msq.input.stage.ReadablePartition;
import org.apache.druid.msq.input.stage.ReadablePartitions;

public class CollectedReadablePartitions
implements ReadablePartitions {
    private final int stageNumber;
    private final Int2IntSortedMap partitionToWorkerMap;

    CollectedReadablePartitions(int stageNumber, Int2IntSortedMap partitionToWorkerMap) {
        this.stageNumber = stageNumber;
        this.partitionToWorkerMap = partitionToWorkerMap;
    }

    @JsonCreator
    private CollectedReadablePartitions(@JsonProperty(value="stageNumber") int stageNumber, @JsonProperty(value="partitionToWorkerMap") Map<Integer, Integer> partitionToWorkerMap) {
        this(stageNumber, (Int2IntSortedMap)new Int2IntAVLTreeMap(partitionToWorkerMap));
    }

    @Override
    public Iterator<ReadablePartition> iterator() {
        return Iterators.transform((Iterator)this.partitionToWorkerMap.int2IntEntrySet().iterator(), entry -> ReadablePartition.collected(this.stageNumber, entry.getIntValue(), entry.getIntKey()));
    }

    @Override
    public List<ReadablePartitions> split(int maxNumSplits) {
        return SlicerUtils.makeSlicesStatic(this.partitionToWorkerMap.int2IntEntrySet().iterator(), maxNumSplits).stream().map(entries -> {
            Int2IntAVLTreeMap map = new Int2IntAVLTreeMap();
            for (Int2IntMap.Entry entry : entries) {
                map.put(entry.getIntKey(), entry.getIntValue());
            }
            return new CollectedReadablePartitions(this.stageNumber, (Int2IntSortedMap)map);
        }).collect(Collectors.toList());
    }

    @JsonProperty
    int getStageNumber() {
        return this.stageNumber;
    }

    @JsonProperty
    Int2IntSortedMap getPartitionToWorkerMap() {
        return this.partitionToWorkerMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectedReadablePartitions that = (CollectedReadablePartitions)o;
        return this.stageNumber == that.stageNumber && Objects.equals(this.partitionToWorkerMap, that.partitionToWorkerMap);
    }

    public int hashCode() {
        return Objects.hash(this.stageNumber, this.partitionToWorkerMap);
    }

    public String toString() {
        return "CollectedReadablePartitions{stageNumber=" + this.stageNumber + ", partitionToWorkerMap=" + String.valueOf(this.partitionToWorkerMap) + "}";
    }
}

