/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.netty.implementation.NettyToAzureCoreHttpHeadersWrapper;
import com.azure.core.implementation.util.HttpHeadersAccessHelper;
import io.netty.util.AsciiString;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import reactor.netty.http.client.HttpClientResponse;

public abstract class NettyAsyncHttpResponseBase
extends HttpResponse {
    private final HttpClientResponse reactorNettyResponse;
    private final HttpHeaders headers;

    NettyAsyncHttpResponseBase(HttpClientResponse reactorNettyResponse, HttpRequest httpRequest, boolean headersEagerlyConverted) {
        super(httpRequest);
        this.reactorNettyResponse = reactorNettyResponse;
        io.netty.handler.codec.http.HttpHeaders nettyHeaders = reactorNettyResponse.responseHeaders();
        if (headersEagerlyConverted) {
            this.headers = new HttpHeaders((int)((float)nettyHeaders.size() / 0.75f));
            Iterator nettyHeadersIterator = nettyHeaders.iteratorCharSequence();
            while (nettyHeadersIterator.hasNext()) {
                Map.Entry next = (Map.Entry)nettyHeadersIterator.next();
                String value = Objects.toString(next.getValue(), null);
                CharSequence key = (CharSequence)next.getKey();
                if (key instanceof AsciiString) {
                    AsciiString asciiString = (AsciiString)key;
                    HttpHeadersAccessHelper.addInternal((HttpHeaders)this.headers, (String)asciiString.toLowerCase().toString(), (String)asciiString.toString(), (String)value);
                    continue;
                }
                this.headers.add(key.toString(), value);
            }
        } else {
            this.headers = new NettyToAzureCoreHttpHeadersWrapper(nettyHeaders);
        }
    }

    public final int getStatusCode() {
        return this.reactorNettyResponse.status().code();
    }

    @Deprecated
    public final String getHeaderValue(String name) {
        return this.headers.getValue(name);
    }

    public final String getHeaderValue(HttpHeaderName headerName) {
        return this.headers.getValue(headerName);
    }

    public final HttpHeaders getHeaders() {
        return this.headers;
    }
}

