/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo;

import java.util.ArrayList;
import javax.inject.Inject;
import org.schemarepo.DelegatingRepository;
import org.schemarepo.Repository;
import org.schemarepo.Subject;
import org.schemarepo.SubjectConfig;

public class ReadOnlyRepository
extends DelegatingRepository {
    @Inject
    public ReadOnlyRepository(Repository repo) {
        super(repo);
    }

    @Override
    public Subject register(String subjectName, SubjectConfig config) {
        throw new IllegalStateException("Cannot register a Subject in a ReadOnlyRepository");
    }

    @Override
    public Subject lookup(String subjectName) {
        return Subject.readOnly(this.repo.lookup(subjectName));
    }

    @Override
    public Iterable<Subject> subjects() {
        ArrayList<Subject> subjects = new ArrayList<Subject>();
        for (Subject sub : this.repo.subjects()) {
            subjects.add(Subject.readOnly(sub));
        }
        return subjects;
    }
}

