/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.schemarepo.RepositoryUtil;

public class SubjectConfig {
    private static final SubjectConfig EMPTY = new Builder().build();
    private static final String RESERVED_PREFIX = "repo.";
    public static final String VALIDATORS_KEY = "repo.validators";
    private final Map<String, String> conf;
    private final Set<String> validators;

    private SubjectConfig(Map<String, String> conf, Set<String> validators) {
        this.conf = conf;
        this.validators = validators;
    }

    public String get(String key) {
        return this.conf.get(key);
    }

    public Set<String> getValidators() {
        return this.validators;
    }

    public Map<String, String> asMap() {
        return this.conf;
    }

    public static SubjectConfig emptyConfig() {
        return EMPTY;
    }

    public int hashCode() {
        return ((Object)this.conf).hashCode() * 31 + ((Object)this.validators).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubjectConfig other = (SubjectConfig)obj;
        if (!((Object)this.validators).equals(other.validators)) {
            return false;
        }
        return ((Object)this.conf).equals(other.conf);
    }

    public static class Builder {
        private final HashMap<String, String> conf = new HashMap();
        private final HashSet<String> validators = new HashSet();

        public Builder set(Map<String, String> config) {
            for (Map.Entry<String, String> entry : config.entrySet()) {
                this.set(entry.getKey(), entry.getValue());
            }
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Builder set(String key, String value) {
            if (key.startsWith(SubjectConfig.RESERVED_PREFIX)) {
                if (!SubjectConfig.VALIDATORS_KEY.equals(key)) throw new RuntimeException("SubjectConfig keys starting with 'repo.' are reserved, failed to set: " + key + " to value: " + value);
                this.setValidators(RepositoryUtil.commaSplit(value));
                return this;
            } else {
                this.conf.put(key, value);
            }
            return this;
        }

        public Builder setValidators(Collection<String> validatorNames) {
            this.validators.clear();
            this.conf.remove(SubjectConfig.VALIDATORS_KEY);
            if (!validatorNames.isEmpty()) {
                this.validators.addAll(validatorNames);
            }
            this.conf.put(SubjectConfig.VALIDATORS_KEY, RepositoryUtil.commaJoin(this.validators));
            return this;
        }

        public Builder addValidator(String validatorName) {
            this.validators.add(validatorName);
            this.conf.put(SubjectConfig.VALIDATORS_KEY, RepositoryUtil.commaJoin(this.validators));
            return this;
        }

        public SubjectConfig build() {
            return new SubjectConfig(Collections.unmodifiableMap(new HashMap<String, String>(this.conf)), Collections.unmodifiableSet(new HashSet<String>(this.validators)));
        }
    }
}

