/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.policy;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.policy.NoopPolicyEnforcer;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.policy.RestrictAllTablesPolicyEnforcer;
import org.apache.druid.segment.Segment;
import org.apache.druid.timeline.SegmentId;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=NoopPolicyEnforcer.class, name="none"), @JsonSubTypes.Type(value=RestrictAllTablesPolicyEnforcer.class, name="restrictAllTables")})
public interface PolicyEnforcer {
    default public void validateOrElseThrow(TableDataSource ds, Policy policy) throws DruidException {
        if (this.validate(policy)) {
            return;
        }
        throw DruidException.forPersona(DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.FORBIDDEN).build("Failed security validation with dataSource [%s]", ds);
    }

    default public void validateOrElseThrow(Segment segment, Policy policy) throws DruidException {
        SegmentId segmentId = segment.getId();
        if (segmentId == null) {
            return;
        }
        if (this.validate(policy)) {
            return;
        }
        throw DruidException.forPersona(DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.FORBIDDEN).build("Failed security validation with segment [%s]", segmentId);
    }

    public boolean validate(Policy var1);
}

