/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.column;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.operator.window.value.ShiftedColumnAccessorBase;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;

public class LimitedColumn
implements Column {
    private final Column column;
    private final int start;
    private final int end;

    public LimitedColumn(Column column, int start, int end) {
        this.column = column;
        this.start = start;
        this.end = end;
    }

    @Override
    @Nonnull
    public ColumnAccessor toAccessor() {
        ColumnAccessor columnAccessor = this.column.toAccessor();
        return new ShiftedColumnAccessorBase(columnAccessor){

            @Override
            public int numRows() {
                return LimitedColumn.this.end - LimitedColumn.this.start;
            }

            @Override
            protected int getActualValue(int rowNum) {
                int retVal = LimitedColumn.this.start + rowNum;
                if (retVal >= LimitedColumn.this.end) {
                    throw new ISE("Index out of bounds[%d] >= [%d], start[%s]", retVal, LimitedColumn.this.end, LimitedColumn.this.start);
                }
                return retVal;
            }

            @Override
            protected boolean outsideBounds(int rowNum) {
                return false;
            }
        };
    }

    @Override
    @Nullable
    public <T> T as(Class<? extends T> clazz) {
        return null;
    }
}

