/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.segment.Segment;

public class SegmentReference
implements Closeable {
    private final SegmentDescriptor segmentDescriptor;
    private final Optional<Segment> segmentReference;
    private final Closer closer = Closer.create();

    public static SegmentReference missing(SegmentDescriptor segmentDescriptor) {
        return new SegmentReference(segmentDescriptor, Optional.empty(), null);
    }

    public SegmentReference(SegmentDescriptor segmentDescriptor, Optional<Segment> segmentReference, @Nullable Closeable cleanupHold) {
        this.segmentDescriptor = segmentDescriptor;
        this.closer.register(cleanupHold);
        this.segmentReference = segmentReference.map(this.closer::register);
    }

    public SegmentDescriptor getSegmentDescriptor() {
        return this.segmentDescriptor;
    }

    public Optional<Segment> getSegmentReference() {
        return this.segmentReference;
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }
}

