/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class ExpressionVectorMultiValueStringObjectSelector
implements VectorObjectSelector {
    private final Expr.VectorInputBinding bindings;
    private final ExprVectorProcessor<?> processor;
    private @MonotonicNonNull Object[] cached;
    private int currentId = -1;

    public ExpressionVectorMultiValueStringObjectSelector(ExprVectorProcessor<?> processor, Expr.VectorInputBinding bindings) {
        this.processor = (ExprVectorProcessor)Preconditions.checkNotNull(processor, (Object)"processor");
        this.bindings = (Expr.VectorInputBinding)Preconditions.checkNotNull((Object)bindings, (Object)"bindings");
        this.cached = new Object[bindings.getMaxVectorSize()];
    }

    @Override
    public Object[] getObjectVector() {
        if (this.bindings.getCurrentVectorId() != this.currentId) {
            this.currentId = this.bindings.getCurrentVectorId();
            Object[] tmp = this.processor.evalVector(this.bindings).getObjectVector();
            for (int i = 0; i < this.bindings.getCurrentVectorSize(); ++i) {
                Object[] tmpi = (Object[])tmp[i];
                this.cached[i] = tmpi == null ? null : (tmpi.length == 1 ? tmpi[0] : Arrays.asList(tmpi));
            }
        }
        return this.cached;
    }

    @Override
    public int getMaxVectorSize() {
        return this.bindings.getMaxVectorSize();
    }

    @Override
    public int getCurrentVectorSize() {
        return this.bindings.getCurrentVectorSize();
    }
}

