/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apiguardian.api.API;

public class NonNullableAccessors {
    private NonNullableAccessors() {
    }

    @API(since="1.27", status=API.Status.EXPERIMENTAL)
    public static Charset getCharset(RelDataType type) {
        return Objects.requireNonNull(type.getCharset(), () -> "charset is null for " + type);
    }

    @API(since="1.27", status=API.Status.EXPERIMENTAL)
    public static SqlCollation getCollation(RelDataType type) {
        return Objects.requireNonNull(type.getCollation(), () -> !SqlTypeUtil.inCharFamily(type) ? "collation is null for " + type : "RelDataType object should have been assigned a (default) collation when calling deriveType, type=" + type);
    }

    @API(since="1.27", status=API.Status.EXPERIMENTAL)
    public static RelDataType getComponentTypeOrThrow(RelDataType type) {
        return Objects.requireNonNull(type.getComponentType(), () -> "componentType is null for " + type);
    }

    @API(since="1.37", status=API.Status.EXPERIMENTAL)
    public static RelDataType getKeyTypeOrThrow(RelDataType type) {
        return Objects.requireNonNull(type.getKeyType(), () -> "keyType is null for " + type);
    }
}

