/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Arrays;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.quantiles.ClassicUtil;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.datasketches.quantiles.ItemsUpdateImpl;

final class ItemsUtil {
    static final int ITEMS_SER_VER = 3;
    static final int PRIOR_ITEMS_SER_VER = 2;

    private ItemsUtil() {
    }

    static void checkItemsSerVer(int serVer) {
        if (serVer == 3 || serVer == 2) {
            return;
        }
        throw new SketchesArgumentException("Possible corruption: Invalid Serialization Version: " + serVer);
    }

    static <T> void processFullBaseBuffer(ItemsSketch<T> sketch) {
        int bbCount = sketch.getBaseBufferCount();
        long n = sketch.getN();
        assert (bbCount == 2 * sketch.getK());
        ItemsUpdateImpl.maybeGrowLevels(sketch, n);
        Object[] baseBuffer = sketch.getCombinedBuffer();
        Arrays.sort(baseBuffer, 0, bbCount, sketch.getComparator());
        ItemsUpdateImpl.inPlacePropagateCarry(0, null, 0, baseBuffer, 0, true, sketch);
        sketch.baseBufferCount_ = 0;
        Arrays.fill(baseBuffer, 0, 2 * sketch.getK(), null);
        assert (n / (2L * (long)sketch.getK()) == sketch.getBitPattern());
    }

    static <T> String toString(boolean sketchSummary, boolean dataDetail, ItemsSketch<T> sketch) {
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = sketch.getClass().getSimpleName();
        int bbCount = sketch.getBaseBufferCount();
        int combAllocCount = sketch.getCombinedBufferAllocatedCount();
        int k = sketch.getK();
        long bitPattern = sketch.getBitPattern();
        if (dataDetail) {
            sb.append(ClassicUtil.LS).append("### ").append(thisSimpleName).append(" DATA DETAIL: ").append(ClassicUtil.LS);
            Object[] items = sketch.getCombinedBuffer();
            sb.append("   BaseBuffer   :");
            if (bbCount > 0) {
                for (int i = 0; i < bbCount; ++i) {
                    sb.append(' ').append(items[i]);
                }
            }
            sb.append(ClassicUtil.LS);
            int numItems = combAllocCount;
            if (numItems > 2 * k) {
                sb.append("   Valid | Level");
                for (int j = 2 * k; j < numItems; ++j) {
                    if (j % k == 0) {
                        int levelNum = j > 2 * k ? (j - 2 * k) / k : 0;
                        String validLvl = (1L << levelNum & bitPattern) > 0L ? "    T  " : "    F  ";
                        String lvl = String.format("%5d", levelNum);
                        sb.append(ClassicUtil.LS).append("   ").append(validLvl).append(" ").append(lvl).append(":");
                    }
                    sb.append(' ').append(items[j]);
                }
                sb.append(ClassicUtil.LS);
            }
            sb.append("### END DATA DETAIL").append(ClassicUtil.LS);
        }
        if (sketchSummary) {
            long n = sketch.getN();
            String nStr = String.format("%,d", n);
            int numLevels = ClassicUtil.computeNumLevelsNeeded(k, n);
            String bufCntStr = String.format("%,d", combAllocCount);
            int preBytes = sketch.isEmpty() ? 8 : 16;
            double epsPmf = ClassicUtil.getNormalizedRankError(k, true);
            String epsPmfPctStr = String.format("%.3f%%", epsPmf * 100.0);
            double eps = ClassicUtil.getNormalizedRankError(k, false);
            String epsPctStr = String.format("%.3f%%", eps * 100.0);
            int numSamples = sketch.getNumRetained();
            String numSampStr = String.format("%,d", numSamples);
            Object minItem = sketch.isEmpty() ? null : sketch.getMinItem();
            Object maxItem = sketch.isEmpty() ? null : sketch.getMaxItem();
            sb.append(ClassicUtil.LS).append("### ").append(thisSimpleName).append(" SUMMARY: ").append(ClassicUtil.LS);
            sb.append("   K                            : ").append(k).append(ClassicUtil.LS);
            sb.append("   N                            : ").append(nStr).append(ClassicUtil.LS);
            sb.append("   BaseBufferCount              : ").append(bbCount).append(ClassicUtil.LS);
            sb.append("   CombinedBufferAllocatedCount : ").append(bufCntStr).append(ClassicUtil.LS);
            sb.append("   Total Levels                 : ").append(numLevels).append(ClassicUtil.LS);
            sb.append("   Valid Levels                 : ").append(ClassicUtil.computeValidLevels(bitPattern)).append(ClassicUtil.LS);
            sb.append("   Level Bit Pattern            : ").append(Long.toBinaryString(bitPattern)).append(ClassicUtil.LS);
            sb.append("   Valid Samples                : ").append(numSampStr).append(ClassicUtil.LS);
            sb.append("   Preamble Bytes               : ").append(preBytes).append(ClassicUtil.LS);
            sb.append("   Normalized Rank Error        : ").append(epsPctStr).append(Util.LS);
            sb.append("   Normalized Rank Error (PMF)  : ").append(epsPmfPctStr).append(Util.LS);
            sb.append("   Min Quantile                 : ").append((Object)minItem).append(ClassicUtil.LS);
            sb.append("   Max Quantile                 : ").append((Object)maxItem).append(ClassicUtil.LS);
            sb.append("### END SKETCH SUMMARY").append(ClassicUtil.LS);
        }
        return sb.toString();
    }
}

