/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.s3;

import com.amazonaws.AmazonServiceException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.storage.s3.S3DataSegmentPusherConfig;
import org.apache.druid.storage.s3.S3Utils;
import org.apache.druid.storage.s3.ServerSideEncryptingAmazonS3;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.utils.CompressionUtils;

public class S3DataSegmentPusher
implements DataSegmentPusher {
    private static final EmittingLogger log = new EmittingLogger(S3DataSegmentPusher.class);
    private final ServerSideEncryptingAmazonS3 s3Client;
    private final S3DataSegmentPusherConfig config;

    @Inject
    public S3DataSegmentPusher(ServerSideEncryptingAmazonS3 s3Client, S3DataSegmentPusherConfig config) {
        this.s3Client = s3Client;
        this.config = config;
    }

    public String getPathForHadoop() {
        if (this.config.isUseS3aSchema()) {
            return StringUtils.format((String)"s3a://%s/%s", (Object[])new Object[]{this.config.getBucket(), this.config.getBaseKey()});
        }
        return StringUtils.format((String)"s3n://%s/%s", (Object[])new Object[]{this.config.getBucket(), this.config.getBaseKey()});
    }

    @Deprecated
    public String getPathForHadoop(String dataSource) {
        return this.getPathForHadoop();
    }

    public List<String> getAllowedPropertyPrefixesForHadoop() {
        return ImmutableList.of((Object)"druid.s3");
    }

    public DataSegment push(File indexFilesDir, DataSegment inSegment, boolean useUniquePath) throws IOException {
        return this.pushToPath(indexFilesDir, inSegment, this.getStorageDir(inSegment, useUniquePath));
    }

    public DataSegment pushToPath(File indexFilesDir, DataSegment inSegment, String storageDirSuffix) throws IOException {
        if (this.config.isZip()) {
            String s3Path = S3Utils.constructSegmentPath(this.config.getBaseKey(), storageDirSuffix);
            log.debug("Copying segment[%s] to S3 at location[%s]", new Object[]{inSegment.getId(), s3Path});
            return this.pushZip(indexFilesDir, inSegment, s3Path);
        }
        String s3Path = S3Utils.constructSegmentBasePath(this.config.getBaseKey(), storageDirSuffix);
        log.debug("Copying segment[%s] files to S3 at location[%s]", new Object[]{inSegment.getId(), s3Path});
        return this.pushNoZip(indexFilesDir, inSegment, s3Path);
    }

    private DataSegment pushZip(File indexFilesDir, DataSegment baseSegment, String s3Path) throws IOException {
        File zipOutFile = File.createTempFile("druid", "index.zip");
        long indexSize = CompressionUtils.zip((File)indexFilesDir, (File)zipOutFile);
        DataSegment outSegment = baseSegment.withSize(indexSize).withLoadSpec(this.makeLoadSpec(this.config.getBucket(), s3Path)).withBinaryVersion(SegmentUtils.getVersionFromDir((File)indexFilesDir));
        try {
            DataSegment dataSegment = (DataSegment)S3Utils.retryS3Operation(() -> {
                S3Utils.uploadFileIfPossible(this.s3Client, this.config.getDisableAcl(), this.config.getBucket(), s3Path, zipOutFile);
                return outSegment;
            });
            return dataSegment;
        }
        catch (AmazonServiceException e) {
            throw S3DataSegmentPusher.handlePushServiceException(e, indexSize);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            log.debug("Deleting temporary cached index.zip", new Object[0]);
            zipOutFile.delete();
        }
    }

    private DataSegment pushNoZip(File indexFilesDir, DataSegment baseSegment, String s3Path) throws IOException {
        File[] files = indexFilesDir.listFiles();
        if (files == null) {
            throw new IOE("Cannot list directory [%s]", new Object[]{indexFilesDir});
        }
        long size = 0L;
        for (File file : files) {
            if (file.isFile()) {
                size += file.length();
                try {
                    S3Utils.retryS3Operation(() -> {
                        S3Utils.uploadFileIfPossible(this.s3Client, this.config.getDisableAcl(), this.config.getBucket(), s3Path + file.getName(), file);
                        return null;
                    });
                    continue;
                }
                catch (AmazonServiceException e) {
                    throw S3DataSegmentPusher.handlePushServiceException(e, file.length());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            throw new IOE("Unexpected subdirectory [%s]", new Object[]{file.getName()});
        }
        return baseSegment.withSize(size).withLoadSpec(this.makeLoadSpec(this.config.getBucket(), s3Path)).withBinaryVersion(SegmentUtils.getVersionFromDir((File)indexFilesDir));
    }

    public Map<String, Object> makeLoadSpec(URI finalIndexZipFilePath) {
        return this.makeLoadSpec(finalIndexZipFilePath.getHost(), finalIndexZipFilePath.getPath().substring(1));
    }

    private Map<String, Object> makeLoadSpec(String bucket, String key) {
        return ImmutableMap.of((Object)"type", (Object)"s3_zip", (Object)"bucket", (Object)bucket, (Object)"key", (Object)key, (Object)"S3Schema", (Object)(this.config.isUseS3aSchema() ? "s3a" : "s3n"));
    }

    private static IOException handlePushServiceException(AmazonServiceException e, long indexSize) {
        if ("EntityTooLarge".equals(S3Utils.getS3ErrorCode(e))) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.RUNTIME_FAILURE).build((Throwable)e, "Got error[%s] from S3 when uploading segment of size[%,d] bytes. This typically happens when segment size is above 5GB. Try reducing your segment size by lowering the target number of rows per segment.", new Object[]{"EntityTooLarge", indexSize});
        }
        return new IOException(e);
    }
}

