/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.pager;

import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.function.Function;
import okhttp3.Call;

public class Pager<ApiType extends KubernetesObject, ApiListType extends KubernetesListObject>
implements Iterable<ApiType> {
    private final Integer limit;
    private final ApiClient client;
    private final Type listType;
    private final Function<PagerParams, Call> listFunc;

    public Pager(Function<PagerParams, Call> listFunc, ApiClient client, Integer limit, Type listType) {
        this.listFunc = listFunc;
        this.client = client;
        this.limit = limit;
        this.listType = listType;
    }

    @Override
    public Iterator<ApiType> iterator() {
        PagerIterator it = new PagerIterator();
        it.makeCall();
        return it;
    }

    private Call getNextCall(Integer nextLimit, String continueToken) {
        PagerParams params = new PagerParams(nextLimit != null ? nextLimit : this.limit, continueToken);
        return this.listFunc.apply(params);
    }

    private ApiListType executeRequest(Call call) throws IOException, ApiException {
        return (ApiListType)((KubernetesListObject)this.client.handleResponse(call.execute(), this.listType));
    }

    private class PagerIterator
    implements Iterator<ApiType> {
        private boolean started;
        private String continueToken;
        private int offsetCurrentPage;
        private int currentPageSize;
        private ApiListType listObjectCurrentPage;

        private PagerIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.listObjectCurrentPage.getItems() == null || this.listObjectCurrentPage.getItems().size() == 0) {
                return false;
            }
            if (!this.started) {
                this.started = true;
                return Boolean.TRUE;
            }
            return this.continueToken != null || this.offsetCurrentPage < this.currentPageSize;
        }

        protected void makeCall() {
            try {
                Call call = Pager.this.getNextCall(Pager.this.limit, this.continueToken);
                this.listObjectCurrentPage = Pager.this.executeRequest(call);
                this.continueToken = this.listObjectCurrentPage.getMetadata().getContinue();
                this.offsetCurrentPage = 0;
                this.currentPageSize = this.listObjectCurrentPage.getItems().size();
            }
            catch (ApiException e) {
                throw new RuntimeException(e.getResponseBody());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public ApiType next() {
            if (this.offsetCurrentPage >= this.currentPageSize) {
                this.makeCall();
            }
            return (KubernetesObject)this.listObjectCurrentPage.getItems().get(this.offsetCurrentPage++);
        }
    }

    public static class PagerParams {
        private String continueToken;
        private Integer limit;

        private PagerParams(Integer limit, String continueToken) {
            this.limit = limit;
            this.continueToken = continueToken;
        }

        public Integer getLimit() {
            return this.limit;
        }

        public String getContinueToken() {
            return this.continueToken;
        }
    }
}

