/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.google;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.druid.data.input.RetryingInputEntity;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.storage.google.GoogleByteSource;
import org.apache.druid.storage.google.GoogleStorage;
import org.apache.druid.storage.google.GoogleUtils;

public class GoogleCloudStorageEntity
extends RetryingInputEntity {
    private final CloudObjectLocation location;
    private final GoogleByteSource byteSource;

    GoogleCloudStorageEntity(GoogleStorage storage, CloudObjectLocation location) {
        this.location = location;
        this.byteSource = new GoogleByteSource(storage, location.getBucket(), location.getPath());
    }

    @Nullable
    public URI getUri() {
        return this.location.toUri("gs");
    }

    protected InputStream readFrom(long offset) throws IOException {
        return this.byteSource.openStream(offset);
    }

    protected String getPath() {
        return StringUtils.maybeRemoveLeadingSlash((String)this.byteSource.getPath());
    }

    public Predicate<Throwable> getRetryCondition() {
        return GoogleUtils.GOOGLE_RETRY;
    }

    CloudObjectLocation getLocation() {
        return this.location;
    }
}

