/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord;

import java.util.List;
import java.util.Map;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.apache.druid.k8s.overlord.KubernetesTaskRunnerStaticConfig;
import org.joda.time.Period;

public interface KubernetesTaskRunnerConfig {
    public String getNamespace();

    public String getOverlordNamespace();

    public String getK8sTaskPodNamePrefix();

    public boolean isDebugJobs();

    @Deprecated
    public boolean isSidecarSupport();

    public String getPrimaryContainerName();

    public String getKubexitImage();

    public Long getGraceTerminationPeriodSeconds();

    public boolean isDisableClientProxy();

    public Period getTaskTimeout();

    public Period getTaskJoinTimeout();

    public Period getTaskCleanupDelay();

    public Period getTaskCleanupInterval();

    public Period getTaskLaunchTimeout();

    public Period getLogSaveTimeout();

    public List<String> getPeonMonitors();

    public List<String> getJavaOptsArray();

    public int getCpuCoreInMicro();

    public Map<String, String> getLabels();

    public Map<String, String> getAnnotations();

    public Integer getCapacity();

    public boolean isUseK8sSharedInformers();

    public Period getK8sSharedInformerResyncPeriod();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String namespace;
        private String overlordNamespace;
        private String k8sTaskPodNamePrefix;
        private boolean debugJob;
        private boolean sidecarSupport;
        private String primaryContainerName;
        private String kubexitImage;
        private Long graceTerminationPeriodSeconds;
        private boolean disableClientProxy;
        private Period maxTaskDuration;
        private Period taskCleanupDelay;
        private Period taskCleanupInterval;
        private Period k8sjobLaunchTimeout;
        private List<String> peonMonitors;
        private List<String> javaOptsArray;
        private int cpuCoreInMicro;
        private Map<String, String> labels;
        private Map<String, String> annotations;
        private Integer capacity;
        private Period taskJoinTimeout;
        private Period logSaveTimeout;
        private boolean useK8sSharedInformers;
        private Period k8sSharedInformerResyncPeriod;

        public Builder withNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder withOverlordNamespace(String overlordNamespace) {
            this.overlordNamespace = overlordNamespace;
            return this;
        }

        public Builder withK8sTaskPodNamePrefix(String k8sTaskPodNamePrefix) {
            this.k8sTaskPodNamePrefix = k8sTaskPodNamePrefix;
            return this;
        }

        public Builder withDebugJob(boolean debugJob) {
            this.debugJob = debugJob;
            return this;
        }

        public Builder withSidecarSupport(boolean sidecarSupport) {
            this.sidecarSupport = sidecarSupport;
            return this;
        }

        public Builder withPrimaryContainerName(String primaryContainerName) {
            this.primaryContainerName = primaryContainerName;
            return this;
        }

        public Builder withKubexitImage(String kubexitImage) {
            this.kubexitImage = kubexitImage;
            return this;
        }

        public Builder withGraceTerminationPeriodSeconds(Long graceTerminationPeriodSeconds) {
            this.graceTerminationPeriodSeconds = graceTerminationPeriodSeconds;
            return this;
        }

        public Builder withDisableClientProxy(boolean disableClientProxy) {
            this.disableClientProxy = disableClientProxy;
            return this;
        }

        public Builder withTaskTimeout(Period taskTimeout) {
            this.maxTaskDuration = taskTimeout;
            return this;
        }

        public Builder withTaskCleanupDelay(Period taskCleanupDelay) {
            this.taskCleanupDelay = taskCleanupDelay;
            return this;
        }

        public Builder withTaskCleanupInterval(Period taskCleanupInterval) {
            this.taskCleanupInterval = taskCleanupInterval;
            return this;
        }

        public Builder withK8sJobLaunchTimeout(Period k8sjobLaunchTimeout) {
            this.k8sjobLaunchTimeout = k8sjobLaunchTimeout;
            return this;
        }

        public Builder withPeonMonitors(List<String> peonMonitors) {
            this.peonMonitors = peonMonitors;
            return this;
        }

        public Builder withCpuCore(int cpuCore) {
            this.cpuCoreInMicro = cpuCore;
            return this;
        }

        public Builder withJavaOptsArray(List<String> javaOptsArray) {
            this.javaOptsArray = javaOptsArray;
            return this;
        }

        public Builder withLabels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder withAnnotations(Map<String, String> annotations) {
            this.annotations = annotations;
            return this;
        }

        public Builder withCapacity(@Min(value=0L) @Max(value=0x7FFFFFFFL) @Min(value=0L) @Max(value=0x7FFFFFFFL) Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        public Builder withTaskJoinTimeout(Period taskJoinTimeout) {
            this.taskJoinTimeout = taskJoinTimeout;
            return this;
        }

        public Builder withLogSaveTimeout(Period logSaveTimeout) {
            this.logSaveTimeout = logSaveTimeout;
            return this;
        }

        public Builder withUseK8sSharedInformers(boolean useK8sSharedInformers) {
            this.useK8sSharedInformers = useK8sSharedInformers;
            return this;
        }

        public Builder withK8sSharedInformerResyncPeriod(Period k8sSharedInformerResyncPeriod) {
            this.k8sSharedInformerResyncPeriod = k8sSharedInformerResyncPeriod;
            return this;
        }

        public KubernetesTaskRunnerStaticConfig build() {
            return new KubernetesTaskRunnerStaticConfig(this.namespace, this.overlordNamespace, this.k8sTaskPodNamePrefix, this.debugJob, this.sidecarSupport, this.primaryContainerName, this.kubexitImage, this.graceTerminationPeriodSeconds, this.disableClientProxy, this.maxTaskDuration, this.taskCleanupDelay, this.taskCleanupInterval, this.k8sjobLaunchTimeout, this.logSaveTimeout, this.peonMonitors, this.javaOptsArray, this.cpuCoreInMicro, this.labels, this.annotations, this.capacity, this.taskJoinTimeout, this.useK8sSharedInformers, this.k8sSharedInformerResyncPeriod);
        }
    }
}

