/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.common;

import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import java.util.function.BiConsumer;
import org.apache.druid.k8s.overlord.common.InformerEventType;

public class InformerEventHandler<T>
implements ResourceEventHandler<T> {
    private final BiConsumer<T, InformerEventType> eventConsumer;

    public InformerEventHandler(BiConsumer<T, InformerEventType> eventConsumer) {
        this.eventConsumer = eventConsumer;
    }

    public void onAdd(T resource) {
        this.eventConsumer.accept(resource, InformerEventType.ADD);
    }

    public void onUpdate(T oldResource, T newResource) {
        this.eventConsumer.accept(newResource, InformerEventType.UPDATE);
    }

    public void onDelete(T resource, boolean deletedFinalStateUnknown) {
        this.eventConsumer.accept(resource, InformerEventType.DELETE);
    }
}

