/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.taskadapter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.k8s.overlord.KubernetesTaskRunnerConfig;
import org.apache.druid.k8s.overlord.common.Base64Compression;
import org.apache.druid.k8s.overlord.common.K8sTaskId;
import org.apache.druid.k8s.overlord.common.KubernetesClientApi;
import org.apache.druid.k8s.overlord.common.PeonCommandContext;
import org.apache.druid.k8s.overlord.taskadapter.K8sTaskAdapter;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.log.StartupLoggingConfig;
import org.apache.druid.tasklogs.TaskLogs;

public class MultiContainerTaskAdapter
extends K8sTaskAdapter {
    public static final String TYPE = "overlordMultiContainer";

    public MultiContainerTaskAdapter(KubernetesClientApi client, KubernetesTaskRunnerConfig taskRunnerConfig, TaskConfig taskConfig, StartupLoggingConfig startupLoggingConfig, DruidNode druidNode, ObjectMapper mapper, TaskLogs taskLogs) {
        super(client, taskRunnerConfig, taskConfig, startupLoggingConfig, druidNode, mapper, taskLogs);
    }

    @Override
    public String getAdapterType() {
        return TYPE;
    }

    @Override
    Job createJobFromPodSpec(PodSpec podSpec, Task task, PeonCommandContext context) throws IOException {
        K8sTaskId k8sTaskId = new K8sTaskId(this.taskRunnerConfig.getK8sTaskPodNamePrefix(), task.getId());
        long containerSize = MultiContainerTaskAdapter.getContainerMemory(context);
        String taskContents = Base64Compression.compressBase64(this.mapper.writeValueAsString((Object)task));
        this.setupMainContainer(podSpec, context, containerSize, taskContents);
        Map<String, String> annotations = this.addJobSpecificAnnotations(context, k8sTaskId);
        Map<String, String> labels = this.addJobSpecificLabels();
        PodTemplateSpec podTemplate = this.createTemplateFromSpec(k8sTaskId, podSpec, annotations, labels);
        MultiContainerTaskAdapter.addSideCarTerminationSupport(podTemplate);
        podTemplate.getSpec().getInitContainers().add(this.getInitContainer());
        return this.buildJob(k8sTaskId, labels, annotations, podTemplate);
    }

    @VisibleForTesting
    private Container getInitContainer() {
        return ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName("kubexit")).withImage(this.taskRunnerConfig.getKubexitImage())).withCommand(new String[]{"cp", "/bin/kubexit", "/kubexit/kubexit"})).withVolumeMounts(new VolumeMount[]{((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath("/kubexit")).withName("kubexit")).build()})).build();
    }

    static void reJiggerArgsAndCommand(Container container, boolean primary) {
        List originalCommand = container.getCommand();
        List originalArgs = container.getArgs();
        originalCommand.addAll(originalArgs);
        String newArgs = primary ? Joiner.on((String)" ").join((Iterable)originalArgs) : Joiner.on((String)" ").join((Iterable)originalCommand);
        container.setCommand((List)Lists.newArrayList((Object[])new String[]{"/bin/sh", "-c"}));
        String toExecute = "/kubexit/kubexit /bin/sh -c \"" + StringEscapeUtils.escapeJava((String)newArgs) + "\"";
        if (!primary) {
            toExecute = toExecute + " || true";
        }
        container.setArgs(Collections.singletonList(toExecute));
    }

    static void addSideCarTerminationSupport(PodTemplateSpec spec) {
        Volume graveyard = ((VolumeBuilder)((VolumeFluent.EmptyDirNested)((VolumeBuilder)new VolumeBuilder().withName("graveyard")).withNewEmptyDir().withMedium("Memory")).endEmptyDir()).build();
        Volume kubeExit = ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName("kubexit")).withNewEmptyDir().endEmptyDir()).build();
        spec.getSpec().getVolumes().add(graveyard);
        spec.getSpec().getVolumes().add(kubeExit);
        VolumeMount gMount = ((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath("/graveyard")).withName("graveyard")).build();
        VolumeMount kMount = ((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath("/kubexit")).withName("kubexit")).build();
        List containers = spec.getSpec().getContainers();
        for (int i = 0; i < containers.size(); ++i) {
            Container container = (Container)containers.get(i);
            container.getEnv().add(new EnvVar("KUBEXIT_NAME", container.getName(), null));
            container.getEnv().add(new EnvVar("KUBEXIT_GRAVEYARD", "/graveyard", null));
            container.getVolumeMounts().add(gMount);
            container.getVolumeMounts().add(kMount);
            if (i > 0) {
                container.getEnv().add(new EnvVar("KUBEXIT_DEATH_DEPS", ((Container)containers.get(0)).getName(), null));
                MultiContainerTaskAdapter.reJiggerArgsAndCommand(container, false);
                continue;
            }
            MultiContainerTaskAdapter.reJiggerArgsAndCommand(container, true);
        }
    }
}

