/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.sync;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableDefnRegistry;
import org.apache.druid.catalog.model.TableId;
import org.apache.druid.catalog.model.TableMetadata;
import org.apache.druid.catalog.model.TableSpec;
import org.apache.druid.catalog.sync.CatalogSource;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHandler;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.rpc.IgnoreHttpResponseHandler;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceLocator;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.StandardRetryPolicy;
import org.apache.druid.server.http.ServletResourceUtils;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class CatalogClient
implements CatalogSource {
    public static final String SCHEMA_SYNC_PATH = "/druid/coordinator/v1/catalog/sync/schemas/{schema}";
    public static final String TABLE_SYNC_PATH = "/druid/coordinator/v1/catalog/sync/schemas/{schema}/{name}";
    private static final String TABLE_CREATE_PATH = "/druid/coordinator/v1/catalog/schemas/{schema}/tables/{name}";
    private final ServiceClient serviceClient;
    private final ObjectMapper jsonMapper;
    private final TableDefnRegistry tableRegistry;

    @Inject
    public CatalogClient(@EscalatedGlobal ServiceClientFactory clientFactory, @Coordinator ServiceLocator serviceLocator, ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.tableRegistry = new TableDefnRegistry(jsonMapper);
        this.serviceClient = clientFactory.makeClient(NodeRole.COORDINATOR.getJsonName(), serviceLocator, (ServiceRetryPolicy)StandardRetryPolicy.builder().maxAttempts(6L).build());
    }

    @Override
    public List<TableMetadata> tablesForSchema(String dbSchema) {
        List<TableMetadata> results = this.getResult(this.fetchTablesForSchema(dbSchema));
        return results == null ? Collections.emptyList() : results;
    }

    @Override
    public TableMetadata table(TableId id) {
        return this.getResult(this.fetchTableForId(id));
    }

    @Override
    public ResolvedTable resolveTable(TableId id) {
        TableMetadata table = this.table(id);
        return table == null ? null : this.tableRegistry.resolve(table.spec());
    }

    public void createTable(TableId tableId, TableSpec tableSpec) {
        this.getResult(this.postCreateTable(tableId, tableSpec));
    }

    private ListenableFuture<Void> postCreateTable(TableId tableId, TableSpec tableSpec) {
        String path = StringUtils.replace((String)TABLE_CREATE_PATH, (String)"{schema}", (String)StringUtils.urlEncode((String)tableId.schema()));
        path = StringUtils.replace((String)path, (String)"{name}", (String)StringUtils.urlEncode((String)tableId.name()));
        return this.serviceClient.asyncRequest(new RequestBuilder(HttpMethod.POST, path).jsonContent(this.jsonMapper, (Object)tableSpec), (HttpResponseHandler)IgnoreHttpResponseHandler.INSTANCE);
    }

    private ListenableFuture<TableMetadata> fetchTableForId(TableId id) {
        String path = StringUtils.replace((String)TABLE_SYNC_PATH, (String)"{schema}", (String)StringUtils.urlEncode((String)id.schema()));
        path = StringUtils.replace((String)path, (String)"{name}", (String)StringUtils.urlEncode((String)id.name()));
        return FutureUtils.transform((ListenableFuture)this.serviceClient.asyncRequest(new RequestBuilder(HttpMethod.GET, path), (HttpResponseHandler)new BytesFullResponseHandler()), holder -> (TableMetadata)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])holder.getContent(), TableMetadata.class));
    }

    private ListenableFuture<List<TableMetadata>> fetchTablesForSchema(String schemaName) {
        String path = StringUtils.replace((String)SCHEMA_SYNC_PATH, (String)"{schema}", (String)StringUtils.urlEncode((String)schemaName));
        return FutureUtils.transform((ListenableFuture)this.serviceClient.asyncRequest(new RequestBuilder(HttpMethod.GET, path), (HttpResponseHandler)new BytesFullResponseHandler()), holder -> (List)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])holder.getContent(), (TypeReference)new TypeReference<List<TableMetadata>>(){}));
    }

    @Nullable
    private <T> T getResult(ListenableFuture<T> future) {
        try {
            return (T)FutureUtils.getUnchecked(future, (boolean)true);
        }
        catch (Exception e) {
            return (T)ServletResourceUtils.getDefaultValueIfCauseIs404ElseThrow((Exception)e, () -> null);
        }
    }
}

