/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.batch.command.internal;

import com.google.common.base.Splitter;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.batch.command.CommandStrategy;
import org.apache.fineract.batch.command.CommandStrategyUtils;
import org.apache.fineract.batch.domain.BatchRequest;
import org.apache.fineract.batch.domain.BatchResponse;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.portfolio.interestpauses.api.LoanInterestPauseApiResource;
import org.apache.fineract.portfolio.interestpauses.data.InterestPauseResponseDto;
import org.springframework.stereotype.Component;

@Component
public class GetLoanInterestPausesByLoanIdCommandStrategy
implements CommandStrategy {
    private final LoanInterestPauseApiResource loanInterestPauseApiResource;
    private final DefaultToApiJsonSerializer<List<InterestPauseResponseDto>> toApiJsonSerializer;

    public BatchResponse execute(BatchRequest request, UriInfo uriInfo) {
        BatchResponse response = new BatchResponse();
        response.setRequestId(request.getRequestId());
        response.setHeaders(request.getHeaders());
        List pathParameters = Splitter.on((char)'/').splitToList((CharSequence)CommandStrategyUtils.relativeUrlWithoutVersion((BatchRequest)request));
        Long loanId = Long.parseLong((String)pathParameters.get(1));
        List responseDtos = this.loanInterestPauseApiResource.retrieveInterestPauses(loanId);
        response.setStatusCode(Integer.valueOf(200));
        response.setBody(this.toApiJsonSerializer.serialize((Object)responseDtos));
        return response;
    }

    @Generated
    public GetLoanInterestPausesByLoanIdCommandStrategy(LoanInterestPauseApiResource loanInterestPauseApiResource, DefaultToApiJsonSerializer<List<InterestPauseResponseDto>> toApiJsonSerializer) {
        this.loanInterestPauseApiResource = loanInterestPauseApiResource;
        this.toApiJsonSerializer = toApiJsonSerializer;
    }
}

