/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.util;

import java.util.Objects;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class IdPair<L, R> {
    final L left;
    final R right;

    public static <L, R> IdPair<L, R> of(L left, R right) {
        return new IdPair<L, R>(left, right);
    }

    protected IdPair(L left, R right) {
        this.left = Objects.requireNonNull(left, "left");
        this.right = Objects.requireNonNull(right, "right");
    }

    public String toString() {
        return this.left + "=" + this.right;
    }

    public boolean equals(@Nullable Object obj) {
        return obj == this || obj instanceof IdPair && this.left == ((IdPair)obj).left && this.right == ((IdPair)obj).right;
    }

    public int hashCode() {
        return (31 + System.identityHashCode(this.left)) * 31 + System.identityHashCode(this.right);
    }
}

