/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.AdaptiveJoinExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecAdaptiveJoin;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.spec.JoinSpec;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.JoinUtil;
import org.apache.flink.table.planner.plan.utils.OperatorType;
import org.apache.flink.table.planner.plan.utils.SorMergeJoinOperatorUtil;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class BatchExecSortMergeJoin
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData>,
SingleTransformationTranslator<RowData>,
AdaptiveJoinExecNode {
    private final FlinkJoinType joinType;
    private final int[] leftKeys;
    private final int[] rightKeys;
    private final boolean[] filterNulls;
    @Nullable
    private final RexNode nonEquiCondition;
    private final int estimatedLeftAvgRowSize;
    private final int estimatedRightAvgRowSize;
    private final long estimatedLeftRowCount;
    private final long estimatedRightRowCount;
    private final boolean leftIsSmaller;
    private final boolean withJobStrategyHint;

    public BatchExecSortMergeJoin(ReadableConfig tableConfig, FlinkJoinType joinType, int[] leftKeys, int[] rightKeys, boolean[] filterNulls, @Nullable RexNode nonEquiCondition, int estimatedLeftAvgRowSize, int estimatedRightAvgRowSize, long estimatedLeftRowCount, long estimatedRightRowCount, boolean leftIsSmaller, InputProperty leftInputProperty, InputProperty rightInputProperty, RowType outputType, boolean withJobStrategyHint, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecSortMergeJoin.class), ExecNodeContext.newPersistedConfig(BatchExecSortMergeJoin.class, tableConfig), Arrays.asList(leftInputProperty, rightInputProperty), (LogicalType)outputType, description);
        this.joinType = (FlinkJoinType)Preconditions.checkNotNull((Object)joinType);
        this.leftKeys = (int[])Preconditions.checkNotNull((Object)leftKeys);
        this.rightKeys = (int[])Preconditions.checkNotNull((Object)rightKeys);
        this.filterNulls = (boolean[])Preconditions.checkNotNull((Object)filterNulls);
        Preconditions.checkArgument((leftKeys.length > 0 && leftKeys.length == rightKeys.length ? 1 : 0) != 0);
        Preconditions.checkArgument((leftKeys.length == filterNulls.length ? 1 : 0) != 0);
        this.nonEquiCondition = nonEquiCondition;
        this.estimatedLeftAvgRowSize = estimatedLeftAvgRowSize;
        this.estimatedRightAvgRowSize = estimatedRightAvgRowSize;
        this.estimatedLeftRowCount = estimatedLeftRowCount;
        this.estimatedRightRowCount = estimatedRightRowCount;
        this.leftIsSmaller = leftIsSmaller;
        this.withJobStrategyHint = withJobStrategyHint;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge leftInputEdge = this.getInputEdges().get(0);
        ExecEdge rightInputEdge = this.getInputEdges().get(1);
        RowType leftType = (RowType)leftInputEdge.getOutputType();
        RowType rightType = (RowType)rightInputEdge.getOutputType();
        long externalBufferMemory = ((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_EXTERNAL_BUFFER_MEMORY)).getBytes();
        long sortMemory = ((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_SORT_MEMORY)).getBytes();
        int externalBufferNum = 1;
        if (this.joinType == FlinkJoinType.FULL) {
            externalBufferNum = 2;
        }
        long managedMemory = externalBufferMemory * (long)externalBufferNum + sortMemory * 2L;
        GeneratedJoinCondition condFunc = JoinUtil.generateConditionFunction((ReadableConfig)config, planner.getFlinkContext().getClassLoader(), this.nonEquiCondition, (LogicalType)leftType, (LogicalType)rightType);
        SimpleOperatorFactory<RowData> sortMergeJoinOperatorFactory = SorMergeJoinOperatorUtil.generateOperatorFactory(condFunc, leftType, rightType, this.leftKeys, this.rightKeys, this.joinType, config, this.leftIsSmaller, this.filterNulls, managedMemory, planner.getFlinkContext().getClassLoader());
        Transformation<?> leftInputTransform = leftInputEdge.translateToPlan(planner);
        Transformation<?> rightInputTransform = rightInputEdge.translateToPlan(planner);
        return ExecNodeUtil.createTwoInputTransformation(leftInputTransform, rightInputTransform, this.createTransformationName(config), this.createTransformationDescription(config), sortMergeJoinOperatorFactory, InternalTypeInfo.of((LogicalType)this.getOutputType()), rightInputTransform.getParallelism(), managedMemory, false);
    }

    @Override
    public boolean canBeTransformedToAdaptiveJoin() {
        return !this.withJobStrategyHint && this.joinType != FlinkJoinType.FULL;
    }

    @Override
    public BatchExecAdaptiveJoin toAdaptiveJoinNode() {
        return new BatchExecAdaptiveJoin(this.getPersistedConfig(), new JoinSpec(this.joinType, this.leftKeys, this.rightKeys, this.filterNulls, this.nonEquiCondition), this.estimatedLeftAvgRowSize, this.estimatedRightAvgRowSize, this.estimatedLeftRowCount, this.estimatedRightRowCount, this.leftIsSmaller, false, this.getInputProperties(), (RowType)this.getOutputType(), this.getDescription(), OperatorType.SortMergeJoin);
    }
}

