/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.stream;

import java.time.Duration;
import java.util.Optional;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.datastream.AsyncDataStream;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DeltaJoinSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecDeltaJoin;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.utils.FunctionCallUtils;
import org.apache.flink.table.planner.plan.utils.RelExplainUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import scala.collection.immutable.List;

public class StreamPhysicalDeltaJoin
extends BiRel
implements StreamPhysicalRel,
Hintable {
    private final FlinkJoinType joinType;
    private final RexNode originalJoinCondition;
    private final ImmutableList<RelHint> hints;
    private final RelDataType rowType;
    private final DeltaJoinSpec lookupRightTableJoinSpec;
    private final DeltaJoinSpec lookupLeftTableJoinSpec;

    public StreamPhysicalDeltaJoin(RelOptCluster cluster, RelTraitSet traitSet, java.util.List<RelHint> hints, RelNode left, RelNode right, FlinkJoinType joinType, RexNode originalJoinCondition, DeltaJoinSpec lookupRightTableJoinSpec, DeltaJoinSpec lookupLeftTableJoinSpec, RelDataType rowType) {
        super(cluster, traitSet, left, right);
        this.hints = ImmutableList.copyOf(hints);
        this.joinType = joinType;
        this.originalJoinCondition = originalJoinCondition;
        this.lookupRightTableJoinSpec = lookupRightTableJoinSpec;
        this.lookupLeftTableJoinSpec = lookupLeftTableJoinSpec;
        this.rowType = rowType;
    }

    @Override
    public ExecNode<?> translateToExecNode() {
        TableConfig config = ShortcutUtils.unwrapTableConfig(this);
        FunctionCallUtils.AsyncOptions asyncLookupOptions = new FunctionCallUtils.AsyncOptions((Integer)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_LOOKUP_BUFFER_CAPACITY), ((Duration)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_LOOKUP_TIMEOUT)).toMillis(), true, AsyncDataStream.OutputMode.ORDERED);
        JoinInfo joinInfo = JoinInfo.of(this.left, this.right, this.originalJoinCondition);
        return new StreamExecDeltaJoin((ReadableConfig)config, this.joinType, joinInfo.leftKeys.toIntArray(), this.lookupRightTableJoinSpec, joinInfo.rightKeys.toIntArray(), this.lookupLeftTableJoinSpec, InputProperty.DEFAULT, InputProperty.DEFAULT, FlinkTypeFactory.toLogicalRowType(this.rowType), this.getRelDetailedDescription(), asyncLookupOptions);
    }

    @Override
    public boolean requireWatermark() {
        return false;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, java.util.List<RelNode> inputs) {
        assert (inputs.size() == 2);
        return new StreamPhysicalDeltaJoin(this.getCluster(), traitSet, this.hints, inputs.get(0), inputs.get(1), this.joinType, this.originalJoinCondition, this.lookupRightTableJoinSpec, this.lookupLeftTableJoinSpec, this.rowType);
    }

    @Override
    protected RelDataType deriveRowType() {
        return this.rowType;
    }

    @Override
    public ImmutableList<RelHint> getHints() {
        return this.hints;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("joinType", this.joinType.toString()).item("where", this.getExpressionString(this.originalJoinCondition, (List<String>)JavaScalaConversionUtil.toScala(this.getRowType().getFieldNames()).toList(), JavaScalaConversionUtil.toScala(Optional.empty()), RelExplainUtil.preferExpressionFormat(pw), RelExplainUtil.preferExpressionDetail(pw))).item("select", String.join((CharSequence)", ", this.rowType.getFieldNames()));
    }
}

