/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.stream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecMultiJoin;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.stream.keyselector.AttributeBasedJoinKeyExtractor;
import org.apache.flink.table.runtime.operators.join.stream.keyselector.JoinKeyExtractor;

public class StreamPhysicalMultiJoin
extends AbstractRelNode
implements StreamPhysicalRel {
    private List<RelNode> inputs;
    private final RexNode joinFilter;
    private final List<JoinRelType> joinTypes;
    private final List<? extends @Nullable RexNode> joinConditions;
    private final JoinKeyExtractor keyExtractor;
    private final Map<Integer, List<AttributeBasedJoinKeyExtractor.ConditionAttributeRef>> joinAttributeMap;
    private final @Nullable RexNode postJoinFilter;
    private final List<RelHint> hints;

    public StreamPhysicalMultiJoin(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, RexNode joinFilter, RelDataType rowType, List<? extends @Nullable RexNode> joinConditions, List<JoinRelType> joinTypes, Map<Integer, List<AttributeBasedJoinKeyExtractor.ConditionAttributeRef>> joinAttributeMap, @Nullable RexNode postJoinFilter, List<RelHint> hints, JoinKeyExtractor keyExtractor) {
        super(cluster, traitSet);
        this.inputs = inputs;
        this.rowType = rowType;
        this.joinFilter = joinFilter;
        this.joinTypes = joinTypes;
        this.joinConditions = joinConditions;
        this.joinAttributeMap = joinAttributeMap;
        this.postJoinFilter = postJoinFilter;
        this.hints = hints;
        this.keyExtractor = keyExtractor;
    }

    @Override
    public boolean requireWatermark() {
        return false;
    }

    @Override
    public List<RelNode> getInputs() {
        return this.inputs;
    }

    @Override
    public void replaceInput(int ordinalInParent, RelNode p) {
        assert (ordinalInParent >= 0 && ordinalInParent < this.inputs.size());
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>(this.inputs);
        newInputs.set(ordinalInParent, p);
        this.inputs = List.copyOf(newInputs);
        this.recomputeDigest();
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new StreamPhysicalMultiJoin(this.getCluster(), traitSet, inputs, this.joinFilter, this.getRowType(), this.joinConditions, this.joinTypes, this.joinAttributeMap, this.postJoinFilter, this.hints, this.keyExtractor);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double elementRate = 100.0 * (double)this.getInputs().size();
        return planner.getCostFactory().makeCost(elementRate, elementRate, 0.0);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        for (Ord<RelNode> ord : Ord.zip(this.inputs)) {
            pw.input("input#" + ord.i, (RelNode)ord.e);
        }
        return pw.item("joinFilter", this.joinFilter).item("joinTypes", this.joinTypes).item("joinConditions", this.joinConditions).item("joinAttributeMap", this.joinAttributeMap).itemIf("postJoinFilter", this.postJoinFilter, this.postJoinFilter != null).item("select", String.join((CharSequence)",", this.getRowType().getFieldNames())).item("rowType", this.getRowType());
    }

    @Override
    protected RelDataType deriveRowType() {
        return this.rowType;
    }

    @Override
    public ExecNode<?> translateToExecNode() {
        RexNode multiJoinCondition = this.createMultiJoinCondition();
        List<List<int[]>> inputUpsertKeys = this.getUpsertKeysForInputs();
        List<FlinkJoinType> execJoinTypes = this.getExecJoinTypes();
        List<InputProperty> inputProperties = this.createInputProperties();
        return new StreamExecMultiJoin((ReadableConfig)ShortcutUtils.unwrapTableConfig(this), execJoinTypes, this.joinConditions, multiJoinCondition, this.joinAttributeMap, inputUpsertKeys, Collections.emptyMap(), inputProperties, FlinkTypeFactory.toLogicalRowType(this.getRowType()), this.getRelDetailedDescription());
    }

    private RexNode createMultiJoinCondition() {
        ArrayList<RexNode> conjunctions = new ArrayList<RexNode>();
        conjunctions.add(this.joinFilter);
        if (this.postJoinFilter != null) {
            conjunctions.add(this.postJoinFilter);
        }
        return RexUtil.composeConjunction(this.getCluster().getRexBuilder(), conjunctions, true);
    }

    private List<List<int[]>> getUpsertKeysForInputs() {
        return this.inputs.stream().map(input -> {
            Set<ImmutableBitSet> upsertKeys = this.getUpsertKeys((RelNode)input);
            if (upsertKeys == null) {
                return Collections.emptyList();
            }
            return upsertKeys.stream().map(ImmutableBitSet::toArray).collect(Collectors.toList());
        }).collect(Collectors.toList());
    }

    private @Nullable Set<ImmutableBitSet> getUpsertKeys(RelNode input) {
        FlinkRelMetadataQuery fmq = FlinkRelMetadataQuery.reuseOrCreate(input.getCluster().getMetadataQuery());
        return fmq.getUpsertKeys(input);
    }

    private List<FlinkJoinType> getExecJoinTypes() {
        return this.joinTypes.stream().map(joinType -> {
            if (joinType == JoinRelType.INNER) {
                return FlinkJoinType.INNER;
            }
            if (joinType == JoinRelType.LEFT) {
                return FlinkJoinType.LEFT;
            }
            throw new UnsupportedOperationException("Unsupported join type: " + String.valueOf(joinType));
        }).collect(Collectors.toList());
    }

    public List<JoinRelType> getJoinTypes() {
        return this.joinTypes;
    }

    public boolean inputUniqueKeyContainsCommonJoinKey(int inputId) {
        RelNode input = this.getInputs().get(inputId);
        Set<ImmutableBitSet> inputUniqueKeys = this.getUpsertKeys(input);
        if (inputUniqueKeys == null || inputUniqueKeys.isEmpty()) {
            return false;
        }
        int[] commonJoinKeyIndices = this.keyExtractor.getCommonJoinKeyIndices(inputId);
        if (commonJoinKeyIndices.length == 0) {
            return false;
        }
        ImmutableBitSet commonJoinKeys = ImmutableBitSet.of(commonJoinKeyIndices);
        return inputUniqueKeys.stream().anyMatch(uniqueKey -> uniqueKey.contains(commonJoinKeys));
    }

    private List<InputProperty> createInputProperties() {
        ArrayList<InputProperty> inputProperties = new ArrayList<InputProperty>();
        for (int i = 0; i < this.inputs.size(); ++i) {
            InputProperty inputProperty = this.createInputPropertyFromTrait(this.getInput(i), i);
            inputProperties.add(inputProperty);
        }
        return inputProperties;
    }

    private InputProperty createInputPropertyFromTrait(RelNode input, int inputIndex) {
        InputProperty.RequiredDistribution requiredDistribution;
        FlinkRelDistribution distribution = input.getTraitSet().getTrait(FlinkRelDistributionTraitDef.INSTANCE());
        if (distribution == null) {
            return InputProperty.DEFAULT;
        }
        switch (distribution.getType()) {
            case HASH_DISTRIBUTED: {
                int[] keys = distribution.getKeys().toIntArray();
                if (keys.length == 0) {
                    requiredDistribution = InputProperty.SINGLETON_DISTRIBUTION;
                    break;
                }
                requiredDistribution = InputProperty.hashDistribution(keys);
                break;
            }
            case SINGLETON: {
                requiredDistribution = InputProperty.SINGLETON_DISTRIBUTION;
                break;
            }
            default: {
                return InputProperty.DEFAULT;
            }
        }
        return InputProperty.builder().requiredDistribution(requiredDistribution).damBehavior(InputProperty.DamBehavior.PIPELINED).priority(inputIndex).build();
    }
}

