/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalRank;

public class RedundantRankNumberColumnRemoveRule
extends RelOptRule {
    public static final RedundantRankNumberColumnRemoveRule INSTANCE = new RedundantRankNumberColumnRemoveRule();

    public RedundantRankNumberColumnRemoveRule() {
        super(RedundantRankNumberColumnRemoveRule.operand(FlinkLogicalCalc.class, RedundantRankNumberColumnRemoveRule.operand(FlinkLogicalRank.class, RedundantRankNumberColumnRemoveRule.any()), new RelOptRuleOperand[0]), "RedundantRankNumberColumnRemoveRule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        ImmutableBitSet usedFields = this.getUsedFields(calc.getProgram());
        FlinkLogicalRank rank = (FlinkLogicalRank)call.rel(1);
        return rank.outputRankNumber() && !usedFields.get(rank.getRowType().getFieldCount() - 1);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        FlinkLogicalRank rank = (FlinkLogicalRank)call.rel(1);
        FlinkLogicalRank newRank = new FlinkLogicalRank(rank.getCluster(), rank.getTraitSet(), rank.getInput(), rank.partitionKey(), rank.orderKey(), rank.rankType(), rank.rankRange(), rank.rankNumberType(), false);
        RexProgram oldProgram = calc.getProgram();
        Pair<List<RexNode>, RexNode> projectsAndCondition = this.getProjectsAndCondition(oldProgram);
        RexProgram newProgram = RexProgram.create(newRank.getRowType(), (List<? extends RexNode>)((List)projectsAndCondition.left), (RexNode)projectsAndCondition.right, oldProgram.getOutputRowType(), rank.getCluster().getRexBuilder());
        FlinkLogicalCalc newCalc = FlinkLogicalCalc.create(newRank, newProgram);
        call.transformTo(newCalc);
    }

    private ImmutableBitSet getUsedFields(RexProgram program) {
        Pair<List<RexNode>, RexNode> projectsAndCondition = this.getProjectsAndCondition(program);
        return RelOptUtil.InputFinder.bits((List)projectsAndCondition.left, (RexNode)projectsAndCondition.right);
    }

    private Pair<List<RexNode>, RexNode> getProjectsAndCondition(RexProgram program) {
        List projects = program.getProjectList().stream().map(program::expandLocalRef).collect(Collectors.toList());
        RexNode condition = null;
        if (program.getCondition() != null) {
            condition = program.expandLocalRef(program.getCondition());
        }
        return Pair.of(projects, condition);
    }
}

