/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.index.vector;

import com.lancedb.lance.index.DistanceType;
import com.lancedb.lance.index.vector.HnswBuildParams;
import com.lancedb.lance.index.vector.IvfBuildParams;
import com.lancedb.lance.index.vector.PQBuildParams;
import com.lancedb.lance.index.vector.SQBuildParams;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class VectorIndexParams {
    private final DistanceType distanceType;
    private final IvfBuildParams ivfParams;
    private final Optional<PQBuildParams> pqParams;
    private final Optional<HnswBuildParams> hnswParams;
    private final Optional<SQBuildParams> sqParams;

    private VectorIndexParams(Builder builder) {
        this.distanceType = builder.distanceType;
        this.ivfParams = builder.ivfParams;
        this.pqParams = builder.pqParams;
        this.hnswParams = builder.hnswParams;
        this.sqParams = builder.sqParams;
        this.validate();
    }

    private void validate() {
        if (this.pqParams.isPresent() && this.sqParams.isPresent()) {
            throw new IllegalArgumentException("PQ and SQ cannot coexist");
        }
        if (this.hnswParams.isPresent() && !this.pqParams.isPresent() && !this.sqParams.isPresent()) {
            throw new IllegalArgumentException("HNSW must be combined with either PQ or SQ");
        }
        if (this.sqParams.isPresent() && !this.hnswParams.isPresent()) {
            throw new IllegalArgumentException("IVF + SQ is not supported");
        }
    }

    public static VectorIndexParams ivfFlat(int numPartitions, DistanceType distanceType) {
        return new Builder(new IvfBuildParams.Builder().setNumPartitions(numPartitions).build()).setDistanceType(distanceType).build();
    }

    public static VectorIndexParams ivfPq(int numPartitions, int numBits, int numSubVectors, DistanceType distanceType, int maxIterations) {
        IvfBuildParams ivfParams = new IvfBuildParams.Builder().setNumPartitions(numPartitions).build();
        PQBuildParams pqParams = new PQBuildParams.Builder().setNumBits(numBits).setNumSubVectors(numSubVectors).setMaxIters(maxIterations).build();
        return new Builder(ivfParams).setDistanceType(distanceType).setPqParams(pqParams).build();
    }

    public static VectorIndexParams withIvfPqParams(DistanceType distanceType, IvfBuildParams ivf, PQBuildParams pq) {
        return new Builder(ivf).setDistanceType(distanceType).setPqParams(pq).build();
    }

    public static VectorIndexParams withIvfHnswPqParams(DistanceType distanceType, IvfBuildParams ivf, HnswBuildParams hnsw, PQBuildParams pq) {
        return new Builder(ivf).setDistanceType(distanceType).setHnswParams(hnsw).setPqParams(pq).build();
    }

    public static VectorIndexParams withIvfHnswSqParams(DistanceType distanceType, IvfBuildParams ivf, HnswBuildParams hnsw, SQBuildParams sq) {
        return new Builder(ivf).setDistanceType(distanceType).setHnswParams(hnsw).setSqParams(sq).build();
    }

    public DistanceType getDistanceType() {
        return this.distanceType;
    }

    public IvfBuildParams getIvfParams() {
        return this.ivfParams;
    }

    public Optional<PQBuildParams> getPqParams() {
        return this.pqParams;
    }

    public Optional<HnswBuildParams> getHnswParams() {
        return this.hnswParams;
    }

    public Optional<SQBuildParams> getSqParams() {
        return this.sqParams;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("distanceType", (Object)this.distanceType).append("ivfParams", (Object)this.ivfParams).append("pqParams", this.pqParams.orElse(null)).append("hnswParams", this.hnswParams.orElse(null)).append("sqParams", this.sqParams.orElse(null)).toString();
    }

    public static class Builder {
        private DistanceType distanceType = DistanceType.L2;
        private final IvfBuildParams ivfParams;
        private Optional<PQBuildParams> pqParams = Optional.empty();
        private Optional<HnswBuildParams> hnswParams = Optional.empty();
        private Optional<SQBuildParams> sqParams = Optional.empty();

        public Builder(IvfBuildParams ivfParams) {
            this.ivfParams = ivfParams;
        }

        public Builder setDistanceType(DistanceType distanceType) {
            this.distanceType = distanceType;
            return this;
        }

        public Builder setPqParams(PQBuildParams pqParams) {
            this.pqParams = Optional.of(pqParams);
            return this;
        }

        public Builder setHnswParams(HnswBuildParams hnswParams) {
            this.hnswParams = Optional.of(hnswParams);
            return this;
        }

        public Builder setSqParams(SQBuildParams sqParams) {
            this.sqParams = Optional.of(sqParams);
            return this;
        }

        public VectorIndexParams build() {
            return new VectorIndexParams(this);
        }
    }
}

