/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors.append;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.deletionvectors.DeletionVectorsIndexFile;
import org.apache.paimon.deletionvectors.DeletionVectorsMaintainer;
import org.apache.paimon.deletionvectors.append.BaseAppendDeleteFileMaintainer;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.table.source.DeletionFile;

public class AppendDeleteFileMaintainer
implements BaseAppendDeleteFileMaintainer {
    private final IndexFileHandler indexFileHandler;
    private final BinaryRow partition;
    private final Map<String, DeletionFile> dataFileToDeletionFile;
    private final Map<String, IndexManifestEntry> indexNameToEntry = new HashMap<String, IndexManifestEntry>();
    private final Map<String, Map<String, DeletionFile>> indexFileToDeletionFiles = new HashMap<String, Map<String, DeletionFile>>();
    private final Map<String, String> dataFileToIndexFile = new HashMap<String, String>();
    private final Set<String> touchedIndexFiles = new HashSet<String>();
    private final DeletionVectorsMaintainer maintainer;

    AppendDeleteFileMaintainer(IndexFileHandler indexFileHandler, BinaryRow partition, Map<String, DeletionFile> deletionFiles) {
        this.indexFileHandler = indexFileHandler;
        this.partition = partition;
        this.dataFileToDeletionFile = new HashMap<String, DeletionFile>(deletionFiles);
        this.maintainer = new DeletionVectorsMaintainer.Factory(indexFileHandler).create();
        List touchedIndexFileNames = deletionFiles.values().stream().map(deletionFile -> new Path(deletionFile.path()).getName()).distinct().collect(Collectors.toList());
        indexFileHandler.scanEntries().stream().filter(indexManifestEntry -> touchedIndexFileNames.contains(indexManifestEntry.indexFile().fileName())).forEach(entry -> this.indexNameToEntry.put(entry.indexFile().fileName(), (IndexManifestEntry)entry));
        for (String dataFile : deletionFiles.keySet()) {
            DeletionFile deletionFile2 = deletionFiles.get(dataFile);
            String indexFileName = new Path(deletionFile2.path()).getName();
            if (!this.indexFileToDeletionFiles.containsKey(indexFileName)) {
                this.indexFileToDeletionFiles.put(indexFileName, new HashMap());
            }
            this.indexFileToDeletionFiles.get(indexFileName).put(dataFile, deletionFile2);
            this.dataFileToIndexFile.put(dataFile, indexFileName);
        }
    }

    @Override
    public BinaryRow getPartition() {
        return this.partition;
    }

    @Override
    public int getBucket() {
        return 0;
    }

    public DeletionFile getDeletionFile(String dataFile) {
        return this.dataFileToDeletionFile.get(dataFile);
    }

    public void putDeletionFile(String dataFile, DeletionFile deletionFile) {
        this.dataFileToDeletionFile.put(dataFile, deletionFile);
    }

    public DeletionVector getDeletionVector(String dataFile) {
        DeletionFile deletionFile = this.getDeletionFile(dataFile);
        if (deletionFile != null) {
            return this.indexFileHandler.deletionVectorsIndex().readDeletionVector(deletionFile);
        }
        return null;
    }

    public DeletionFile notifyRemovedDeletionVector(String dataFile) {
        if (this.dataFileToIndexFile.containsKey(dataFile)) {
            String indexFileName = this.dataFileToIndexFile.get(dataFile);
            this.touchedIndexFiles.add(indexFileName);
            if (this.indexFileToDeletionFiles.containsKey(indexFileName)) {
                return this.indexFileToDeletionFiles.get(indexFileName).remove(dataFile);
            }
        }
        return null;
    }

    @Override
    public void notifyNewDeletionVector(String dataFile, DeletionVector deletionVector) {
        DeletionVectorsIndexFile deletionVectorsIndexFile = this.indexFileHandler.deletionVectorsIndex();
        DeletionFile previous = this.notifyRemovedDeletionVector(dataFile);
        if (previous != null) {
            deletionVector.merge(deletionVectorsIndexFile.readDeletionVector(previous));
        }
        this.maintainer.notifyNewDeletion(dataFile, deletionVector);
    }

    @Override
    public List<IndexManifestEntry> persist() {
        List<IndexManifestEntry> result = this.writeUnchangedDeletionVector();
        List newIndexFileEntries = this.maintainer.writeDeletionVectorsIndex().stream().map(fileMeta -> new IndexManifestEntry(FileKind.ADD, this.partition, 0, (IndexFileMeta)fileMeta)).collect(Collectors.toList());
        result.addAll(newIndexFileEntries);
        return result;
    }

    public String getIndexFilePath(String dataFile) {
        DeletionFile deletionFile = this.getDeletionFile(dataFile);
        return deletionFile == null ? null : deletionFile.path();
    }

    @VisibleForTesting
    List<IndexManifestEntry> writeUnchangedDeletionVector() {
        DeletionVectorsIndexFile deletionVectorsIndexFile = this.indexFileHandler.deletionVectorsIndex();
        ArrayList<IndexManifestEntry> newIndexEntries = new ArrayList<IndexManifestEntry>();
        for (String indexFile : this.indexFileToDeletionFiles.keySet()) {
            if (!this.touchedIndexFiles.contains(indexFile)) continue;
            IndexManifestEntry oldEntry = this.indexNameToEntry.get(indexFile);
            Map<String, DeletionFile> dataFileToDeletionFiles = this.indexFileToDeletionFiles.get(indexFile);
            if (!dataFileToDeletionFiles.isEmpty()) {
                List<IndexFileMeta> newIndexFiles = this.indexFileHandler.writeDeletionVectorsIndex(deletionVectorsIndexFile.readDeletionVector(dataFileToDeletionFiles));
                newIndexFiles.forEach(newIndexFile -> newIndexEntries.add(new IndexManifestEntry(FileKind.ADD, oldEntry.partition(), oldEntry.bucket(), (IndexFileMeta)newIndexFile)));
            }
            newIndexEntries.add(oldEntry.toDeleteEntry());
        }
        return newIndexEntries;
    }
}

