/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.partition.actions;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.partition.actions.PartitionMarkDoneAction;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SimpleHttpClient;
import org.apache.paimon.utils.StringUtils;

public class HttpReportMarkDoneAction
implements PartitionMarkDoneAction {
    private SimpleHttpClient client;
    private String url;
    private ObjectMapper mapper;
    private String tableName;
    private String location;
    private String params;
    private static final String RESPONSE_SUCCESS = "SUCCESS";
    private static final String THREAD_NAME = "PAIMON-HTTP-REPORT-MARK-DONE-ACTION-THREAD";

    @Override
    public void open(FileStoreTable fileStoreTable, CoreOptions options) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)options.httpReportMarkDoneActionUrl()) ? 1 : 0) != 0, (Object)String.format("Parameter %s must be non-empty when you use `http-report` partition mark done action.", CoreOptions.PARTITION_MARK_DONE_ACTION_URL.key()));
        this.params = options.httpReportMarkDoneActionParams();
        this.url = options.httpReportMarkDoneActionUrl();
        this.tableName = fileStoreTable.fullName();
        this.location = fileStoreTable.location().toString();
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.client = new SimpleHttpClient(THREAD_NAME);
    }

    @Override
    public void markDone(String partition) throws Exception {
        HttpReportMarkDoneResponse response = this.post(new HttpReportMarkDoneRequest(this.params, this.tableName, this.location, partition), Collections.emptyMap());
        Preconditions.checkState((boolean)this.reportIsSuccess(response), (Object)String.format("The http-report action's response attribute `result` should be 'SUCCESS' but is '%s'.", response.getResult()));
    }

    private boolean reportIsSuccess(HttpReportMarkDoneResponse response) {
        return response != null && RESPONSE_SUCCESS.equalsIgnoreCase(response.getResult());
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public HttpReportMarkDoneResponse post(HttpReportMarkDoneRequest body, Map<String, String> headers) throws IOException {
        String responseBodyStr = this.client.post(this.url, this.mapper.writeValueAsBytes((Object)body), headers);
        return (HttpReportMarkDoneResponse)this.mapper.readValue(responseBodyStr, HttpReportMarkDoneResponse.class);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @VisibleForTesting
    public static class HttpReportMarkDoneResponse {
        private static final String RESULT = "result";
        @JsonProperty(value="result")
        private final String result;

        public HttpReportMarkDoneResponse(@JsonProperty(value="result") String result) {
            this.result = result;
        }

        @JsonGetter(value="result")
        public String getResult() {
            return this.result;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @VisibleForTesting
    public static class HttpReportMarkDoneRequest {
        private static final String MARK_DONE_PARTITION = "partition";
        private static final String TABLE = "table";
        private static final String PATH = "path";
        private static final String PARAMS = "params";
        @JsonProperty(value="partition")
        private final String partition;
        @JsonProperty(value="table")
        private final String table;
        @JsonProperty(value="path")
        private final String path;
        @JsonProperty(value="params")
        private final String params;

        @JsonCreator
        public HttpReportMarkDoneRequest(@JsonProperty(value="params") String params, @JsonProperty(value="table") String table, @JsonProperty(value="path") String path, @JsonProperty(value="partition") String partition) {
            this.params = params;
            this.table = table;
            this.path = path;
            this.partition = partition;
        }

        @JsonGetter(value="partition")
        public String getPartition() {
            return this.partition;
        }

        @JsonGetter(value="table")
        public String getTable() {
            return this.table;
        }

        @JsonGetter(value="path")
        public String getPath() {
            return this.path;
        }

        @JsonGetter(value="params")
        public String getParams() {
            return this.params;
        }
    }
}

