/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.gravitino.Entity;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.IllegalNamespaceException;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.JobEntity;
import org.apache.gravitino.storage.relational.mapper.JobMetaMapper;
import org.apache.gravitino.storage.relational.po.JobPO;
import org.apache.gravitino.storage.relational.service.MetalakeMetaService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NamespaceUtil;

public class JobMetaService {
    private static final JobMetaService INSTANCE = new JobMetaService();

    private JobMetaService() {
    }

    public static JobMetaService getInstance() {
        return INSTANCE;
    }

    public List<JobEntity> listJobsByNamespace(Namespace ns) {
        String metalakeName = ns.level(0);
        if (ns.length() == 3) {
            List jobPOs = SessionUtils.getWithoutCommit(JobMetaMapper.class, mapper -> mapper.listJobPOsByMetalake(metalakeName));
            return jobPOs.stream().map(po -> JobPO.fromJobPO(po, ns)).collect(Collectors.toList());
        }
        if (ns.length() == 4) {
            NameIdentifier jobTemplateIdent = NameIdentifier.of((String[])ns.levels());
            String jobTemplateName = jobTemplateIdent.name();
            List jobPOs = SessionUtils.getWithoutCommit(JobMetaMapper.class, mapper -> mapper.listJobPOsByMetalakeAndTemplate(metalakeName, jobTemplateName));
            return jobPOs.stream().map(po -> JobPO.fromJobPO(po, NamespaceUtil.ofJob(metalakeName))).collect(Collectors.toList());
        }
        throw new IllegalNamespaceException("Invalid namespace for listing jobs: %s", new Object[]{ns});
    }

    public JobEntity getJobByIdentifier(NameIdentifier ident) {
        long jobRunIdLong;
        String metalakeName = ident.namespace().level(0);
        String jobRunId = ident.name();
        try {
            jobRunIdLong = Long.parseLong(jobRunId.substring("job-".length()));
        }
        catch (NumberFormatException e) {
            throw new NoSuchEntityException("Invalid job run ID format %s", new Object[]{jobRunId});
        }
        JobPO jobPO = SessionUtils.getWithoutCommit(JobMetaMapper.class, mapper -> mapper.selectJobPOByMetalakeAndRunId(metalakeName, jobRunIdLong));
        if (jobPO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.JOB.name().toLowerCase(Locale.ROOT), jobRunId});
        }
        return JobPO.fromJobPO(jobPO, ident.namespace());
    }

    public void insertJob(JobEntity jobEntity, boolean overwrite) throws IOException {
        String metalakeName = jobEntity.namespace().level(0);
        try {
            Long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(metalakeName);
            JobPO.JobPOBuilder builder = JobPO.builder().withMetalakeId(metalakeId);
            JobPO jobPO = JobPO.initializeJobPO(jobEntity, builder);
            SessionUtils.doWithCommit(JobMetaMapper.class, mapper -> {
                if (overwrite) {
                    mapper.insertJobMetaOnDuplicateKeyUpdate(jobPO);
                } else {
                    mapper.insertJobMeta(jobPO);
                }
            });
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.JOB, jobEntity.id().toString());
        }
    }

    public boolean deleteJob(NameIdentifier jobIdent) {
        long jobRunIdLong;
        String jobRunId = jobIdent.name();
        try {
            jobRunIdLong = Long.parseLong(jobRunId.substring("job-".length()));
        }
        catch (NumberFormatException e) {
            throw new NoSuchEntityException("Invalid job run ID format %s", new Object[]{jobRunId});
        }
        int result = SessionUtils.doWithCommitAndFetchResult(JobMetaMapper.class, mapper -> mapper.softDeleteJobMetaByRunId(jobRunIdLong));
        return result > 0;
    }

    public int deleteJobsByLegacyTimeline(long legacyTimeline, int limit) {
        SessionUtils.doWithCommit(JobMetaMapper.class, mapper -> mapper.softDeleteJobMetasByLegacyTimeline(legacyTimeline));
        return SessionUtils.doWithCommitAndFetchResult(JobMetaMapper.class, mapper -> mapper.deleteJobMetasByLegacyTimeline(legacyTimeline, limit));
    }
}

