/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class RolePO {
    private Long roleId;
    private String roleName;
    private Long metalakeId;
    private String properties;
    private String auditInfo;
    private Long currentVersion;
    private Long lastVersion;
    private Long deletedAt;

    public Long getRoleId() {
        return this.roleId;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public Long getMetalakeId() {
        return this.metalakeId;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getAuditInfo() {
        return this.auditInfo;
    }

    public Long getCurrentVersion() {
        return this.currentVersion;
    }

    public Long getLastVersion() {
        return this.lastVersion;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RolePO)) {
            return false;
        }
        RolePO tablePO = (RolePO)o;
        return Objects.equal((Object)this.getRoleId(), (Object)tablePO.getRoleId()) && Objects.equal((Object)this.getRoleName(), (Object)tablePO.getRoleName()) && Objects.equal((Object)this.getMetalakeId(), (Object)tablePO.getMetalakeId()) && Objects.equal((Object)this.getProperties(), (Object)tablePO.getProperties()) && Objects.equal((Object)this.getAuditInfo(), (Object)tablePO.getAuditInfo()) && Objects.equal((Object)this.getCurrentVersion(), (Object)tablePO.getCurrentVersion()) && Objects.equal((Object)this.getLastVersion(), (Object)tablePO.getLastVersion()) && Objects.equal((Object)this.getDeletedAt(), (Object)tablePO.getDeletedAt());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getRoleId(), this.getRoleName(), this.getMetalakeId(), this.getProperties(), this.getAuditInfo(), this.getCurrentVersion(), this.getLastVersion(), this.getDeletedAt()});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final RolePO rolePO = new RolePO();

        private Builder() {
        }

        public Builder withRoleId(Long roleId) {
            this.rolePO.roleId = roleId;
            return this;
        }

        public Builder withRoleName(String roleName) {
            this.rolePO.roleName = roleName;
            return this;
        }

        public Builder withMetalakeId(Long metalakeId) {
            this.rolePO.metalakeId = metalakeId;
            return this;
        }

        public Builder withProperties(String properties) {
            this.rolePO.properties = properties;
            return this;
        }

        public Builder withAuditInfo(String auditInfo) {
            this.rolePO.auditInfo = auditInfo;
            return this;
        }

        public Builder withCurrentVersion(Long currentVersion) {
            this.rolePO.currentVersion = currentVersion;
            return this;
        }

        public Builder withLastVersion(Long lastVersion) {
            this.rolePO.lastVersion = lastVersion;
            return this;
        }

        public Builder withDeletedAt(Long deletedAt) {
            this.rolePO.deletedAt = deletedAt;
            return this;
        }

        private void validate() {
            Preconditions.checkArgument((this.rolePO.roleId != null ? 1 : 0) != 0, (Object)"Role id is required");
            Preconditions.checkArgument((this.rolePO.roleName != null ? 1 : 0) != 0, (Object)"Role name is required");
            Preconditions.checkArgument((this.rolePO.metalakeId != null ? 1 : 0) != 0, (Object)"Metalake id is required");
            Preconditions.checkArgument((this.rolePO.auditInfo != null ? 1 : 0) != 0, (Object)"Audit info is required");
            Preconditions.checkArgument((this.rolePO.currentVersion != null ? 1 : 0) != 0, (Object)"Current version is required");
            Preconditions.checkArgument((this.rolePO.lastVersion != null ? 1 : 0) != 0, (Object)"Last version is required");
            Preconditions.checkArgument((this.rolePO.deletedAt != null ? 1 : 0) != 0, (Object)"Deleted at is required");
        }

        public RolePO build() {
            this.validate();
            return this.rolePO;
        }
    }
}

