/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.RESTSigV4AuthSession;
import org.apache.iceberg.catalog.SessionCatalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.auth.AuthManager;
import org.apache.iceberg.rest.auth.AuthSession;
import software.amazon.awssdk.auth.signer.Aws4Signer;

public class RESTSigV4AuthManager
implements AuthManager {
    private final Aws4Signer signer = Aws4Signer.create();
    private final AuthManager delegate;
    private Map<String, String> catalogProperties = Map.of();

    public RESTSigV4AuthManager(String ignored, AuthManager delegate) {
        this.delegate = (AuthManager)Preconditions.checkNotNull((Object)delegate, (Object)"Invalid delegate: null");
    }

    public RESTSigV4AuthSession initSession(RESTClient initClient, Map<String, String> properties) {
        return new RESTSigV4AuthSession(this.signer, this.delegate.initSession(initClient, properties), new AwsProperties(properties));
    }

    public RESTSigV4AuthSession catalogSession(RESTClient sharedClient, Map<String, String> properties) {
        this.catalogProperties = properties;
        AwsProperties awsProperties = new AwsProperties(this.catalogProperties);
        return new RESTSigV4AuthSession(this.signer, this.delegate.catalogSession(sharedClient, this.catalogProperties), awsProperties);
    }

    public RESTSigV4AuthSession contextualSession(SessionCatalog.SessionContext context, AuthSession parent) {
        Preconditions.checkState((boolean)(parent instanceof RESTSigV4AuthSession), (String)"Parent session is not SigV4: %s", (Object)parent);
        AwsProperties contextProperties = new AwsProperties(RESTUtil.merge(this.catalogProperties, (Map)RESTUtil.merge((Map)Optional.ofNullable(context.properties()).orElseGet(Map::of), (Map)Optional.ofNullable(context.credentials()).orElseGet(Map::of))));
        RESTSigV4AuthSession sigV4Parent = (RESTSigV4AuthSession)parent;
        return new RESTSigV4AuthSession(this.signer, this.delegate.contextualSession(context, sigV4Parent.delegate()), contextProperties);
    }

    public RESTSigV4AuthSession tableSession(TableIdentifier table, Map<String, String> properties, AuthSession parent) {
        Preconditions.checkState((boolean)(parent instanceof RESTSigV4AuthSession), (String)"Parent session is not SigV4: %s", (Object)parent);
        AwsProperties tableProperties = new AwsProperties(RESTUtil.merge(this.catalogProperties, properties));
        RESTSigV4AuthSession sigV4Parent = (RESTSigV4AuthSession)parent;
        return new RESTSigV4AuthSession(this.signer, this.delegate.tableSession(table, properties, sigV4Parent.delegate()), tableProperties);
    }

    public void close() {
        this.delegate.close();
    }
}

