/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino;

import com.google.common.base.Preconditions;
import org.apache.gravitino.Config;
import org.apache.gravitino.Configs;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.EntityStoreFactory;
import org.apache.gravitino.audit.AuditLogManager;
import org.apache.gravitino.authorization.AccessControlDispatcher;
import org.apache.gravitino.authorization.AccessControlManager;
import org.apache.gravitino.authorization.FutureGrantManager;
import org.apache.gravitino.authorization.GravitinoAuthorizer;
import org.apache.gravitino.authorization.OwnerDispatcher;
import org.apache.gravitino.authorization.OwnerEventManager;
import org.apache.gravitino.authorization.OwnerManager;
import org.apache.gravitino.auxiliary.AuxiliaryServiceManager;
import org.apache.gravitino.catalog.CatalogDispatcher;
import org.apache.gravitino.catalog.CatalogManager;
import org.apache.gravitino.catalog.CatalogNormalizeDispatcher;
import org.apache.gravitino.catalog.FilesetDispatcher;
import org.apache.gravitino.catalog.FilesetNormalizeDispatcher;
import org.apache.gravitino.catalog.FilesetOperationDispatcher;
import org.apache.gravitino.catalog.ModelDispatcher;
import org.apache.gravitino.catalog.ModelNormalizeDispatcher;
import org.apache.gravitino.catalog.ModelOperationDispatcher;
import org.apache.gravitino.catalog.PartitionDispatcher;
import org.apache.gravitino.catalog.PartitionNormalizeDispatcher;
import org.apache.gravitino.catalog.PartitionOperationDispatcher;
import org.apache.gravitino.catalog.SchemaDispatcher;
import org.apache.gravitino.catalog.SchemaNormalizeDispatcher;
import org.apache.gravitino.catalog.SchemaOperationDispatcher;
import org.apache.gravitino.catalog.TableDispatcher;
import org.apache.gravitino.catalog.TableNormalizeDispatcher;
import org.apache.gravitino.catalog.TableOperationDispatcher;
import org.apache.gravitino.catalog.TopicDispatcher;
import org.apache.gravitino.catalog.TopicNormalizeDispatcher;
import org.apache.gravitino.catalog.TopicOperationDispatcher;
import org.apache.gravitino.credential.CredentialOperationDispatcher;
import org.apache.gravitino.hook.AccessControlHookDispatcher;
import org.apache.gravitino.hook.CatalogHookDispatcher;
import org.apache.gravitino.hook.FilesetHookDispatcher;
import org.apache.gravitino.hook.JobHookDispatcher;
import org.apache.gravitino.hook.MetalakeHookDispatcher;
import org.apache.gravitino.hook.ModelHookDispatcher;
import org.apache.gravitino.hook.PolicyHookDispatcher;
import org.apache.gravitino.hook.SchemaHookDispatcher;
import org.apache.gravitino.hook.TableHookDispatcher;
import org.apache.gravitino.hook.TagHookDispatcher;
import org.apache.gravitino.hook.TopicHookDispatcher;
import org.apache.gravitino.job.JobManager;
import org.apache.gravitino.job.JobOperationDispatcher;
import org.apache.gravitino.listener.AccessControlEventDispatcher;
import org.apache.gravitino.listener.CatalogEventDispatcher;
import org.apache.gravitino.listener.EventBus;
import org.apache.gravitino.listener.EventListenerManager;
import org.apache.gravitino.listener.FilesetEventDispatcher;
import org.apache.gravitino.listener.JobEventDispatcher;
import org.apache.gravitino.listener.MetalakeEventDispatcher;
import org.apache.gravitino.listener.ModelEventDispatcher;
import org.apache.gravitino.listener.PartitionEventDispatcher;
import org.apache.gravitino.listener.PolicyEventDispatcher;
import org.apache.gravitino.listener.SchemaEventDispatcher;
import org.apache.gravitino.listener.StatisticEventDispatcher;
import org.apache.gravitino.listener.TableEventDispatcher;
import org.apache.gravitino.listener.TagEventDispatcher;
import org.apache.gravitino.listener.TopicEventDispatcher;
import org.apache.gravitino.lock.LockManager;
import org.apache.gravitino.metalake.MetalakeDispatcher;
import org.apache.gravitino.metalake.MetalakeManager;
import org.apache.gravitino.metalake.MetalakeNormalizeDispatcher;
import org.apache.gravitino.metrics.MetricsSystem;
import org.apache.gravitino.metrics.source.JVMMetricsSource;
import org.apache.gravitino.policy.PolicyDispatcher;
import org.apache.gravitino.policy.PolicyManager;
import org.apache.gravitino.stats.StatisticDispatcher;
import org.apache.gravitino.stats.StatisticManager;
import org.apache.gravitino.storage.IdGenerator;
import org.apache.gravitino.storage.RandomIdGenerator;
import org.apache.gravitino.tag.TagDispatcher;
import org.apache.gravitino.tag.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GravitinoEnv {
    private static final Logger LOG = LoggerFactory.getLogger(GravitinoEnv.class);
    private Config config;
    private boolean manageFullComponents = true;
    private EntityStore entityStore;
    private CatalogDispatcher catalogDispatcher;
    private CatalogManager catalogManager;
    private MetalakeManager metalakeManager;
    private SchemaDispatcher schemaDispatcher;
    private TableDispatcher tableDispatcher;
    private PartitionDispatcher partitionDispatcher;
    private FilesetDispatcher filesetDispatcher;
    private TopicDispatcher topicDispatcher;
    private ModelDispatcher modelDispatcher;
    private MetalakeDispatcher metalakeDispatcher;
    private CredentialOperationDispatcher credentialOperationDispatcher;
    private TagDispatcher tagDispatcher;
    private PolicyDispatcher policyDispatcher;
    private AccessControlDispatcher accessControlDispatcher;
    private IdGenerator idGenerator;
    private AuxiliaryServiceManager auxServiceManager;
    private MetricsSystem metricsSystem;
    private LockManager lockManager;
    private EventListenerManager eventListenerManager;
    private AuditLogManager auditLogManager;
    private JobOperationDispatcher jobOperationDispatcher;
    private EventBus eventBus;
    private OwnerDispatcher ownerDispatcher;
    private FutureGrantManager futureGrantManager;
    private GravitinoAuthorizer gravitinoAuthorizer;
    private StatisticDispatcher statisticDispatcher;

    protected GravitinoEnv() {
    }

    public static GravitinoEnv getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public void initializeBaseComponents(Config config) {
        LOG.info("Initializing Gravitino base environment...");
        this.config = config;
        this.manageFullComponents = false;
        this.initBaseComponents();
        LOG.info("Gravitino base environment is initialized.");
    }

    public void initializeFullComponents(Config config) {
        LOG.info("Initializing Gravitino full environment...");
        this.config = config;
        this.manageFullComponents = true;
        this.initBaseComponents();
        this.initGravitinoServerComponents();
        LOG.info("Gravitino full environment is initialized.");
    }

    public Config config() {
        return this.config;
    }

    public EntityStore entityStore() {
        Preconditions.checkArgument((this.entityStore != null ? 1 : 0) != 0, (Object)"GravitinoEnv is not initialized.");
        return this.entityStore;
    }

    public CatalogDispatcher catalogDispatcher() {
        return this.catalogDispatcher;
    }

    public SchemaDispatcher schemaDispatcher() {
        return this.schemaDispatcher;
    }

    public TableDispatcher tableDispatcher() {
        return this.tableDispatcher;
    }

    public ModelDispatcher modelDispatcher() {
        return this.modelDispatcher;
    }

    public PartitionDispatcher partitionDispatcher() {
        return this.partitionDispatcher;
    }

    public FilesetDispatcher filesetDispatcher() {
        return this.filesetDispatcher;
    }

    public TopicDispatcher topicDispatcher() {
        return this.topicDispatcher;
    }

    public MetalakeDispatcher metalakeDispatcher() {
        return this.metalakeDispatcher;
    }

    public CredentialOperationDispatcher credentialOperationDispatcher() {
        return this.credentialOperationDispatcher;
    }

    public IdGenerator idGenerator() {
        return this.idGenerator;
    }

    public CatalogManager catalogManager() {
        Preconditions.checkArgument((this.catalogManager != null ? 1 : 0) != 0, (Object)"GravitinoEnv is not initialized.");
        return this.catalogManager;
    }

    public EventBus eventBus() {
        Preconditions.checkArgument((this.eventBus != null ? 1 : 0) != 0, (Object)"GravitinoEnv is not initialized.");
        return this.eventBus;
    }

    public MetricsSystem metricsSystem() {
        return this.metricsSystem;
    }

    public LockManager lockManager() {
        return this.lockManager;
    }

    public AccessControlDispatcher accessControlDispatcher() {
        return this.accessControlDispatcher;
    }

    public TagDispatcher tagDispatcher() {
        return this.tagDispatcher;
    }

    public PolicyDispatcher policyDispatcher() {
        return this.policyDispatcher;
    }

    public OwnerDispatcher ownerDispatcher() {
        return this.ownerDispatcher;
    }

    public FutureGrantManager futureGrantManager() {
        return this.futureGrantManager;
    }

    public EventListenerManager eventListenerManager() {
        return this.eventListenerManager;
    }

    public void setGravitinoAuthorizer(GravitinoAuthorizer gravitinoAuthorizer) {
        this.gravitinoAuthorizer = gravitinoAuthorizer;
    }

    public GravitinoAuthorizer gravitinoAuthorizer() {
        return this.gravitinoAuthorizer;
    }

    public JobOperationDispatcher jobOperationDispatcher() {
        Preconditions.checkArgument((this.jobOperationDispatcher != null ? 1 : 0) != 0, (Object)"GravitinoEnv is not initialized.");
        return this.jobOperationDispatcher;
    }

    public StatisticDispatcher statisticDispatcher() {
        return this.statisticDispatcher;
    }

    public void start() {
        this.metricsSystem.start();
        this.eventListenerManager.start();
        if (this.manageFullComponents) {
            this.auxServiceManager.serviceStart();
        }
    }

    public void shutdown() {
        LOG.info("Shutting down Gravitino Environment...");
        if (this.entityStore != null) {
            try {
                this.entityStore.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close EntityStore.", (Throwable)e);
            }
        }
        if (this.catalogManager != null) {
            this.catalogManager.close();
        }
        if (this.auxServiceManager != null) {
            try {
                this.auxServiceManager.serviceStop();
            }
            catch (Exception e) {
                LOG.warn("Failed to stop AuxServiceManager", (Throwable)e);
            }
        }
        if (this.metricsSystem != null) {
            this.metricsSystem.close();
        }
        if (this.eventListenerManager != null) {
            this.eventListenerManager.stop();
        }
        if (this.metalakeManager != null) {
            this.metalakeManager.close();
        }
        if (this.jobOperationDispatcher != null) {
            try {
                this.jobOperationDispatcher.close();
                this.jobOperationDispatcher = null;
            }
            catch (Exception e) {
                LOG.warn("Failed to close JobOperationDispatcher", (Throwable)e);
            }
        }
        if (this.statisticDispatcher != null) {
            try {
                this.statisticDispatcher.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close StatisticDispatcher", (Throwable)e);
            }
        }
        LOG.info("Gravitino Environment is shut down.");
    }

    private void initBaseComponents() {
        this.metricsSystem = new MetricsSystem();
        this.metricsSystem.register(new JVMMetricsSource());
        this.eventListenerManager = new EventListenerManager();
        this.eventListenerManager.init(this.config.getConfigsWithPrefix("gravitino.eventListener."));
        this.eventBus = this.eventListenerManager.createEventBus();
        this.auditLogManager = new AuditLogManager();
        this.auditLogManager.init(this.config, this.eventListenerManager);
    }

    private void initGravitinoServerComponents() {
        this.entityStore = EntityStoreFactory.createEntityStore(this.config);
        this.entityStore.initialize(this.config);
        this.idGenerator = new RandomIdGenerator();
        this.lockManager = new LockManager(this.config);
        this.metalakeManager = new MetalakeManager(this.entityStore, this.idGenerator);
        MetalakeHookDispatcher metalakeHookDispatcher = new MetalakeHookDispatcher(this.metalakeManager);
        MetalakeNormalizeDispatcher metalakeNormalizeDispatcher = new MetalakeNormalizeDispatcher(metalakeHookDispatcher);
        this.metalakeDispatcher = new MetalakeEventDispatcher(this.eventBus, metalakeNormalizeDispatcher);
        this.catalogManager = new CatalogManager(this.config, this.entityStore, this.idGenerator);
        CatalogHookDispatcher catalogHookDispatcher = new CatalogHookDispatcher(this.catalogManager);
        CatalogNormalizeDispatcher catalogNormalizeDispatcher = new CatalogNormalizeDispatcher(catalogHookDispatcher);
        this.catalogDispatcher = new CatalogEventDispatcher(this.eventBus, catalogNormalizeDispatcher);
        this.credentialOperationDispatcher = new CredentialOperationDispatcher(this.catalogManager, this.entityStore, this.idGenerator);
        SchemaOperationDispatcher schemaOperationDispatcher = new SchemaOperationDispatcher(this.catalogManager, this.entityStore, this.idGenerator);
        SchemaHookDispatcher schemaHookDispatcher = new SchemaHookDispatcher(schemaOperationDispatcher);
        SchemaNormalizeDispatcher schemaNormalizeDispatcher = new SchemaNormalizeDispatcher(schemaHookDispatcher, this.catalogManager);
        this.schemaDispatcher = new SchemaEventDispatcher(this.eventBus, schemaNormalizeDispatcher);
        TableOperationDispatcher tableOperationDispatcher = new TableOperationDispatcher(this.catalogManager, this.entityStore, this.idGenerator);
        TableHookDispatcher tableHookDispatcher = new TableHookDispatcher(tableOperationDispatcher);
        TableNormalizeDispatcher tableNormalizeDispatcher = new TableNormalizeDispatcher(tableHookDispatcher, this.catalogManager);
        this.tableDispatcher = new TableEventDispatcher(this.eventBus, tableNormalizeDispatcher);
        PartitionOperationDispatcher partitionOperationDispatcher = new PartitionOperationDispatcher(this.catalogManager, this.entityStore, this.idGenerator);
        PartitionNormalizeDispatcher partitionNormalizeDispatcher = new PartitionNormalizeDispatcher(partitionOperationDispatcher, this.catalogManager);
        this.partitionDispatcher = new PartitionEventDispatcher(this.eventBus, partitionNormalizeDispatcher);
        FilesetOperationDispatcher filesetOperationDispatcher = new FilesetOperationDispatcher(this.catalogManager, this.entityStore, this.idGenerator);
        FilesetHookDispatcher filesetHookDispatcher = new FilesetHookDispatcher(filesetOperationDispatcher);
        FilesetNormalizeDispatcher filesetNormalizeDispatcher = new FilesetNormalizeDispatcher(filesetHookDispatcher, this.catalogManager);
        this.filesetDispatcher = new FilesetEventDispatcher(this.eventBus, filesetNormalizeDispatcher);
        TopicOperationDispatcher topicOperationDispatcher = new TopicOperationDispatcher(this.catalogManager, this.entityStore, this.idGenerator);
        TopicHookDispatcher topicHookDispatcher = new TopicHookDispatcher(topicOperationDispatcher);
        TopicNormalizeDispatcher topicNormalizeDispatcher = new TopicNormalizeDispatcher(topicHookDispatcher, this.catalogManager);
        this.topicDispatcher = new TopicEventDispatcher(this.eventBus, topicNormalizeDispatcher);
        ModelOperationDispatcher modelOperationDispatcher = new ModelOperationDispatcher(this.catalogManager, this.entityStore, this.idGenerator);
        ModelHookDispatcher modelHookDispatcher = new ModelHookDispatcher(modelOperationDispatcher);
        ModelNormalizeDispatcher modelNormalizeDispatcher = new ModelNormalizeDispatcher(modelHookDispatcher, this.catalogManager);
        this.modelDispatcher = new ModelEventDispatcher(this.eventBus, modelNormalizeDispatcher);
        this.statisticDispatcher = new StatisticEventDispatcher(this.eventBus, new StatisticManager(this.entityStore, this.idGenerator, this.config));
        boolean enableAuthorization = (Boolean)this.config.get(Configs.ENABLE_AUTHORIZATION);
        if (enableAuthorization) {
            AccessControlManager accessControlManager = new AccessControlManager(this.entityStore, this.idGenerator, this.config);
            AccessControlHookDispatcher accessControlHookDispatcher = new AccessControlHookDispatcher(accessControlManager);
            this.accessControlDispatcher = new AccessControlEventDispatcher(this.eventBus, accessControlHookDispatcher);
            OwnerManager ownerManager = new OwnerManager(this.entityStore);
            this.ownerDispatcher = new OwnerEventManager(this.eventBus, ownerManager);
            this.futureGrantManager = new FutureGrantManager(this.entityStore, ownerManager);
        } else {
            this.accessControlDispatcher = null;
            this.ownerDispatcher = null;
            this.futureGrantManager = null;
        }
        this.auxServiceManager = new AuxiliaryServiceManager();
        this.auxServiceManager.serviceInit(this.config);
        TagManager tagManager = new TagManager(this.idGenerator, this.entityStore);
        TagHookDispatcher tagHookDispatcher = new TagHookDispatcher(tagManager);
        this.tagDispatcher = new TagEventDispatcher(this.eventBus, tagHookDispatcher);
        PolicyEventDispatcher policyEventDispatcher = new PolicyEventDispatcher(this.eventBus, new PolicyManager(this.idGenerator, this.entityStore));
        this.policyDispatcher = new PolicyHookDispatcher(policyEventDispatcher);
        this.jobOperationDispatcher = new JobEventDispatcher(this.eventBus, new JobHookDispatcher(new JobManager(this.config, this.entityStore, this.idGenerator)));
    }

    private static class InstanceHolder {
        private static final GravitinoEnv INSTANCE = new GravitinoEnv();

        private InstanceHolder() {
        }
    }
}

