/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.gravitino.catalog.lakehouse.iceberg.IcebergPropertiesUtils;
import org.apache.gravitino.iceberg.service.metrics.IcebergMetricsStore;
import org.apache.gravitino.json.JsonUtils;
import org.apache.gravitino.utils.MapUtils;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.jdbc.JdbcClientPool;
import org.apache.iceberg.jdbc.UncheckedInterruptedException;
import org.apache.iceberg.jdbc.UncheckedSQLException;
import org.apache.iceberg.metrics.CommitReport;
import org.apache.iceberg.metrics.CounterResult;
import org.apache.iceberg.metrics.MetricsReport;
import org.apache.iceberg.metrics.ScanReport;
import org.apache.iceberg.metrics.TimerResult;

public class JDBCMetricsStore
implements IcebergMetricsStore {
    public static final String ICEBERG_METRICS_STORE_JDBC_NAME = "jdbc";
    private static final String URI = "uri";
    private static final String INSERT_COMMIT_REPORT_METRICS_SQL = "INSERT INTO commit_metrics_report (timestamp, namespace, table_name, snapshot_id, sequence_number, operation,added_data_files, removed_data_files, total_data_files,added_delete_files, added_equality_delete_files,  added_positional_delete_files, removed_delete_files, removed_equality_delete_files, removed_positional_delete_files, total_delete_files,added_records, removed_records, total_records,added_files_size_in_bytes, removed_files_size_in_bytes, total_files_size_in_bytes,added_positional_deletes, removed_positional_deletes, total_positional_deletes,added_equality_deletes, removed_equality_deletes, total_equality_deletes,manifests_created, manifests_replaced, manifests_kept, manifest_entries_processed,added_dvs, removed_dvs,total_duration_ms, attempts, metadata) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
    private static final String INSERT_SCAN_REPORT_METRICS_SQL = "INSERT INTO scan_metrics_report (timestamp, namespace, table_name, snapshot_id, schema_id, filter, metadata, projected_field_ids, projected_field_names, equality_delete_files, indexed_delete_files, positional_delete_files, result_data_files, result_delete_files, scanned_data_manifests, scanned_delete_manifests, skipped_data_files, skipped_data_manifests, skipped_delete_files, skipped_delete_manifests, total_data_manifests, total_delete_file_size_in_bytes, total_delete_manifests, total_file_size_in_bytes,total_planning_duration) VALUES (?, ?, ?, ?, ?,?, ?, ?, ?,?, ? ,?,?, ?,?, ?,?, ?,?, ?,?, ?,?, ?,?);";
    private static final String DELETE_EXPIRED_SCAN_METRICS_SQL = "DELETE FROM scan_metrics_report WHERE timestamp < ?; ";
    private static final String DELETE_EXPIRED_COMMIT_METRICS_SQL = "DELETE FROM commit_metrics_report WHERE timestamp < ?;";
    @VisibleForTesting
    JdbcClientPool connections;

    @Override
    public void init(Map<String, String> properties) throws IOException {
        this.initProperties(properties);
        this.checkMetricsReportTableExists();
    }

    private void checkMetricsReportTableExists() {
        try {
            Preconditions.checkArgument((boolean)((Boolean)this.connections.run(conn -> {
                DatabaseMetaData dbMeta = conn.getMetaData();
                ResultSet commitReportTableExists = dbMeta.getTables(null, null, "commit_metrics_report", null);
                ResultSet scanReportTableExists = dbMeta.getTables(null, null, "scan_metrics_report", null);
                return commitReportTableExists.next() && scanReportTableExists.next();
            })), (Object)"JDBC metrics store tables do not exist. You should use the sql scripts under directory `scripts` to initialize the database");
        }
        catch (InterruptedException | SQLException exception) {
            throw new RuntimeException(exception);
        }
    }

    @VisibleForTesting
    void initProperties(Map<String, String> properties) {
        Map actualProps = MapUtils.getPrefixMap(properties, (String)"jdbc-metrics.");
        String uri = (String)actualProps.get(URI);
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (String)"JDBC metrics store requires a \"%s\" property", (Object)URI);
        this.connections = new JdbcClientPool(uri, IcebergPropertiesUtils.toIcebergCatalogProperties((Map)actualProps));
    }

    @Override
    public void recordMetric(String catalog, Namespace namespace, MetricsReport metricsReport) throws IOException {
        if (metricsReport instanceof CommitReport) {
            CommitReport commitReport = (CommitReport)metricsReport;
            this.execute(INSERT_COMMIT_REPORT_METRICS_SQL, Instant.now().toEpochMilli(), String.format("%s.%s", catalog, namespace.toString()), commitReport.tableName(), commitReport.snapshotId(), commitReport.sequenceNumber(), commitReport.operation(), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().addedDataFiles()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().removedDataFiles()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().totalDataFiles()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().addedDeleteFiles()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().addedEqualityDeleteFiles()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().addedPositionalDeleteFiles()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().removedDeleteFiles()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().removedEqualityDeleteFiles()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().removedPositionalDeleteFiles()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().totalDeleteFiles()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().addedRecords()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().removedRecords()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().totalRecords()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().addedFilesSizeInBytes()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().removedFilesSizeInBytes()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().totalFilesSizeInBytes()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().addedPositionalDeletes()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().removedPositionalDeletes()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().totalPositionalDeletes()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().addedEqualityDeleteFiles()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().removedEqualityDeleteFiles()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().totalEqualityDeletes()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().manifestsCreated()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().manifestsReplaced()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().manifestsKept()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().manifestEntriesProcessed()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().addedDVs()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().removedDVs()), JDBCMetricsStore.getTimerResult(commitReport.commitMetrics().totalDuration()), JDBCMetricsStore.getCounterResult(commitReport.commitMetrics().attempts()), JsonUtils.objectMapper().writeValueAsString((Object)commitReport.metadata()));
        } else if (metricsReport instanceof ScanReport) {
            ScanReport scanReport = (ScanReport)metricsReport;
            this.execute(INSERT_SCAN_REPORT_METRICS_SQL, Instant.now().toEpochMilli(), String.format("%s.%s", catalog, namespace.toString()), scanReport.tableName(), scanReport.snapshotId(), scanReport.schemaId(), scanReport.filter().toString(), JsonUtils.objectMapper().writeValueAsString((Object)scanReport.metadata()), JsonUtils.objectMapper().writeValueAsString((Object)scanReport.projectedFieldIds()), JsonUtils.objectMapper().writeValueAsString((Object)scanReport.projectedFieldNames().toString()), JDBCMetricsStore.getCounterResult(scanReport.scanMetrics().equalityDeleteFiles()), JDBCMetricsStore.getCounterResult(scanReport.scanMetrics().indexedDeleteFiles()), JDBCMetricsStore.getCounterResult(scanReport.scanMetrics().positionalDeleteFiles()), JDBCMetricsStore.getCounterResult(scanReport.scanMetrics().resultDataFiles()), JDBCMetricsStore.getCounterResult(scanReport.scanMetrics().resultDeleteFiles()), JDBCMetricsStore.getCounterResult(scanReport.scanMetrics().scannedDataManifests()), JDBCMetricsStore.getCounterResult(scanReport.scanMetrics().scannedDeleteManifests()), JDBCMetricsStore.getCounterResult(scanReport.scanMetrics().skippedDataFiles()), JDBCMetricsStore.getCounterResult(scanReport.scanMetrics().skippedDataManifests()), JDBCMetricsStore.getCounterResult(scanReport.scanMetrics().skippedDeleteFiles()), JDBCMetricsStore.getCounterResult(scanReport.scanMetrics().skippedDeleteManifests()), JDBCMetricsStore.getCounterResult(scanReport.scanMetrics().totalDataManifests()), JDBCMetricsStore.getCounterResult(scanReport.scanMetrics().totalDeleteFileSizeInBytes()), JDBCMetricsStore.getCounterResult(scanReport.scanMetrics().totalDeleteManifests()), JDBCMetricsStore.getCounterResult(scanReport.scanMetrics().totalFileSizeInBytes()), JDBCMetricsStore.getTimerResult(scanReport.scanMetrics().totalPlanningDuration()));
        }
    }

    @Override
    public void clean(Instant expireTime) throws IOException {
        this.execute(DELETE_EXPIRED_SCAN_METRICS_SQL, expireTime.toEpochMilli());
        this.execute(DELETE_EXPIRED_COMMIT_METRICS_SQL, expireTime.toEpochMilli());
    }

    @Override
    public void close() throws IOException {
        if (this.connections != null) {
            this.connections.close();
        }
    }

    @VisibleForTesting
    static long getCounterResult(CounterResult result) {
        return result != null ? result.value() : 0L;
    }

    @VisibleForTesting
    static long getTimerResult(TimerResult result) {
        return result != null ? result.count() : 0L;
    }

    @VisibleForTesting
    int execute(String sql, Object ... args) {
        return this.execute((SQLException err) -> {}, sql, args);
    }

    private int execute(Consumer<SQLException> sqlErrorHandler, String sql, Object ... args) {
        try {
            return (Integer)this.connections.run(conn -> {
                try (PreparedStatement preparedStatement = conn.prepareStatement(sql);){
                    for (int pos = 0; pos < args.length; ++pos) {
                        if (args[pos] instanceof Long) {
                            preparedStatement.setLong(pos + 1, (Long)args[pos]);
                            continue;
                        }
                        if (args[pos] instanceof String) {
                            preparedStatement.setString(pos + 1, (String)args[pos]);
                            continue;
                        }
                        if (args[pos] instanceof Integer) {
                            preparedStatement.setInt(pos + 1, (Integer)args[pos]);
                            continue;
                        }
                        throw new IllegalArgumentException("Unsupported argument type: " + String.valueOf(args[pos].getClass()));
                    }
                    Integer n = preparedStatement.executeUpdate();
                    return n;
                }
            });
        }
        catch (SQLException e) {
            sqlErrorHandler.accept(e);
            throw new UncheckedSQLException((Throwable)e, "Failed to execute: %s", new Object[]{sql});
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException((Throwable)e, "Interrupted in SQL command", new Object[0]);
        }
    }
}

