/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.reader;

import java.io.IOException;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;

public class PackChangelogReader
implements RecordReader<InternalRow> {
    private final RecordReader<InternalRow> reader;
    private final BiFunction<InternalRow, InternalRow, InternalRow> function;
    private final InternalRowSerializer serializer;
    private boolean initialized = false;

    public PackChangelogReader(RecordReader<InternalRow> reader, BiFunction<InternalRow, InternalRow, InternalRow> function, RowType rowType) {
        this.reader = reader;
        this.function = function;
        this.serializer = new InternalRowSerializer(rowType);
    }

    @Override
    @Nullable
    public RecordReader.RecordIterator<InternalRow> readBatch() throws IOException {
        if (!this.initialized) {
            this.initialized = true;
            return new InternRecordIterator(this.reader, this.function, this.serializer);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private static class InternRecordIterator
    implements RecordReader.RecordIterator<InternalRow> {
        private RecordReader.RecordIterator<InternalRow> currentBatch;
        private final BiFunction<InternalRow, InternalRow, InternalRow> function;
        private final RecordReader<InternalRow> reader;
        private final InternalRowSerializer serializer;
        private boolean endOfData;

        public InternRecordIterator(RecordReader<InternalRow> reader, BiFunction<InternalRow, InternalRow, InternalRow> function, InternalRowSerializer serializer) {
            this.reader = reader;
            this.function = function;
            this.serializer = serializer;
            this.endOfData = false;
        }

        @Override
        @Nullable
        public InternalRow next() throws IOException {
            InternalRow row1 = this.nextRow();
            if (row1 == null) {
                return null;
            }
            InternalRow row2 = null;
            if (row1.getRowKind() == RowKind.UPDATE_BEFORE) {
                row1 = this.serializer.copy(row1);
                row2 = this.nextRow();
            }
            return this.function.apply(row1, row2);
        }

        @Nullable
        private InternalRow nextRow() throws IOException {
            InternalRow row = null;
            while (!this.endOfData && row == null) {
                RecordReader.RecordIterator<InternalRow> batch = this.nextBatch();
                if (batch == null) {
                    this.endOfData = true;
                    return null;
                }
                row = batch.next();
                if (row != null) continue;
                this.releaseBatch();
            }
            return row;
        }

        @Nullable
        private RecordReader.RecordIterator<InternalRow> nextBatch() throws IOException {
            if (this.currentBatch == null) {
                this.currentBatch = this.reader.readBatch();
            }
            return this.currentBatch;
        }

        @Override
        public void releaseBatch() {
            if (this.currentBatch != null) {
                this.currentBatch.releaseBatch();
                this.currentBatch = null;
            }
        }
    }
}

