/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.CatalogChange;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.SupportsCatalogs;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.SupportsRoles;
import org.apache.gravitino.authorization.User;
import org.apache.gravitino.client.DTOConverters;
import org.apache.gravitino.client.ErrorHandlers;
import org.apache.gravitino.client.GenericJobHandle;
import org.apache.gravitino.client.GenericPolicy;
import org.apache.gravitino.client.GenericTag;
import org.apache.gravitino.client.MetadataObjectRoleOperations;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.dto.MetalakeDTO;
import org.apache.gravitino.dto.authorization.SecurableObjectDTO;
import org.apache.gravitino.dto.policy.PolicyDTO;
import org.apache.gravitino.dto.requests.CatalogCreateRequest;
import org.apache.gravitino.dto.requests.CatalogSetRequest;
import org.apache.gravitino.dto.requests.CatalogUpdateRequest;
import org.apache.gravitino.dto.requests.CatalogUpdatesRequest;
import org.apache.gravitino.dto.requests.GroupAddRequest;
import org.apache.gravitino.dto.requests.JobRunRequest;
import org.apache.gravitino.dto.requests.JobTemplateRegisterRequest;
import org.apache.gravitino.dto.requests.JobTemplateUpdateRequest;
import org.apache.gravitino.dto.requests.JobTemplateUpdatesRequest;
import org.apache.gravitino.dto.requests.OwnerSetRequest;
import org.apache.gravitino.dto.requests.PolicyCreateRequest;
import org.apache.gravitino.dto.requests.PolicySetRequest;
import org.apache.gravitino.dto.requests.PolicyUpdateRequest;
import org.apache.gravitino.dto.requests.PolicyUpdatesRequest;
import org.apache.gravitino.dto.requests.PrivilegeGrantRequest;
import org.apache.gravitino.dto.requests.PrivilegeRevokeRequest;
import org.apache.gravitino.dto.requests.RoleCreateRequest;
import org.apache.gravitino.dto.requests.RoleGrantRequest;
import org.apache.gravitino.dto.requests.RoleRevokeRequest;
import org.apache.gravitino.dto.requests.TagCreateRequest;
import org.apache.gravitino.dto.requests.TagUpdateRequest;
import org.apache.gravitino.dto.requests.TagUpdatesRequest;
import org.apache.gravitino.dto.requests.UserAddRequest;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.dto.responses.CatalogListResponse;
import org.apache.gravitino.dto.responses.CatalogResponse;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.EntityListResponse;
import org.apache.gravitino.dto.responses.ErrorResponse;
import org.apache.gravitino.dto.responses.GroupListResponse;
import org.apache.gravitino.dto.responses.GroupResponse;
import org.apache.gravitino.dto.responses.JobListResponse;
import org.apache.gravitino.dto.responses.JobResponse;
import org.apache.gravitino.dto.responses.JobTemplateListResponse;
import org.apache.gravitino.dto.responses.JobTemplateResponse;
import org.apache.gravitino.dto.responses.NameListResponse;
import org.apache.gravitino.dto.responses.OwnerResponse;
import org.apache.gravitino.dto.responses.PolicyListResponse;
import org.apache.gravitino.dto.responses.PolicyResponse;
import org.apache.gravitino.dto.responses.RemoveResponse;
import org.apache.gravitino.dto.responses.RoleResponse;
import org.apache.gravitino.dto.responses.SetResponse;
import org.apache.gravitino.dto.responses.TagListResponse;
import org.apache.gravitino.dto.responses.TagResponse;
import org.apache.gravitino.dto.responses.UserListResponse;
import org.apache.gravitino.dto.responses.UserResponse;
import org.apache.gravitino.dto.tag.TagDTO;
import org.apache.gravitino.exceptions.CatalogAlreadyExistsException;
import org.apache.gravitino.exceptions.CatalogInUseException;
import org.apache.gravitino.exceptions.GroupAlreadyExistsException;
import org.apache.gravitino.exceptions.IllegalMetadataObjectException;
import org.apache.gravitino.exceptions.IllegalPrivilegeException;
import org.apache.gravitino.exceptions.IllegalRoleException;
import org.apache.gravitino.exceptions.InUseException;
import org.apache.gravitino.exceptions.JobTemplateAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchGroupException;
import org.apache.gravitino.exceptions.NoSuchJobException;
import org.apache.gravitino.exceptions.NoSuchJobTemplateException;
import org.apache.gravitino.exceptions.NoSuchMetadataObjectException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchPolicyException;
import org.apache.gravitino.exceptions.NoSuchRoleException;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.exceptions.NoSuchUserException;
import org.apache.gravitino.exceptions.NonEmptyEntityException;
import org.apache.gravitino.exceptions.NotFoundException;
import org.apache.gravitino.exceptions.PolicyAlreadyExistsException;
import org.apache.gravitino.exceptions.RoleAlreadyExistsException;
import org.apache.gravitino.exceptions.TagAlreadyExistsException;
import org.apache.gravitino.exceptions.UserAlreadyExistsException;
import org.apache.gravitino.job.JobHandle;
import org.apache.gravitino.job.JobTemplate;
import org.apache.gravitino.job.JobTemplateChange;
import org.apache.gravitino.job.SupportsJobs;
import org.apache.gravitino.policy.Policy;
import org.apache.gravitino.policy.PolicyChange;
import org.apache.gravitino.policy.PolicyContent;
import org.apache.gravitino.policy.PolicyOperations;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.rest.RESTUtils;
import org.apache.gravitino.tag.Tag;
import org.apache.gravitino.tag.TagChange;
import org.apache.gravitino.tag.TagOperations;

public class GravitinoMetalake
extends MetalakeDTO
implements SupportsCatalogs,
TagOperations,
SupportsRoles,
SupportsJobs,
PolicyOperations {
    private static final String API_METALAKES_CATALOGS_PATH = "api/metalakes/%s/catalogs/%s";
    private static final String API_PERMISSION_PATH = "api/metalakes/%s/permissions/%s";
    private static final String API_METALAKES_USERS_PATH = "api/metalakes/%s/users/%s";
    private static final String API_METALAKES_GROUPS_PATH = "api/metalakes/%s/groups/%s";
    private static final String API_METALAKES_ROLES_PATH = "api/metalakes/%s/roles/%s";
    private static final String API_METALAKES_OWNERS_PATH = "api/metalakes/%s/owners/%s";
    private static final String API_METALAKES_TAGS_PATH = "api/metalakes/%s/tags";
    private static final String API_METALAKES_JOB_TEMPLATES_PATH = "api/metalakes/%s/jobs/templates";
    private static final String API_METALAKES_JOB_PATH = "api/metalakes/%s/jobs/runs";
    private static final String API_METALAKES_POLICIES_PATH = "api/metalakes/%s/policies";
    private static final String BLANK_PLACEHOLDER = "";
    private final RESTClient restClient;
    private final MetadataObjectRoleOperations metadataObjectRoleOperations;

    GravitinoMetalake(String name, String comment, Map<String, String> properties, AuditDTO auditDTO, RESTClient restClient) {
        super(name, comment, properties, auditDTO);
        this.restClient = restClient;
        this.metadataObjectRoleOperations = new MetadataObjectRoleOperations(name, MetadataObjects.of(null, name, MetadataObject.Type.METALAKE), restClient);
    }

    @Override
    public String[] listCatalogs() throws NoSuchMetalakeException {
        EntityListResponse resp = this.restClient.get(String.format("api/metalakes/%s/catalogs", RESTUtils.encodeString(this.name())), EntityListResponse.class, Collections.emptyMap(), ErrorHandlers.catalogErrorHandler());
        resp.validate();
        return (String[])Arrays.stream(resp.identifiers()).map(NameIdentifier::name).toArray(String[]::new);
    }

    @Override
    public Catalog[] listCatalogsInfo() throws NoSuchMetalakeException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("details", "true");
        CatalogListResponse resp = this.restClient.get(String.format("api/metalakes/%s/catalogs", RESTUtils.encodeString(this.name())), params, CatalogListResponse.class, Collections.emptyMap(), ErrorHandlers.catalogErrorHandler());
        return (Catalog[])Arrays.stream(resp.getCatalogs()).map(c -> DTOConverters.toCatalog(this.name(), c, this.restClient)).toArray(Catalog[]::new);
    }

    @Override
    public Catalog loadCatalog(String catalogName) throws NoSuchCatalogException {
        CatalogResponse resp = this.restClient.get(String.format(API_METALAKES_CATALOGS_PATH, RESTUtils.encodeString(this.name()), RESTUtils.encodeString(catalogName)), CatalogResponse.class, Collections.emptyMap(), ErrorHandlers.catalogErrorHandler());
        resp.validate();
        return DTOConverters.toCatalog(this.name(), resp.getCatalog(), this.restClient);
    }

    @Override
    public Catalog createCatalog(String catalogName, Catalog.Type type, String provider, String comment, Map<String, String> properties) throws NoSuchMetalakeException, CatalogAlreadyExistsException {
        CatalogCreateRequest req = new CatalogCreateRequest(catalogName, type, provider, comment, properties);
        req.validate();
        CatalogResponse resp = this.restClient.post(String.format("api/metalakes/%s/catalogs", RESTUtils.encodeString(this.name())), (RESTRequest)req, CatalogResponse.class, Collections.emptyMap(), ErrorHandlers.catalogErrorHandler());
        resp.validate();
        return DTOConverters.toCatalog(this.name(), resp.getCatalog(), this.restClient);
    }

    @Override
    public Catalog alterCatalog(String catalogName, CatalogChange ... changes) throws NoSuchCatalogException, IllegalArgumentException {
        List<CatalogUpdateRequest> reqs = Arrays.stream(changes).map(DTOConverters::toCatalogUpdateRequest).collect(Collectors.toList());
        CatalogUpdatesRequest updatesRequest = new CatalogUpdatesRequest(reqs);
        updatesRequest.validate();
        CatalogResponse resp = this.restClient.put(String.format(API_METALAKES_CATALOGS_PATH, RESTUtils.encodeString(this.name()), RESTUtils.encodeString(catalogName)), (RESTRequest)updatesRequest, CatalogResponse.class, Collections.emptyMap(), ErrorHandlers.catalogErrorHandler());
        resp.validate();
        return DTOConverters.toCatalog(this.name(), resp.getCatalog(), this.restClient);
    }

    @Override
    public boolean dropCatalog(String catalogName, boolean force) throws NonEmptyEntityException, CatalogInUseException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("force", String.valueOf(force));
        DropResponse resp = this.restClient.delete(String.format(API_METALAKES_CATALOGS_PATH, RESTUtils.encodeString(this.name()), RESTUtils.encodeString(catalogName)), params, DropResponse.class, Collections.emptyMap(), ErrorHandlers.catalogErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    @Override
    public void enableCatalog(String catalogName) throws NoSuchCatalogException {
        CatalogSetRequest req = new CatalogSetRequest(true);
        ErrorResponse resp = this.restClient.patch(String.format(API_METALAKES_CATALOGS_PATH, RESTUtils.encodeString(this.name()), RESTUtils.encodeString(catalogName)), req, ErrorResponse.class, Collections.emptyMap(), ErrorHandlers.catalogErrorHandler());
        if (resp.getCode() == 0) {
            return;
        }
        ErrorHandlers.catalogErrorHandler().accept(resp);
    }

    @Override
    public void disableCatalog(String catalogName) throws NoSuchCatalogException {
        CatalogSetRequest req = new CatalogSetRequest(false);
        ErrorResponse resp = this.restClient.patch(String.format(API_METALAKES_CATALOGS_PATH, RESTUtils.encodeString(this.name()), RESTUtils.encodeString(catalogName)), req, ErrorResponse.class, Collections.emptyMap(), ErrorHandlers.catalogErrorHandler());
        if (resp.getCode() == 0) {
            return;
        }
        ErrorHandlers.catalogErrorHandler().accept(resp);
    }

    @Override
    public void testConnection(String catalogName, Catalog.Type type, String provider, String comment, Map<String, String> properties) throws Exception {
        CatalogCreateRequest req = new CatalogCreateRequest(catalogName, type, provider, comment, properties);
        req.validate();
        ErrorResponse resp = this.restClient.post(String.format("api/metalakes/%s/catalogs/testConnection", RESTUtils.encodeString(this.name())), (RESTRequest)req, ErrorResponse.class, Collections.emptyMap(), ErrorHandlers.catalogErrorHandler());
        if (resp.getCode() == 0) {
            return;
        }
        ErrorHandlers.catalogErrorHandler().accept(resp);
    }

    @Override
    public SupportsRoles supportsRoles() {
        return this;
    }

    @Override
    public String[] listTags() throws NoSuchMetalakeException {
        NameListResponse resp = this.restClient.get(String.format(API_METALAKES_TAGS_PATH, RESTUtils.encodeString(this.name())), NameListResponse.class, Collections.emptyMap(), ErrorHandlers.tagErrorHandler());
        resp.validate();
        return resp.getNames();
    }

    @Override
    public Tag[] listTagsInfo() throws NoSuchMetalakeException {
        ImmutableMap<String, String> params = ImmutableMap.of("details", "true");
        TagListResponse resp = this.restClient.get(String.format(API_METALAKES_TAGS_PATH, RESTUtils.encodeString(this.name())), params, TagListResponse.class, Collections.emptyMap(), ErrorHandlers.tagErrorHandler());
        resp.validate();
        return (Tag[])Arrays.stream(resp.getTags()).map(t2 -> new GenericTag((TagDTO)t2, this.restClient, this.name())).toArray(Tag[]::new);
    }

    @Override
    public Tag getTag(String name) throws NoSuchTagException {
        Preconditions.checkArgument(StringUtils.isNotBlank(name), "tag name must not be null or empty");
        TagResponse resp = this.restClient.get(String.format(API_METALAKES_TAGS_PATH, RESTUtils.encodeString(this.name())) + "/" + RESTUtils.encodeString(name), TagResponse.class, Collections.emptyMap(), ErrorHandlers.tagErrorHandler());
        resp.validate();
        return new GenericTag(resp.getTag(), this.restClient, this.name());
    }

    @Override
    public Tag createTag(String name, String comment, Map<String, String> properties) throws TagAlreadyExistsException {
        Preconditions.checkArgument(StringUtils.isNotBlank(name), "tag name must not be null or empty");
        TagCreateRequest req = new TagCreateRequest(name, comment, properties);
        req.validate();
        TagResponse resp = this.restClient.post(String.format(API_METALAKES_TAGS_PATH, RESTUtils.encodeString(this.name())), (RESTRequest)req, TagResponse.class, Collections.emptyMap(), ErrorHandlers.tagErrorHandler());
        resp.validate();
        return new GenericTag(resp.getTag(), this.restClient, this.name());
    }

    @Override
    public Tag alterTag(String name, TagChange ... changes) throws NoSuchTagException, IllegalArgumentException {
        Preconditions.checkArgument(StringUtils.isNotBlank(name), "tag name must not be null or empty");
        List<TagUpdateRequest> updates = Arrays.stream(changes).map(DTOConverters::toTagUpdateRequest).collect(Collectors.toList());
        TagUpdatesRequest req = new TagUpdatesRequest(updates);
        req.validate();
        TagResponse resp = this.restClient.put(String.format(API_METALAKES_TAGS_PATH, RESTUtils.encodeString(this.name())) + "/" + RESTUtils.encodeString(name), (RESTRequest)req, TagResponse.class, Collections.emptyMap(), ErrorHandlers.tagErrorHandler());
        resp.validate();
        return new GenericTag(resp.getTag(), this.restClient, this.name());
    }

    @Override
    public boolean deleteTag(String name) {
        Preconditions.checkArgument(StringUtils.isNotBlank(name), "tag name must not be null or empty");
        DropResponse resp = this.restClient.delete(String.format(API_METALAKES_TAGS_PATH, RESTUtils.encodeString(this.name())) + "/" + RESTUtils.encodeString(name), DropResponse.class, Collections.emptyMap(), ErrorHandlers.tagErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    @Override
    public String[] listPolicies() throws NoSuchMetalakeException {
        NameListResponse resp = this.restClient.get(String.format(API_METALAKES_POLICIES_PATH, RESTUtils.encodeString(this.name())), NameListResponse.class, Collections.emptyMap(), ErrorHandlers.policyErrorHandler());
        resp.validate();
        return resp.getNames();
    }

    @Override
    public Policy[] listPolicyInfos() throws NoSuchMetalakeException {
        ImmutableMap<String, String> params = ImmutableMap.of("details", "true");
        PolicyListResponse resp = this.restClient.get(String.format(API_METALAKES_POLICIES_PATH, RESTUtils.encodeString(this.name())), params, PolicyListResponse.class, Collections.emptyMap(), ErrorHandlers.policyErrorHandler());
        resp.validate();
        return (Policy[])Arrays.stream(resp.getPolicies()).map(p -> new GenericPolicy((PolicyDTO)p, this.restClient, this.name())).toArray(Policy[]::new);
    }

    @Override
    public Policy getPolicy(String name) throws NoSuchPolicyException {
        Preconditions.checkArgument(StringUtils.isNotBlank(name), "policy name must not be null or empty");
        PolicyResponse resp = this.restClient.get(String.format(API_METALAKES_POLICIES_PATH, RESTUtils.encodeString(this.name())) + "/" + RESTUtils.encodeString(name), PolicyResponse.class, Collections.emptyMap(), ErrorHandlers.policyErrorHandler());
        resp.validate();
        return new GenericPolicy(resp.getPolicy(), this.restClient, this.name());
    }

    @Override
    public Policy createPolicy(String name, String type, String comment, boolean enabled, PolicyContent content) throws PolicyAlreadyExistsException {
        PolicyCreateRequest req = new PolicyCreateRequest(name, type, comment, enabled, org.apache.gravitino.dto.util.DTOConverters.toDTO(content));
        req.validate();
        PolicyResponse resp = this.restClient.post(String.format(API_METALAKES_POLICIES_PATH, RESTUtils.encodeString(this.name())), (RESTRequest)req, PolicyResponse.class, Collections.emptyMap(), ErrorHandlers.policyErrorHandler());
        resp.validate();
        return new GenericPolicy(resp.getPolicy(), this.restClient, this.name());
    }

    @Override
    public void enablePolicy(String name) throws NoSuchPolicyException {
        this.setPolicyEnabled(name, true);
    }

    @Override
    public void disablePolicy(String name) throws NoSuchPolicyException {
        this.setPolicyEnabled(name, false);
    }

    @Override
    public Policy alterPolicy(String name, PolicyChange ... changes) throws NoSuchPolicyException, IllegalArgumentException {
        Preconditions.checkArgument(StringUtils.isNotBlank(name), "policy name must not be null or empty");
        List<PolicyUpdateRequest> updates = Arrays.stream(changes).map(DTOConverters::toPolicyUpdateRequest).collect(Collectors.toList());
        PolicyUpdatesRequest req = new PolicyUpdatesRequest(updates);
        req.validate();
        PolicyResponse resp = this.restClient.put(String.format(API_METALAKES_POLICIES_PATH, RESTUtils.encodeString(this.name())) + "/" + RESTUtils.encodeString(name), (RESTRequest)req, PolicyResponse.class, Collections.emptyMap(), ErrorHandlers.policyErrorHandler());
        resp.validate();
        return new GenericPolicy(resp.getPolicy(), this.restClient, this.name());
    }

    @Override
    public boolean deletePolicy(String name) {
        Preconditions.checkArgument(StringUtils.isNotBlank(name), "policy name must not be null or empty");
        DropResponse resp = this.restClient.delete(String.format(API_METALAKES_POLICIES_PATH, RESTUtils.encodeString(this.name())) + "/" + RESTUtils.encodeString(name), DropResponse.class, Collections.emptyMap(), ErrorHandlers.policyErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    public User addUser(String user) throws UserAlreadyExistsException, NoSuchMetalakeException {
        UserAddRequest req = new UserAddRequest(user);
        req.validate();
        UserResponse resp = this.restClient.post(String.format(API_METALAKES_USERS_PATH, RESTUtils.encodeString(this.name()), BLANK_PLACEHOLDER), (RESTRequest)req, UserResponse.class, Collections.emptyMap(), ErrorHandlers.userErrorHandler());
        resp.validate();
        return resp.getUser();
    }

    public boolean removeUser(String user) throws NoSuchMetalakeException {
        RemoveResponse resp = this.restClient.delete(String.format(API_METALAKES_USERS_PATH, RESTUtils.encodeString(this.name()), RESTUtils.encodeString(user)), RemoveResponse.class, Collections.emptyMap(), ErrorHandlers.userErrorHandler());
        resp.validate();
        return resp.removed();
    }

    public User getUser(String user) throws NoSuchUserException, NoSuchMetalakeException {
        UserResponse resp = this.restClient.get(String.format(API_METALAKES_USERS_PATH, RESTUtils.encodeString(this.name()), RESTUtils.encodeString(user)), UserResponse.class, Collections.emptyMap(), ErrorHandlers.userErrorHandler());
        resp.validate();
        return resp.getUser();
    }

    public User[] listUsers() throws NoSuchMetalakeException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("details", "true");
        UserListResponse resp = this.restClient.get(String.format(API_METALAKES_USERS_PATH, RESTUtils.encodeString(this.name()), BLANK_PLACEHOLDER), params, UserListResponse.class, Collections.emptyMap(), ErrorHandlers.userErrorHandler());
        resp.validate();
        return resp.getUsers();
    }

    public String[] listUserNames() throws NoSuchMetalakeException {
        NameListResponse resp = this.restClient.get(String.format(API_METALAKES_USERS_PATH, RESTUtils.encodeString(this.name()), BLANK_PLACEHOLDER), NameListResponse.class, Collections.emptyMap(), ErrorHandlers.userErrorHandler());
        resp.validate();
        return resp.getNames();
    }

    public Group addGroup(String group) throws GroupAlreadyExistsException, NoSuchMetalakeException {
        GroupAddRequest req = new GroupAddRequest(group);
        req.validate();
        GroupResponse resp = this.restClient.post(String.format(API_METALAKES_GROUPS_PATH, RESTUtils.encodeString(this.name()), BLANK_PLACEHOLDER), (RESTRequest)req, GroupResponse.class, Collections.emptyMap(), ErrorHandlers.groupErrorHandler());
        resp.validate();
        return resp.getGroup();
    }

    public boolean removeGroup(String group) throws NoSuchMetalakeException {
        RemoveResponse resp = this.restClient.delete(String.format(API_METALAKES_GROUPS_PATH, RESTUtils.encodeString(this.name()), RESTUtils.encodeString(group)), RemoveResponse.class, Collections.emptyMap(), ErrorHandlers.groupErrorHandler());
        resp.validate();
        return resp.removed();
    }

    public Group getGroup(String group) throws NoSuchGroupException, NoSuchMetalakeException {
        GroupResponse resp = this.restClient.get(String.format(API_METALAKES_GROUPS_PATH, RESTUtils.encodeString(this.name()), RESTUtils.encodeString(group)), GroupResponse.class, Collections.emptyMap(), ErrorHandlers.groupErrorHandler());
        resp.validate();
        return resp.getGroup();
    }

    public Group[] listGroups() throws NoSuchMetalakeException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("details", "true");
        GroupListResponse resp = this.restClient.get(String.format(API_METALAKES_GROUPS_PATH, RESTUtils.encodeString(this.name()), BLANK_PLACEHOLDER), params, GroupListResponse.class, Collections.emptyMap(), ErrorHandlers.groupErrorHandler());
        resp.validate();
        return resp.getGroups();
    }

    public String[] listGroupNames() throws NoSuchMetalakeException {
        NameListResponse resp = this.restClient.get(String.format(API_METALAKES_GROUPS_PATH, RESTUtils.encodeString(this.name()), BLANK_PLACEHOLDER), NameListResponse.class, Collections.emptyMap(), ErrorHandlers.groupErrorHandler());
        resp.validate();
        return resp.getNames();
    }

    public Role getRole(String role) throws NoSuchRoleException, NoSuchMetalakeException {
        RoleResponse resp = this.restClient.get(String.format(API_METALAKES_ROLES_PATH, RESTUtils.encodeString(this.name()), RESTUtils.encodeString(role)), RoleResponse.class, Collections.emptyMap(), ErrorHandlers.roleErrorHandler());
        resp.validate();
        return resp.getRole();
    }

    public boolean deleteRole(String role) throws NoSuchMetalakeException {
        DropResponse resp = this.restClient.delete(String.format(API_METALAKES_ROLES_PATH, RESTUtils.encodeString(this.name()), RESTUtils.encodeString(role)), DropResponse.class, Collections.emptyMap(), ErrorHandlers.roleErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    public Role createRole(String role, Map<String, String> properties, List<SecurableObject> securableObjects) throws RoleAlreadyExistsException, NoSuchMetalakeException, IllegalMetadataObjectException {
        RoleCreateRequest req = new RoleCreateRequest(role, properties, (SecurableObjectDTO[])securableObjects.stream().map(DTOConverters::toSecurableObject).toArray(SecurableObjectDTO[]::new));
        req.validate();
        RoleResponse resp = this.restClient.post(String.format(API_METALAKES_ROLES_PATH, RESTUtils.encodeString(this.name()), BLANK_PLACEHOLDER), (RESTRequest)req, RoleResponse.class, Collections.emptyMap(), ErrorHandlers.roleErrorHandler());
        resp.validate();
        return resp.getRole();
    }

    public String[] listRoleNames() {
        NameListResponse resp = this.restClient.get(String.format(API_METALAKES_ROLES_PATH, RESTUtils.encodeString(this.name()), BLANK_PLACEHOLDER), NameListResponse.class, Collections.emptyMap(), ErrorHandlers.roleErrorHandler());
        resp.validate();
        return resp.getNames();
    }

    public User grantRolesToUser(List<String> roles, String user) throws NoSuchUserException, IllegalRoleException, NoSuchMetalakeException {
        RoleGrantRequest request = new RoleGrantRequest(roles);
        request.validate();
        UserResponse resp = this.restClient.put(String.format(API_PERMISSION_PATH, RESTUtils.encodeString(this.name()), String.format("users/%s/grant", RESTUtils.encodeString(user))), (RESTRequest)request, UserResponse.class, Collections.emptyMap(), ErrorHandlers.permissionOperationErrorHandler());
        resp.validate();
        return resp.getUser();
    }

    public Group grantRolesToGroup(List<String> roles, String group) throws NoSuchGroupException, NoSuchRoleException, NoSuchMetalakeException {
        RoleGrantRequest request = new RoleGrantRequest(roles);
        request.validate();
        GroupResponse resp = this.restClient.put(String.format(API_PERMISSION_PATH, RESTUtils.encodeString(this.name()), String.format("groups/%s/grant", RESTUtils.encodeString(group))), (RESTRequest)request, GroupResponse.class, Collections.emptyMap(), ErrorHandlers.permissionOperationErrorHandler());
        resp.validate();
        return resp.getGroup();
    }

    public User revokeRolesFromUser(List<String> roles, String user) throws NoSuchUserException, NoSuchRoleException, NoSuchMetalakeException {
        RoleRevokeRequest request = new RoleRevokeRequest(roles);
        request.validate();
        UserResponse resp = this.restClient.put(String.format(API_PERMISSION_PATH, RESTUtils.encodeString(this.name()), String.format("users/%s/revoke", RESTUtils.encodeString(user))), (RESTRequest)request, UserResponse.class, Collections.emptyMap(), ErrorHandlers.permissionOperationErrorHandler());
        resp.validate();
        return resp.getUser();
    }

    public Group revokeRolesFromGroup(List<String> roles, String group) throws NoSuchGroupException, IllegalRoleException, NoSuchMetalakeException {
        RoleRevokeRequest request = new RoleRevokeRequest(roles);
        request.validate();
        GroupResponse resp = this.restClient.put(String.format(API_PERMISSION_PATH, RESTUtils.encodeString(this.name()), String.format("groups/%s/revoke", RESTUtils.encodeString(group))), (RESTRequest)request, GroupResponse.class, Collections.emptyMap(), ErrorHandlers.permissionOperationErrorHandler());
        resp.validate();
        return resp.getGroup();
    }

    public Role grantPrivilegesToRole(String role, MetadataObject object, List<Privilege> privileges) throws NoSuchRoleException, NoSuchMetadataObjectException, NoSuchMetalakeException, IllegalPrivilegeException {
        HashSet<Privilege> privilegeSet = Sets.newHashSet(privileges);
        return this.grantPrivilegesToRole(role, object, privilegeSet);
    }

    public Role grantPrivilegesToRole(String role, MetadataObject object, Set<Privilege> privileges) throws NoSuchRoleException, NoSuchMetadataObjectException, NoSuchMetalakeException, IllegalPrivilegeException {
        PrivilegeGrantRequest request = new PrivilegeGrantRequest(DTOConverters.toPrivileges(privileges));
        request.validate();
        RoleResponse resp = this.restClient.put(String.format(API_PERMISSION_PATH, RESTUtils.encodeString(this.name()), String.format("roles/%s/%s/%s/grant", RESTUtils.encodeString(role), object.type().name().toLowerCase(Locale.ROOT), RESTUtils.encodeString(object.fullName()))), (RESTRequest)request, RoleResponse.class, Collections.emptyMap(), ErrorHandlers.permissionOperationErrorHandler());
        resp.validate();
        return resp.getRole();
    }

    @Deprecated
    public Role revokePrivilegesFromRole(String role, MetadataObject object, List<Privilege> privileges) throws NoSuchRoleException, NoSuchMetadataObjectException, NoSuchMetalakeException, IllegalPrivilegeException {
        HashSet<Privilege> privilegeSet = Sets.newHashSet(privileges);
        return this.revokePrivilegesFromRole(role, object, privilegeSet);
    }

    public Role revokePrivilegesFromRole(String role, MetadataObject object, Set<Privilege> privileges) throws NoSuchRoleException, NoSuchMetadataObjectException, NoSuchMetalakeException, IllegalPrivilegeException {
        PrivilegeRevokeRequest request = new PrivilegeRevokeRequest(DTOConverters.toPrivileges(privileges));
        request.validate();
        RoleResponse resp = this.restClient.put(String.format(API_PERMISSION_PATH, RESTUtils.encodeString(this.name()), String.format("roles/%s/%s/%s/revoke", RESTUtils.encodeString(role), object.type().name().toLowerCase(Locale.ROOT), RESTUtils.encodeString(object.fullName()))), (RESTRequest)request, RoleResponse.class, Collections.emptyMap(), ErrorHandlers.permissionOperationErrorHandler());
        resp.validate();
        return resp.getRole();
    }

    public Optional<Owner> getOwner(MetadataObject object) throws NoSuchMetadataObjectException {
        OwnerResponse resp = this.restClient.get(String.format(API_METALAKES_OWNERS_PATH, RESTUtils.encodeString(this.name()), String.format("%s/%s", object.type().name().toLowerCase(Locale.ROOT), RESTUtils.encodeString(object.fullName()))), OwnerResponse.class, Collections.emptyMap(), ErrorHandlers.ownerErrorHandler());
        resp.validate();
        return Optional.ofNullable(resp.getOwner());
    }

    public void setOwner(MetadataObject object, String ownerName, Owner.Type ownerType) throws NotFoundException {
        OwnerSetRequest request = new OwnerSetRequest(ownerName, ownerType);
        request.validate();
        SetResponse resp = this.restClient.put(String.format(API_METALAKES_OWNERS_PATH, RESTUtils.encodeString(this.name()), String.format("%s/%s", object.type().name().toLowerCase(Locale.ROOT), RESTUtils.encodeString(object.fullName()))), (RESTRequest)request, SetResponse.class, Collections.emptyMap(), ErrorHandlers.ownerErrorHandler());
        resp.validate();
    }

    @Override
    public String[] listBindingRoleNames() {
        return this.metadataObjectRoleOperations.listBindingRoleNames();
    }

    @Override
    public List<JobTemplate> listJobTemplates() {
        JobTemplateListResponse resp = this.restClient.get(String.format(API_METALAKES_JOB_TEMPLATES_PATH, RESTUtils.encodeString(this.name())), ImmutableMap.of("details", "true"), JobTemplateListResponse.class, Collections.emptyMap(), ErrorHandlers.jobErrorHandler());
        resp.validate();
        return resp.getJobTemplates().stream().map(org.apache.gravitino.dto.util.DTOConverters::fromDTO).collect(Collectors.toList());
    }

    @Override
    public void registerJobTemplate(JobTemplate jobTemplate) throws JobTemplateAlreadyExistsException {
        JobTemplateRegisterRequest req = new JobTemplateRegisterRequest(DTOConverters.toJobTemplateDTO(jobTemplate));
        BaseResponse resp = this.restClient.post(String.format(API_METALAKES_JOB_TEMPLATES_PATH, RESTUtils.encodeString(this.name())), (RESTRequest)req, BaseResponse.class, Collections.emptyMap(), ErrorHandlers.jobErrorHandler());
        resp.validate();
    }

    @Override
    public JobTemplate getJobTemplate(String jobTemplateName) throws NoSuchJobTemplateException {
        Preconditions.checkArgument(StringUtils.isNotBlank(jobTemplateName), "job template name must not be null or empty");
        JobTemplateResponse resp = this.restClient.get(String.format(API_METALAKES_JOB_TEMPLATES_PATH, RESTUtils.encodeString(this.name())) + "/" + RESTUtils.encodeString(jobTemplateName), JobTemplateResponse.class, Collections.emptyMap(), ErrorHandlers.jobErrorHandler());
        resp.validate();
        return org.apache.gravitino.dto.util.DTOConverters.fromDTO(resp.getJobTemplate());
    }

    @Override
    public boolean deleteJobTemplate(String jobTemplateName) throws InUseException {
        Preconditions.checkArgument(StringUtils.isNotBlank(jobTemplateName), "job template name must not be null or empty");
        DropResponse resp = this.restClient.delete(String.format(API_METALAKES_JOB_TEMPLATES_PATH, RESTUtils.encodeString(this.name())) + "/" + RESTUtils.encodeString(jobTemplateName), DropResponse.class, Collections.emptyMap(), ErrorHandlers.jobErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    @Override
    public JobTemplate alterJobTemplate(String jobTemplateName, JobTemplateChange ... changes) throws NoSuchJobTemplateException, IllegalArgumentException {
        Preconditions.checkArgument(StringUtils.isNotBlank(jobTemplateName), "job template name must not be null or empty");
        List<JobTemplateUpdateRequest> updates = Arrays.stream(changes).map(DTOConverters::toJobTemplateUpdateRequest).collect(Collectors.toList());
        JobTemplateUpdatesRequest req = new JobTemplateUpdatesRequest(updates);
        JobTemplateResponse resp = this.restClient.put(String.format(API_METALAKES_JOB_TEMPLATES_PATH, RESTUtils.encodeString(this.name())) + "/" + RESTUtils.encodeString(jobTemplateName), (RESTRequest)req, JobTemplateResponse.class, Collections.emptyMap(), ErrorHandlers.jobErrorHandler());
        resp.validate();
        return org.apache.gravitino.dto.util.DTOConverters.fromDTO(resp.getJobTemplate());
    }

    @Override
    public List<JobHandle> listJobs(String jobTemplateName) throws NoSuchJobTemplateException {
        Preconditions.checkArgument(StringUtils.isNotBlank(jobTemplateName), "job template name must not be null or empty");
        JobListResponse resp = this.restClient.get(String.format(API_METALAKES_JOB_PATH, RESTUtils.encodeString(this.name())), ImmutableMap.of("jobTemplateName", jobTemplateName), JobListResponse.class, Collections.emptyMap(), ErrorHandlers.jobErrorHandler());
        resp.validate();
        return resp.getJobs().stream().map(GenericJobHandle::new).collect(Collectors.toList());
    }

    @Override
    public List<JobHandle> listJobs() {
        JobListResponse resp = this.restClient.get(String.format(API_METALAKES_JOB_PATH, RESTUtils.encodeString(this.name())), Collections.emptyMap(), JobListResponse.class, Collections.emptyMap(), ErrorHandlers.jobErrorHandler());
        resp.validate();
        return resp.getJobs().stream().map(GenericJobHandle::new).collect(Collectors.toList());
    }

    @Override
    public JobHandle runJob(String jobTemplateName, Map<String, String> jobConf) throws NoSuchJobTemplateException {
        Preconditions.checkArgument(StringUtils.isNotBlank(jobTemplateName), "job template name must not be null or empty");
        JobRunRequest req = new JobRunRequest(jobTemplateName, jobConf);
        JobResponse resp = this.restClient.post(String.format(API_METALAKES_JOB_PATH, RESTUtils.encodeString(this.name())), (RESTRequest)req, JobResponse.class, Collections.emptyMap(), ErrorHandlers.jobErrorHandler());
        resp.validate();
        return new GenericJobHandle(resp.getJob());
    }

    @Override
    public JobHandle getJob(String jobId) throws NoSuchJobException {
        Preconditions.checkArgument(StringUtils.isNotBlank(jobId), "job id must not be null or empty");
        JobResponse resp = this.restClient.get(String.format(API_METALAKES_JOB_PATH, RESTUtils.encodeString(this.name())) + "/" + RESTUtils.encodeString(jobId), JobResponse.class, Collections.emptyMap(), ErrorHandlers.jobErrorHandler());
        resp.validate();
        return new GenericJobHandle(resp.getJob());
    }

    @Override
    public JobHandle cancelJob(String jobId) throws NoSuchJobException {
        Preconditions.checkArgument(StringUtils.isNotBlank(jobId), "job id must not be null or empty");
        JobResponse resp = this.restClient.post(String.format(API_METALAKES_JOB_PATH, RESTUtils.encodeString(this.name())) + "/" + RESTUtils.encodeString(jobId), null, JobResponse.class, Collections.emptyMap(), ErrorHandlers.jobErrorHandler());
        resp.validate();
        return new GenericJobHandle(resp.getJob());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GravitinoMetalake)) {
            return false;
        }
        GravitinoMetalake that = (GravitinoMetalake)o;
        return super.equals(that);
    }

    public static Builder builder() {
        return new Builder();
    }

    private void setPolicyEnabled(String policyName, boolean enabled) {
        PolicySetRequest req = new PolicySetRequest(enabled);
        ErrorResponse resp = this.restClient.patch(String.format(API_METALAKES_POLICIES_PATH, RESTUtils.encodeString(this.name())) + "/" + RESTUtils.encodeString(policyName), req, ErrorResponse.class, Collections.emptyMap(), ErrorHandlers.policyErrorHandler());
        if (resp.getCode() == 0) {
            return;
        }
        ErrorHandlers.policyErrorHandler().accept(resp);
    }

    static class Builder
    extends MetalakeDTO.Builder<Builder> {
        private RESTClient restClient;

        private Builder() {
        }

        Builder withRestClient(RESTClient restClient) {
            this.restClient = restClient;
            return this;
        }

        @Override
        public GravitinoMetalake build() {
            Preconditions.checkArgument(this.restClient != null, "restClient must be set");
            Preconditions.checkArgument(StringUtils.isNotBlank(this.name), "name must not be null or empty");
            Preconditions.checkArgument(this.audit != null, "audit must not be null");
            return new GravitinoMetalake(this.name, this.comment, this.properties, this.audit, this.restClient);
        }
    }
}

