/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.postgresql;

import org.apache.gravitino.storage.relational.mapper.provider.base.ModelVersionMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.po.ModelVersionPO;
import org.apache.ibatis.annotations.Param;

public class ModelVersionMetaPostgreSQLProvider
extends ModelVersionMetaBaseSQLProvider {
    @Override
    public String softDeleteModelVersionsBySchemaIdAndModelName(@Param(value="schemaId") Long schemaId, @Param(value="modelName") String modelName) {
        return "UPDATE model_version_info mvi SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE mvi.schema_id = #{schemaId} AND mvi.model_id = ( SELECT mm.model_id FROM model_meta mm WHERE mm.schema_id = #{schemaId} AND mm.model_name = #{modelName} AND mm.deleted_at = 0) AND mvi.deleted_at = 0";
    }

    @Override
    public String softDeleteModelVersionMetaByModelIdAndVersion(@Param(value="modelId") Long modelId, @Param(value="modelVersion") Integer modelVersion) {
        return "UPDATE model_version_info SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE model_id = #{modelId} AND version = #{modelVersion} AND deleted_at = 0";
    }

    @Override
    public String softDeleteModelVersionMetaByModelIdAndAlias(@Param(value="modelId") Long modelId, @Param(value="alias") String alias) {
        return "UPDATE model_version_info SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE model_id = #{modelId} AND version = ( SELECT model_version FROM model_version_alias_rel WHERE model_id = #{modelId} AND model_version_alias = #{alias} AND deleted_at = 0) AND deleted_at = 0";
    }

    @Override
    public String softDeleteModelVersionMetasBySchemaId(@Param(value="schemaId") Long schemaId) {
        return "UPDATE model_version_info SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE schema_id = #{schemaId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteModelVersionMetasByCatalogId(@Param(value="catalogId") Long catalogId) {
        return "UPDATE model_version_info SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE catalog_id = #{catalogId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteModelVersionMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE model_version_info SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    @Override
    public String deleteModelVersionMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM model_version_info WHERE id IN (SELECT id FROM model_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit})";
    }

    @Override
    public String updateModelVersionMeta(@Param(value="newModelVersionMeta") ModelVersionPO newModelVersionPO, @Param(value="oldModelVersionMeta") ModelVersionPO oldModelVersionPO) {
        return "UPDATE model_version_info SET metalake_id = #{newModelVersionMeta.metalakeId}, catalog_id = #{newModelVersionMeta.catalogId}, schema_id = #{newModelVersionMeta.schemaId}, model_id = #{newModelVersionMeta.modelId}, version = #{newModelVersionMeta.modelVersion}, model_version_comment = #{newModelVersionMeta.modelVersionComment}, model_version_properties = #{newModelVersionMeta.modelVersionProperties}, audit_info = #{newModelVersionMeta.auditInfo}, deleted_at = #{newModelVersionMeta.deletedAt} WHERE model_id = #{oldModelVersionMeta.modelId} AND metalake_id = #{oldModelVersionMeta.metalakeId} AND catalog_id = #{oldModelVersionMeta.catalogId} AND schema_id = #{oldModelVersionMeta.schemaId} AND version = #{oldModelVersionMeta.modelVersion} AND (model_version_comment = #{oldModelVersionMeta.modelVersionComment}   OR (CAST(model_version_comment AS VARCHAR) IS NULL   AND CAST(#{oldModelVersionMeta.modelVersionComment} AS VARCHAR) IS NULL)) AND model_version_properties = #{oldModelVersionMeta.modelVersionProperties} AND audit_info = #{oldModelVersionMeta.auditInfo} AND deleted_at = 0";
    }
}

