/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.seq;

import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.exception.NoSuchPropertyException;
import com.googlecode.aviator.lexer.token.OperatorType;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import com.googlecode.aviator.utils.Reflector;
import java.util.Map;

public class SeqPredicateFunction
extends AbstractFunction {
    private static final long serialVersionUID = 478017115680743291L;
    private final String name;
    private final OperatorType opType;
    private final AviatorObject value;
    private final AviatorObject propertyName;

    public SeqPredicateFunction(String name, OperatorType opType, AviatorObject value) {
        this(name, opType, value, null);
    }

    public SeqPredicateFunction(String name, OperatorType opType, AviatorObject value, AviatorObject propertyName) {
        this.name = name;
        this.opType = opType;
        this.value = value;
        this.propertyName = propertyName;
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1) {
        if (this.propertyName != null) {
            String propertyNameStr = this.propertyName.stringValue(env);
            Object target = arg1.getValue(env);
            try {
                Object property = Reflector.getProperty(target, propertyNameStr);
                arg1 = AviatorRuntimeJavaType.valueOf(property);
            }
            catch (NoSuchPropertyException e) {
                throw new IllegalArgumentException("Fail to get property <" + propertyNameStr + "> from <" + arg1.desc(env) + ">", e);
            }
        }
        switch (this.opType) {
            case EQ: {
                return arg1.compare(this.value, env) == 0 ? AviatorBoolean.TRUE : AviatorBoolean.FALSE;
            }
            case NEQ: {
                return arg1.compare(this.value, env) != 0 ? AviatorBoolean.TRUE : AviatorBoolean.FALSE;
            }
            case LT: {
                return arg1.compare(this.value, env) < 0 ? AviatorBoolean.TRUE : AviatorBoolean.FALSE;
            }
            case LE: {
                return arg1.compare(this.value, env) <= 0 ? AviatorBoolean.TRUE : AviatorBoolean.FALSE;
            }
            case GE: {
                return arg1.compare(this.value, env) >= 0 ? AviatorBoolean.TRUE : AviatorBoolean.FALSE;
            }
            case GT: {
                return arg1.compare(this.value, env) > 0 ? AviatorBoolean.TRUE : AviatorBoolean.FALSE;
            }
        }
        throw new ExpressionRuntimeException(this.getName() + " is not a relation operator");
    }

    @Override
    public String getName() {
        return this.name;
    }
}

