/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;

public class ComputeFairShares {
    private static final int COMPUTE_FAIR_SHARES_ITERATIONS = 25;

    public static void computeShares(Collection<? extends Schedulable> schedulables, Resource totalResources, String type) {
        ComputeFairShares.computeSharesInternal(schedulables, totalResources, type, false);
    }

    public static void computeSteadyShares(Collection<? extends FSQueue> queues, Resource totalResources, String type) {
        ComputeFairShares.computeSharesInternal(queues, totalResources, type, true);
    }

    private static void computeSharesInternal(Collection<? extends Schedulable> allSchedulables, Resource totalResources, String type, boolean isSteadyShare) {
        Schedulable sched;
        long maxShare;
        ArrayList<Schedulable> schedulables = new ArrayList<Schedulable>();
        int takenResources = ComputeFairShares.handleFixedFairShares(allSchedulables, schedulables, isSteadyShare, type);
        if (schedulables.isEmpty()) {
            return;
        }
        int totalMaxShare = 0;
        Iterator iterator = schedulables.iterator();
        while (iterator.hasNext() && (totalMaxShare = (int)Math.min((maxShare = (sched = (Schedulable)iterator.next()).getMaxShare().getResourceValue(type)) + (long)totalMaxShare, Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
        }
        long totalResource = Math.max(totalResources.getResourceValue(type) - (long)takenResources, 0L);
        totalResource = Math.min((long)totalMaxShare, totalResource);
        double rMax = 1.0;
        while ((long)ComputeFairShares.resourceUsedWithWeightToResourceRatio(rMax, schedulables, type) < totalResource) {
            rMax *= 2.0;
        }
        double left = 0.0;
        double right = rMax;
        for (int i = 0; i < 25; ++i) {
            double mid = (left + right) / 2.0;
            int plannedResourceUsed = ComputeFairShares.resourceUsedWithWeightToResourceRatio(mid, schedulables, type);
            if ((long)plannedResourceUsed == totalResource) {
                right = mid;
                break;
            }
            if ((long)plannedResourceUsed < totalResource) {
                left = mid;
                continue;
            }
            right = mid;
        }
        for (Schedulable sched2 : schedulables) {
            Resource target = isSteadyShare ? ((FSQueue)sched2).getSteadyFairShare() : sched2.getFairShare();
            target.setResourceValue(type, (long)ComputeFairShares.computeShare(sched2, right, type));
        }
    }

    private static int resourceUsedWithWeightToResourceRatio(double w2rRatio, Collection<? extends Schedulable> schedulables, String type) {
        int resourcesTaken = 0;
        for (Schedulable schedulable : schedulables) {
            int share = ComputeFairShares.computeShare(schedulable, w2rRatio, type);
            resourcesTaken += share;
        }
        return resourcesTaken;
    }

    private static int computeShare(Schedulable sched, double w2rRatio, String type) {
        double share = (double)sched.getWeight() * w2rRatio;
        share = Math.max(share, (double)sched.getMinShare().getResourceValue(type));
        share = Math.min(share, (double)sched.getMaxShare().getResourceValue(type));
        return (int)share;
    }

    private static int handleFixedFairShares(Collection<? extends Schedulable> schedulables, Collection<Schedulable> nonFixedSchedulables, boolean isSteadyShare, String type) {
        int totalResource = 0;
        for (Schedulable schedulable : schedulables) {
            long fixedShare = ComputeFairShares.getFairShareIfFixed(schedulable, isSteadyShare, type);
            if (fixedShare < 0L) {
                nonFixedSchedulables.add(schedulable);
                continue;
            }
            Resource target = isSteadyShare ? ((FSQueue)schedulable).getSteadyFairShare() : schedulable.getFairShare();
            target.setResourceValue(type, fixedShare);
            totalResource = (int)Math.min((long)totalResource + fixedShare, Integer.MAX_VALUE);
        }
        return totalResource;
    }

    private static long getFairShareIfFixed(Schedulable sched, boolean isSteadyShare, String type) {
        if (sched.getMaxShare().getResourceValue(type) <= 0L) {
            return 0L;
        }
        if (!isSteadyShare && sched instanceof FSQueue && !((FSQueue)sched).isActive()) {
            return 0L;
        }
        if (sched.getWeight() <= 0.0f) {
            long minShare = sched.getMinShare().getResourceValue(type);
            return minShare <= 0L ? 0L : minShare;
        }
        return -1L;
    }
}

