/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.NewRedBlackTree;
import scala.collection.immutable.NewRedBlackTree$partitioner$1$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.sys.package$;

public final class NewRedBlackTree$ {
    public static NewRedBlackTree$ MODULE$;
    private final Tuple2<Null$, Null$> null2;

    static {
        new NewRedBlackTree$();
    }

    public boolean isEmpty(NewRedBlackTree.Tree<?, ?> tree) {
        return tree == null;
    }

    public <A> boolean contains(NewRedBlackTree.Tree<A, ?> tree, A x, Ordering<A> evidence$1) {
        return this.lookup(tree, x, evidence$1) != null;
    }

    public <A, B> Option<B> get(NewRedBlackTree.Tree<A, B> tree, A x, Ordering<A> evidence$2) {
        NewRedBlackTree.Tree tree2 = this.lookup(tree, x, evidence$2);
        if (tree2 == null) {
            return None$.MODULE$;
        }
        return new Some(tree2.scala$collection$immutable$NewRedBlackTree$Tree$$_value);
    }

    public <A, B> NewRedBlackTree.Tree<A, B> lookup(NewRedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        while (true) {
            if (tree == null) {
                return null;
            }
            int cmp = ordering.compare(x, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key);
            if (cmp < 0) {
                tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
                continue;
            }
            if (cmp <= 0) break;
            tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        }
        return tree;
    }

    public int count(NewRedBlackTree.Tree<?, ?> tree) {
        if (tree == null) {
            return 0;
        }
        return tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE;
    }

    public <A, B, B1> NewRedBlackTree.Tree<A, B1> update(NewRedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> evidence$3) {
        return this.blacken(this.upd(tree, k, v, overwrite, evidence$3));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> delete(NewRedBlackTree.Tree<A, B> tree, A k, Ordering<A> evidence$4) {
        return this.blacken(this.del(tree, k, evidence$4));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> rangeImpl(NewRedBlackTree.Tree<A, B> tree, Option<A> from, Option<A> until, Ordering<A> evidence$5) {
        Tuple2 tuple2 = new Tuple2(from, until);
        if (from instanceof Some) {
            Object from2 = ((Some)from).value();
            if (until instanceof Some) {
                Object until2 = ((Some)until).value();
                return this.range(tree, from2, until2, evidence$5);
            }
        }
        if (from instanceof Some) {
            Object from3 = ((Some)from).value();
            if (None$.MODULE$.equals(until)) {
                return this.from(tree, from3, evidence$5);
            }
        }
        if (None$.MODULE$.equals(from) && until instanceof Some) {
            Object until3 = ((Some)until).value();
            return this.until(tree, until3, evidence$5);
        }
        if (None$.MODULE$.equals(from) && None$.MODULE$.equals(until)) {
            return tree;
        }
        throw new MatchError((Object)tuple2);
    }

    public <A, B> NewRedBlackTree.Tree<A, B> range(NewRedBlackTree.Tree<A, B> tree, A from, A until, Ordering<A> evidence$6) {
        return this.blacken(this.doRange(tree, from, until, evidence$6));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> from(NewRedBlackTree.Tree<A, B> tree, A from, Ordering<A> evidence$7) {
        return this.blacken(this.doFrom(tree, from, evidence$7));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> to(NewRedBlackTree.Tree<A, B> tree, A to, Ordering<A> evidence$8) {
        return this.blacken(this.doTo(tree, to, evidence$8));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> until(NewRedBlackTree.Tree<A, B> tree, A key, Ordering<A> evidence$9) {
        return this.blacken(this.doUntil(tree, key, evidence$9));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> drop(NewRedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$10) {
        return this.blacken(this.doDrop(tree, n));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> take(NewRedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$11) {
        return this.blacken(this.doTake(tree, n));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> slice(NewRedBlackTree.Tree<A, B> tree, int from, int until, Ordering<A> evidence$12) {
        return this.blacken(this.doSlice(tree, from, until));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> smallest(NewRedBlackTree.Tree<A, B> tree) {
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        NewRedBlackTree.Tree result = tree;
        while (true) {
            if (result == null) {
                throw null;
            }
            if (result.scala$collection$immutable$NewRedBlackTree$Tree$$_left == null) break;
            result = result.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        }
        return result;
    }

    public <A, B> NewRedBlackTree.Tree<A, B> greatest(NewRedBlackTree.Tree<A, B> tree) {
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        NewRedBlackTree.Tree result = tree;
        while (true) {
            if (result == null) {
                throw null;
            }
            if (result.scala$collection$immutable$NewRedBlackTree$Tree$$_right == null) break;
            result = result.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        }
        return result;
    }

    public <A, B> NewRedBlackTree.Tree<A, B> tail(NewRedBlackTree.Tree<A, B> tree) {
        return this.blacken(this._tail$1(tree));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> init(NewRedBlackTree.Tree<A, B> tree) {
        return this.blacken(this._init$1(tree));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> minAfter(NewRedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        while (tree != null) {
            int cmp = ordering.compare(x, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key);
            if (cmp == 0) {
                return tree;
            }
            if (cmp < 0) {
                NewRedBlackTree.Tree l = this.minAfter(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, x, ordering);
                if (l != null) {
                    return l;
                }
                return tree;
            }
            tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        }
        return null;
    }

    public <A, B> NewRedBlackTree.Tree<A, B> maxBefore(NewRedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        while (true) {
            if (tree == null) {
                return null;
            }
            if (ordering.compare(x, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key) > 0) break;
            tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        }
        NewRedBlackTree.Tree r = this.maxBefore(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, x, ordering);
        if (r != null) {
            return r;
        }
        return tree;
    }

    public <A, B, U> void foreach(NewRedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        if (tree != null) {
            this._foreach(tree, f);
            return;
        }
    }

    public <A, X, Y> boolean keysEqual(NewRedBlackTree.Tree<A, X> a, NewRedBlackTree.Tree<A, Y> b, Ordering<A> evidence$13) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return (a.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) == (b.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) && new NewRedBlackTree.EqualsIterator(a, evidence$13).sameKeys(new NewRedBlackTree.EqualsIterator(b, evidence$13));
    }

    public <A, X, Y> boolean valuesEqual(NewRedBlackTree.Tree<A, X> a, NewRedBlackTree.Tree<A, Y> b, Ordering<A> evidence$14) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return (a.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) == (b.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) && new NewRedBlackTree.EqualsIterator(a, evidence$14).sameValues(new NewRedBlackTree.EqualsIterator(b, evidence$14));
    }

    public <A, X, Y> boolean entriesEqual(NewRedBlackTree.Tree<A, X> a, NewRedBlackTree.Tree<A, Y> b, Ordering<A> evidence$15) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return (a.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) == (b.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) && new NewRedBlackTree.EqualsIterator(a, evidence$15).sameEntries(new NewRedBlackTree.EqualsIterator(b, evidence$15));
    }

    private <A, B, U> void _foreach(NewRedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        while (true) {
            if (tree == null) {
                throw null;
            }
            if (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left != null) {
                this._foreach(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, f);
            }
            f.apply((Object)new Tuple2(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value));
            if (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right == null) break;
            tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        }
    }

    public <A, U> void foreachKey(NewRedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        if (tree != null) {
            this._foreachKey(tree, f);
            return;
        }
    }

    private <A, U> void _foreachKey(NewRedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        while (true) {
            if (tree == null) {
                throw null;
            }
            if (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left != null) {
                this._foreachKey(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, f);
            }
            f.apply(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key);
            if (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right == null) break;
            tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        }
    }

    public <A, B, U> void foreachEntry(NewRedBlackTree.Tree<A, B> tree, Function2<A, B, U> f) {
        if (tree != null) {
            this._foreachEntry(tree, f);
            return;
        }
    }

    private <A, B, U> void _foreachEntry(NewRedBlackTree.Tree<A, B> tree, Function2<A, B, U> f) {
        while (true) {
            if (tree == null) {
                throw null;
            }
            if (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left != null) {
                this._foreachEntry(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, f);
            }
            f.apply(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value);
            if (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right == null) break;
            tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        }
    }

    public <A, B> Iterator<Tuple2<A, B>> iterator(NewRedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$16) {
        return new NewRedBlackTree.EntriesIterator(tree, start, evidence$16);
    }

    public <A, B> None$ iterator$default$2() {
        return None$.MODULE$;
    }

    public <A> Iterator<A> keysIterator(NewRedBlackTree.Tree<A, ?> tree, Option<A> start, Ordering<A> evidence$17) {
        return new NewRedBlackTree.KeysIterator(tree, start, evidence$17);
    }

    public <A> None$ keysIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> Iterator<B> valuesIterator(NewRedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$18) {
        return new NewRedBlackTree.ValuesIterator(tree, start, evidence$18);
    }

    public <A, B> None$ valuesIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> NewRedBlackTree.Tree<A, B> nth(NewRedBlackTree.Tree<A, B> tree, int n) {
        while (true) {
            if (tree == null) {
                throw null;
            }
            int count = this.count(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left);
            if (n < count) {
                tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
                continue;
            }
            if (n <= count) break;
            n = n - count - 1;
            tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        }
        return tree;
    }

    public boolean isBlack(NewRedBlackTree.Tree<?, ?> tree) {
        return tree == null || tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0;
    }

    public boolean scala$collection$immutable$NewRedBlackTree$$isRedTree(NewRedBlackTree.Tree<?, ?> tree) {
        return tree != null && tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0;
    }

    private boolean isBlackTree(NewRedBlackTree.Tree<?, ?> tree) {
        return tree != null && tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0;
    }

    private <A, B> NewRedBlackTree.Tree<A, B> blacken(NewRedBlackTree.Tree<A, B> t) {
        if (t == null) {
            return null;
        }
        return t.black();
    }

    private <A, B> NewRedBlackTree.Tree<A, B> maybeBlacken(NewRedBlackTree.Tree<A, B> t) {
        NewRedBlackTree.Tree scala$collection$immutable$NewRedBlackTree$$isRedTree_tree;
        if (this.isBlack(t)) {
            return t;
        }
        if (t == null) {
            throw null;
        }
        NewRedBlackTree.Tree scala$collection$immutable$NewRedBlackTree$$isRedTree_tree2 = t.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        if (scala$collection$immutable$NewRedBlackTree$$isRedTree_tree2 != null && scala$collection$immutable$NewRedBlackTree$$isRedTree_tree2.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0 || (scala$collection$immutable$NewRedBlackTree$$isRedTree_tree = t.scala$collection$immutable$NewRedBlackTree$Tree$$_right) != null && scala$collection$immutable$NewRedBlackTree$$isRedTree_tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            return t.black();
        }
        return t;
    }

    private <A, B> NewRedBlackTree.Tree<A, Nothing$> mkTree(boolean isBlack, A key, B value, NewRedBlackTree.Tree<A, B> left, NewRedBlackTree.Tree<A, B> right) {
        int sizeAndColour = (left == null ? 0 : left.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) + (right == null ? 0 : right.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) + 1 | (isBlack ? Integer.MIN_VALUE : 0);
        return new NewRedBlackTree.Tree(key, value, left, right, sizeAndColour);
    }

    private <A, B1> NewRedBlackTree.Tree<A, B1> balanceLeft(NewRedBlackTree.Tree<A, B1> tree, NewRedBlackTree.Tree<A, B1> newLeft) {
        if (tree == null) {
            throw null;
        }
        if (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left == newLeft) {
            return tree;
        }
        if (newLeft == null) {
            throw null;
        }
        if (newLeft.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            NewRedBlackTree.Tree newLeft_left = newLeft.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
            NewRedBlackTree.Tree newLeft_right = newLeft.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
            if (newLeft_left != null && newLeft_left.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                NewRedBlackTree.Tree resultLeft = newLeft_left.black();
                NewRedBlackTree.Tree resultRight = tree.blackWithLeft(newLeft_right);
                return newLeft.withLeftRight(resultLeft, resultRight);
            }
            if (newLeft_right != null && newLeft_right.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                if (newLeft_right == null) {
                    throw null;
                }
                NewRedBlackTree.Tree newLeft_right_right = newLeft_right.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
                NewRedBlackTree.Tree resultLeft = newLeft.blackWithRight(newLeft_right.scala$collection$immutable$NewRedBlackTree$Tree$$_left);
                NewRedBlackTree.Tree resultRight = tree.blackWithLeft(newLeft_right_right);
                return newLeft_right.withLeftRight(resultLeft, resultRight);
            }
            return tree.withLeft(newLeft);
        }
        return tree.withLeft(newLeft);
    }

    private <A, B1> NewRedBlackTree.Tree<A, B1> balanceRight(NewRedBlackTree.Tree<A, B1> tree, NewRedBlackTree.Tree<A, B1> newRight) {
        if (tree == null) {
            throw null;
        }
        if (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right == newRight) {
            return tree;
        }
        if (newRight == null) {
            throw null;
        }
        if (newRight.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            NewRedBlackTree.Tree newRight_left = newRight.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
            if (newRight_left != null && newRight_left.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                if (newRight_left == null) {
                    throw null;
                }
                NewRedBlackTree.Tree resultLeft = tree.blackWithRight(newRight_left.scala$collection$immutable$NewRedBlackTree$Tree$$_left);
                NewRedBlackTree.Tree resultRight = newRight.blackWithLeft(newRight_left.scala$collection$immutable$NewRedBlackTree$Tree$$_right);
                return newRight_left.withLeftRight(resultLeft, resultRight);
            }
            NewRedBlackTree.Tree newRight_right = newRight.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
            if (newRight_right != null && newRight_right.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                NewRedBlackTree.Tree resultLeft = tree.blackWithRight(newRight_left);
                NewRedBlackTree.Tree resultRight = newRight_right.black();
                return newRight.withLeftRight(resultLeft, resultRight);
            }
            return tree.withRight(newRight);
        }
        return tree.withRight(newRight);
    }

    private <A, B, B1> NewRedBlackTree.Tree<A, B1> upd(NewRedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> ordering) {
        if (tree == null) {
            return this.RedTree(k, v, null, null);
        }
        if (k == tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key) {
            if (overwrite) {
                return tree.withV(v);
            }
            return tree;
        }
        int cmp = ordering.compare(k, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key);
        if (cmp < 0) {
            return this.balanceLeft(tree, this.upd(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, k, v, overwrite, ordering));
        }
        if (cmp > 0) {
            return this.balanceRight(tree, this.upd(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, k, v, overwrite, ordering));
        }
        if (overwrite || !BoxesRunTime.equals(k, (Object)tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key)) {
            return tree.withKV(k, v);
        }
        return tree;
    }

    private <A, B, B1> NewRedBlackTree.Tree<A, B1> updNth(NewRedBlackTree.Tree<A, B> tree, int idx, A k, B1 v) {
        if (tree == null) {
            return this.RedTree(k, v, null, null);
        }
        int rank = this.count(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left) + 1;
        if (idx < rank) {
            return this.balanceLeft(tree, this.updNth(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, idx, k, v));
        }
        if (idx > rank) {
            return this.balanceRight(tree, this.updNth(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, idx - rank, k, v));
        }
        return tree;
    }

    private <A, B> NewRedBlackTree.Tree<A, B> doFrom(NewRedBlackTree.Tree<A, B> tree, A from, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, from)) {
            return this.doFrom(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, from, ordering);
        }
        NewRedBlackTree.Tree newLeft = this.doFrom(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, from, ordering);
        if (newLeft == tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left) {
            return tree;
        }
        if (newLeft == null) {
            return this.upd(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, false, ordering);
        }
        return this.scala$collection$immutable$NewRedBlackTree$$join(newLeft, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right);
    }

    private <A, B> NewRedBlackTree.Tree<A, B> doTo(NewRedBlackTree.Tree<A, B> tree, A to, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(to, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key)) {
            return this.doTo(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, to, ordering);
        }
        NewRedBlackTree.Tree newRight = this.doTo(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, to, ordering);
        if (newRight == tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right) {
            return tree;
        }
        if (newRight == null) {
            return this.upd(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, false, ordering);
        }
        return this.scala$collection$immutable$NewRedBlackTree$$join(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, newRight);
    }

    private <A, B> NewRedBlackTree.Tree<A, B> doUntil(NewRedBlackTree.Tree<A, B> tree, A until, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lteq(until, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key)) {
            return this.doUntil(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, until, ordering);
        }
        NewRedBlackTree.Tree newRight = this.doUntil(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, until, ordering);
        if (newRight == tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right) {
            return tree;
        }
        if (newRight == null) {
            return this.upd(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, false, ordering);
        }
        return this.scala$collection$immutable$NewRedBlackTree$$join(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, newRight);
    }

    private <A, B> NewRedBlackTree.Tree<A, B> doRange(NewRedBlackTree.Tree<A, B> tree, A from, A until, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, from)) {
            return this.doRange(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, from, until, ordering);
        }
        if (ordering.lteq(until, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key)) {
            return this.doRange(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, from, until, ordering);
        }
        NewRedBlackTree.Tree newLeft = this.doFrom(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, from, ordering);
        NewRedBlackTree.Tree newRight = this.doUntil(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, until, ordering);
        if (newLeft == tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left && newRight == tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right) {
            return tree;
        }
        if (newLeft == null) {
            return this.upd(newRight, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, false, ordering);
        }
        if (newRight == null) {
            return this.upd(newLeft, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, false, ordering);
        }
        return this.scala$collection$immutable$NewRedBlackTree$$join(newLeft, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, newRight);
    }

    private <A, B> NewRedBlackTree.Tree<A, B> doDrop(NewRedBlackTree.Tree<A, B> tree, int n) {
        int l;
        while (true) {
            if (tree == null || n <= 0) {
                return tree;
            }
            if (n >= (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE)) {
                return null;
            }
            l = this.count(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left);
            if (n <= l) break;
            n = n - l - 1;
            tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        }
        if (n == l) {
            return this.scala$collection$immutable$NewRedBlackTree$$join(null, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right);
        }
        return this.scala$collection$immutable$NewRedBlackTree$$join(this.doDrop(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, n), tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right);
    }

    private <A, B> NewRedBlackTree.Tree<A, B> doTake(NewRedBlackTree.Tree<A, B> tree, int n) {
        int l;
        while (true) {
            if (tree == null || n <= 0) {
                return null;
            }
            if (n >= (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE)) {
                return tree;
            }
            l = this.count(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left);
            if (n > l) break;
            tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        }
        if (n == l + 1) {
            return this.maybeBlacken(this.updNth(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, n, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value));
        }
        return this.scala$collection$immutable$NewRedBlackTree$$join(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, this.doTake(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, n - l - 1));
    }

    private <A, B> NewRedBlackTree.Tree<A, B> doSlice(NewRedBlackTree.Tree<A, B> tree, int from, int until) {
        int l;
        while (true) {
            if (tree == null || from >= until || from >= (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) || until <= 0) {
                return null;
            }
            if (from <= 0 && until >= (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE)) {
                return tree;
            }
            l = this.count(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left);
            if (until <= l) {
                tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
                continue;
            }
            if (from <= l) break;
            until = until - l - 1;
            from = from - l - 1;
            tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        }
        return this.scala$collection$immutable$NewRedBlackTree$$join(this.doDrop(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, from), tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, this.doTake(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, until - l - 1));
    }

    public final int colourBit() {
        return Integer.MIN_VALUE;
    }

    public final int colourMask() {
        return Integer.MAX_VALUE;
    }

    public final int initialBlackCount() {
        return Integer.MIN_VALUE;
    }

    public final int initialRedCount() {
        return 0;
    }

    public <A, B> NewRedBlackTree.Tree<A, B> mutableRedTree(A key, B value, NewRedBlackTree.Tree<A, B> left, NewRedBlackTree.Tree<A, B> right) {
        return new NewRedBlackTree.Tree(key, value, left, right, 0);
    }

    public <A, B> NewRedBlackTree.Tree<A, B> mutableBlackTree(A key, B value, NewRedBlackTree.Tree<A, B> left, NewRedBlackTree.Tree<A, B> right) {
        return new NewRedBlackTree.Tree(key, value, left, right, Integer.MIN_VALUE);
    }

    public <A, B> NewRedBlackTree.Tree<A, B> RedTree(A key, B value, NewRedBlackTree.Tree<A, B> left, NewRedBlackTree.Tree<A, B> right) {
        int size = (left == null ? 0 : left.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) + (right == null ? 0 : right.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) + 1;
        return new NewRedBlackTree.Tree(key, value, left, right, 0 | size);
    }

    public <A, B> NewRedBlackTree.Tree<A, B> BlackTree(A key, B value, NewRedBlackTree.Tree<A, B> left, NewRedBlackTree.Tree<A, B> right) {
        int size = (left == null ? 0 : left.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) + (right == null ? 0 : right.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) + 1;
        return new NewRedBlackTree.Tree(key, value, left, right, Integer.MIN_VALUE | size);
    }

    private int sizeOf(NewRedBlackTree.Tree<?, ?> tree) {
        if (tree == null) {
            return 0;
        }
        return tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE;
    }

    public <A, B> NewRedBlackTree.Tree<A, B> fromOrderedEntries(Iterator<A> keys, Iterator<B> values, int size) {
        int maxUsedDepth = 32 - Integer.numberOfLeadingZeros(size);
        return this.f$1(1, size, keys, values, maxUsedDepth);
    }

    public <A, B, C> NewRedBlackTree.Tree<A, C> transform(NewRedBlackTree.Tree<A, B> t, Function2<A, B, C> f) {
        if (t == null) {
            return null;
        }
        Object k = t.scala$collection$immutable$NewRedBlackTree$Tree$$_key;
        Object v = t.scala$collection$immutable$NewRedBlackTree$Tree$$_value;
        NewRedBlackTree.Tree l = t.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        NewRedBlackTree.Tree r = t.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        NewRedBlackTree.Tree l2 = this.transform(l, f);
        Object v2 = f.apply(k, v);
        NewRedBlackTree.Tree r2 = this.transform(r, f);
        if (v2 == v && l2 == l && r2 == r) {
            return t;
        }
        return this.mkTree(t.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0, k, v2, l2, r2);
    }

    public <A, B> NewRedBlackTree.Tree<A, B> filterEntries(NewRedBlackTree.Tree<A, B> t, Function2<A, B, Object> f) {
        if (t == null) {
            return null;
        }
        return this.blacken(this.fk$1(t, f));
    }

    public <A, B> Tuple2<NewRedBlackTree.Tree<A, B>, NewRedBlackTree.Tree<A, B>> partitionEntries(NewRedBlackTree.Tree<A, B> t, Function2<A, B, Object> p) {
        NewRedBlackTree$partitioner$1$ newRedBlackTree$partitioner$1$;
        if (t == null) {
            return this.null2;
        }
        LazyRef partitioner$module = new LazyRef();
        if (partitioner$module.initialized()) {
            newRedBlackTree$partitioner$1$ = (NewRedBlackTree$partitioner$1$)partitioner$module.value();
        } else {
            synchronized (partitioner$module) {
                NewRedBlackTree$partitioner$1$ newRedBlackTree$partitioner$1$2 = partitioner$module.initialized() ? (NewRedBlackTree$partitioner$1$)partitioner$module.value() : (NewRedBlackTree$partitioner$1$)partitioner$module.initialize((Object)new NewRedBlackTree$partitioner$1$(p));
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl10 : MonitorExitStatement: MONITOREXIT : partitioner$module
                newRedBlackTree$partitioner$1$ = newRedBlackTree$partitioner$1$2;
            }
        }
        newRedBlackTree$partitioner$1$.fk(t);
        return new Tuple2((Object)this.blacken(this.partitioner$2(partitioner$module, p).tmpk()), (Object)this.blacken(this.partitioner$2(partitioner$module, p).tmpd()));
    }

    private <A, B> NewRedBlackTree.Tree<A, B> del(NewRedBlackTree.Tree<A, B> tree, A k, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        int cmp = ordering.compare(k, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key);
        if (cmp < 0) {
            NewRedBlackTree.Tree newLeft = this.del(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, k, ordering);
            if (newLeft == tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left) {
                return tree;
            }
            NewRedBlackTree.Tree isBlackTree_tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
            if (isBlackTree_tree != null && isBlackTree_tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0) {
                return this.balLeft(tree, newLeft, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right);
            }
            return tree.redWithLeft(newLeft);
        }
        if (cmp > 0) {
            NewRedBlackTree.Tree newRight = this.del(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, k, ordering);
            if (newRight == tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right) {
                return tree;
            }
            NewRedBlackTree.Tree isBlackTree_tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
            if (isBlackTree_tree != null && isBlackTree_tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0) {
                return this.balRight(tree, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, newRight);
            }
            return tree.redWithRight(newRight);
        }
        return this.append(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right);
    }

    private <A, B> NewRedBlackTree.Tree<A, B> balance(NewRedBlackTree.Tree<A, B> tree, NewRedBlackTree.Tree<A, B> tl, NewRedBlackTree.Tree<A, B> tr) {
        if (tl != null && tl.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            if (tr != null && tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                return tree.redWithLeftRight(tl.black(), tr.black());
            }
            if (tl == null) {
                throw null;
            }
            NewRedBlackTree.Tree scala$collection$immutable$NewRedBlackTree$$isRedTree_tree = tl.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
            if (scala$collection$immutable$NewRedBlackTree$$isRedTree_tree != null && scala$collection$immutable$NewRedBlackTree$$isRedTree_tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                return tl.withLeftRight(tl.scala$collection$immutable$NewRedBlackTree$Tree$$_left.black(), tree.blackWithLeftRight(tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tr));
            }
            NewRedBlackTree.Tree scala$collection$immutable$NewRedBlackTree$$isRedTree_tree2 = tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
            if (scala$collection$immutable$NewRedBlackTree$$isRedTree_tree2 != null && scala$collection$immutable$NewRedBlackTree$$isRedTree_tree2.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                NewRedBlackTree.Tree tree2 = tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
                if (tree2 == null) {
                    throw null;
                }
                NewRedBlackTree.Tree tree3 = tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
                if (tree3 == null) {
                    throw null;
                }
                return tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right.withLeftRight(tl.blackWithRight(tree2.scala$collection$immutable$NewRedBlackTree$Tree$$_left), tree.blackWithLeftRight(tree3.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tr));
            }
            return tree.blackWithLeftRight(tl, tr);
        }
        if (tr != null && tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            if (tr == null) {
                throw null;
            }
            NewRedBlackTree.Tree scala$collection$immutable$NewRedBlackTree$$isRedTree_tree = tr.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
            if (scala$collection$immutable$NewRedBlackTree$$isRedTree_tree != null && scala$collection$immutable$NewRedBlackTree$$isRedTree_tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                return tr.withLeftRight(tree.blackWithLeftRight(tl, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left), tr.scala$collection$immutable$NewRedBlackTree$Tree$$_right.black());
            }
            NewRedBlackTree.Tree scala$collection$immutable$NewRedBlackTree$$isRedTree_tree3 = tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
            if (scala$collection$immutable$NewRedBlackTree$$isRedTree_tree3 != null && scala$collection$immutable$NewRedBlackTree$$isRedTree_tree3.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                NewRedBlackTree.Tree tree4 = tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
                if (tree4 == null) {
                    throw null;
                }
                NewRedBlackTree.Tree tree5 = tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
                if (tree5 == null) {
                    throw null;
                }
                return tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left.withLeftRight(tree.blackWithLeftRight(tl, tree4.scala$collection$immutable$NewRedBlackTree$Tree$$_left), tr.blackWithLeftRight(tree5.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_right));
            }
            return tree.blackWithLeftRight(tl, tr);
        }
        return tree.blackWithLeftRight(tl, tr);
    }

    private <A, B> NewRedBlackTree.Tree<A, B> balLeft(NewRedBlackTree.Tree<A, B> tree, NewRedBlackTree.Tree<A, B> tl, NewRedBlackTree.Tree<A, B> tr) {
        if (tl != null && tl.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            return tree.redWithLeftRight(tl.black(), tr);
        }
        if (tr != null && tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0) {
            return this.balance(tree, tl, tr.red());
        }
        if (tr != null && tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            if (tr == null) {
                throw null;
            }
            NewRedBlackTree.Tree isBlackTree_tree = tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
            if (isBlackTree_tree != null && isBlackTree_tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0) {
                NewRedBlackTree.Tree tree2 = tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
                if (tree2 == null) {
                    throw null;
                }
                NewRedBlackTree.Tree tree3 = tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
                if (tree3 == null) {
                    throw null;
                }
                return tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left.redWithLeftRight(tree.blackWithLeftRight(tl, tree2.scala$collection$immutable$NewRedBlackTree$Tree$$_left), this.balance(tr, tree3.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_right.red()));
            }
        }
        throw package$.MODULE$.error("Defect: invariance violation");
    }

    private <A, B> NewRedBlackTree.Tree<A, B> balRight(NewRedBlackTree.Tree<A, B> tree, NewRedBlackTree.Tree<A, B> tl, NewRedBlackTree.Tree<A, B> tr) {
        if (tr != null && tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            return tree.redWithLeftRight(tl, tr.black());
        }
        if (tl != null && tl.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0) {
            return this.balance(tree, tl.red(), tr);
        }
        if (tl != null && tl.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            if (tl == null) {
                throw null;
            }
            NewRedBlackTree.Tree isBlackTree_tree = tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
            if (isBlackTree_tree != null && isBlackTree_tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0) {
                NewRedBlackTree.Tree tree2 = tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
                if (tree2 == null) {
                    throw null;
                }
                NewRedBlackTree.Tree tree3 = tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
                if (tree3 == null) {
                    throw null;
                }
                return tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right.redWithLeftRight(this.balance(tl, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_left.red(), tree2.scala$collection$immutable$NewRedBlackTree$Tree$$_left), tree.blackWithLeftRight(tree3.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tr));
            }
        }
        throw package$.MODULE$.error("Defect: invariance violation");
    }

    private <A, B> NewRedBlackTree.Tree<A, B> append(NewRedBlackTree.Tree<A, B> tl, NewRedBlackTree.Tree<A, B> tr) {
        if (tl == null) {
            return tr;
        }
        if (tr == null) {
            return tl;
        }
        if (tl.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            if (tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                NewRedBlackTree.Tree bc = this.append(tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left);
                if (bc != null && bc.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                    if (bc == null) {
                        throw null;
                    }
                    return bc.withLeftRight(tl.withRight(bc.scala$collection$immutable$NewRedBlackTree$Tree$$_left), tr.withLeft(bc.scala$collection$immutable$NewRedBlackTree$Tree$$_right));
                }
                return tl.withRight(tr.withLeft(bc));
            }
            return tl.withRight(this.append(tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tr));
        }
        if (tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0) {
            NewRedBlackTree.Tree bc = this.append(tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left);
            if (bc != null && bc.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                if (bc == null) {
                    throw null;
                }
                return bc.withLeftRight(tl.withRight(bc.scala$collection$immutable$NewRedBlackTree$Tree$$_left), tr.withLeft(bc.scala$collection$immutable$NewRedBlackTree$Tree$$_right));
            }
            return this.balLeft(tl, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_left, tr.withLeft(bc));
        }
        return tr.withLeft(this.append(tl, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> union(NewRedBlackTree.Tree<A, B> t1, NewRedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        return this.blacken(this._union(t1, t2, ordering));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> intersect(NewRedBlackTree.Tree<A, B> t1, NewRedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        return this.blacken(this._intersect(t1, t2, ordering));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> difference(NewRedBlackTree.Tree<A, B> t1, NewRedBlackTree.Tree<A, ?> t2, Ordering<A> ordering) {
        return this.blacken(this._difference(t1, t2, ordering));
    }

    private int rank(NewRedBlackTree.Tree<?, ?> t, int bh) {
        if (t == null) {
            return 0;
        }
        if (t.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0) {
            return 2 * (bh - 1);
        }
        return 2 * bh - 1;
    }

    private <A, B> NewRedBlackTree.Tree<A, B> joinRight(NewRedBlackTree.Tree<A, B> tl, A k, B v, NewRedBlackTree.Tree<A, B> tr, int bhtl, int rtr) {
        int bhtlr;
        if ((tl == null ? 0 : (tl.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0 ? 2 * (bhtl - 1) : 2 * bhtl - 1)) == rtr / 2 * 2) {
            return this.RedTree(k, v, tl, tr);
        }
        boolean tlBlack = tl != null && tl.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0;
        int n = bhtlr = tlBlack ? bhtl - 1 : bhtl;
        if (tl == null) {
            throw null;
        }
        NewRedBlackTree.Tree ttr = this.joinRight(tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right, k, v, tr, bhtlr, rtr);
        if (tlBlack && ttr != null && ttr.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            if (ttr == null) {
                throw null;
            }
            NewRedBlackTree.Tree scala$collection$immutable$NewRedBlackTree$$isRedTree_tree = ttr.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
            if (scala$collection$immutable$NewRedBlackTree$$isRedTree_tree != null && scala$collection$immutable$NewRedBlackTree$$isRedTree_tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                return this.RedTree(ttr.scala$collection$immutable$NewRedBlackTree$Tree$$_key, ttr.scala$collection$immutable$NewRedBlackTree$Tree$$_value, this.BlackTree(tl.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_left, ttr.scala$collection$immutable$NewRedBlackTree$Tree$$_left), ttr.scala$collection$immutable$NewRedBlackTree$Tree$$_right.black());
            }
        }
        return this.mkTree(tlBlack, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_left, ttr);
    }

    private <A, B> NewRedBlackTree.Tree<A, B> joinLeft(NewRedBlackTree.Tree<A, B> tl, A k, B v, NewRedBlackTree.Tree<A, B> tr, int rtl, int bhtr) {
        int bhtrl;
        if ((tr == null ? 0 : (tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0 ? 2 * (bhtr - 1) : 2 * bhtr - 1)) == rtl / 2 * 2) {
            return this.RedTree(k, v, tl, tr);
        }
        boolean trBlack = tr != null && tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0;
        int n = bhtrl = trBlack ? bhtr - 1 : bhtr;
        if (tr == null) {
            throw null;
        }
        NewRedBlackTree.Tree ttl = this.joinLeft(tl, k, v, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left, rtl, bhtrl);
        if (trBlack && ttl != null && ttl.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            if (ttl == null) {
                throw null;
            }
            NewRedBlackTree.Tree scala$collection$immutable$NewRedBlackTree$$isRedTree_tree = ttl.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
            if (scala$collection$immutable$NewRedBlackTree$$isRedTree_tree != null && scala$collection$immutable$NewRedBlackTree$$isRedTree_tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                return this.RedTree(ttl.scala$collection$immutable$NewRedBlackTree$Tree$$_key, ttl.scala$collection$immutable$NewRedBlackTree$Tree$$_value, ttl.scala$collection$immutable$NewRedBlackTree$Tree$$_left.black(), this.BlackTree(tr.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_value, ttl.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_right));
            }
        }
        return this.mkTree(trBlack, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_value, ttl, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_right);
    }

    public <A, B> NewRedBlackTree.Tree<A, B> scala$collection$immutable$NewRedBlackTree$$join(NewRedBlackTree.Tree<A, B> tl, A k, B v, NewRedBlackTree.Tree<A, B> tr) {
        int bhtr;
        int bhtl = this.h$1(tl, 0);
        if (bhtl > (bhtr = this.h$1(tr, 0))) {
            NewRedBlackTree.Tree tt = this.joinRight(tl, k, v, tr, bhtl, tr == null ? 0 : (tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0 ? 2 * (bhtr - 1) : 2 * bhtr - 1));
            if (tt != null && tt.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                if (tt == null) {
                    throw null;
                }
                NewRedBlackTree.Tree scala$collection$immutable$NewRedBlackTree$$isRedTree_tree = tt.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
                if (scala$collection$immutable$NewRedBlackTree$$isRedTree_tree != null && scala$collection$immutable$NewRedBlackTree$$isRedTree_tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                    return tt.black();
                }
            }
            return tt;
        }
        if (bhtr > bhtl) {
            NewRedBlackTree.Tree tt = this.joinLeft(tl, k, v, tr, tl == null ? 0 : (tl.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0 ? 2 * (bhtl - 1) : 2 * bhtl - 1), bhtr);
            if (tt != null && tt.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                if (tt == null) {
                    throw null;
                }
                NewRedBlackTree.Tree scala$collection$immutable$NewRedBlackTree$$isRedTree_tree = tt.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
                if (scala$collection$immutable$NewRedBlackTree$$isRedTree_tree != null && scala$collection$immutable$NewRedBlackTree$$isRedTree_tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                    return tt.black();
                }
            }
            return tt;
        }
        return this.mkTree(tl != null && tl.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0 || tr != null && tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0, k, v, tl, tr);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> Tuple4<NewRedBlackTree.Tree<A, B>, NewRedBlackTree.Tree<A, B>, NewRedBlackTree.Tree<A, B>, A> split(NewRedBlackTree.Tree<A, B> t, A k2, Ordering<A> ordering) {
        void var17_17;
        void var16_16;
        void var15_15;
        void var14_14;
        if (t == null) {
            return new Tuple4(null, null, null, k2);
        }
        int cmp = ordering.compare(k2, t.scala$collection$immutable$NewRedBlackTree$Tree$$_key);
        if (cmp == 0) {
            return new Tuple4((Object)t.scala$collection$immutable$NewRedBlackTree$Tree$$_left, t, (Object)t.scala$collection$immutable$NewRedBlackTree$Tree$$_right, t.scala$collection$immutable$NewRedBlackTree$Tree$$_key);
        }
        if (cmp < 0) {
            void var9_9;
            void var8_8;
            void var7_7;
            void var6_6;
            Tuple4 tuple4 = this.split(t.scala$collection$immutable$NewRedBlackTree$Tree$$_left, k2, ordering);
            if (tuple4 == null) {
                throw new MatchError(null);
            }
            NewRedBlackTree.Tree ll = (NewRedBlackTree.Tree)tuple4._1();
            NewRedBlackTree.Tree b = (NewRedBlackTree.Tree)tuple4._2();
            NewRedBlackTree.Tree lr = (NewRedBlackTree.Tree)tuple4._3();
            Object k1 = tuple4._4();
            void ll2 = var6_6;
            void b2 = var7_7;
            void lr2 = var8_8;
            return new Tuple4((Object)ll2, (Object)b2, (Object)this.scala$collection$immutable$NewRedBlackTree$$join((NewRedBlackTree.Tree)lr2, t.scala$collection$immutable$NewRedBlackTree$Tree$$_key, t.scala$collection$immutable$NewRedBlackTree$Tree$$_value, t.scala$collection$immutable$NewRedBlackTree$Tree$$_right), (Object)var9_9);
        }
        Tuple4 tuple4 = this.split(t.scala$collection$immutable$NewRedBlackTree$Tree$$_right, k2, ordering);
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        NewRedBlackTree.Tree rl = (NewRedBlackTree.Tree)tuple4._1();
        NewRedBlackTree.Tree b = (NewRedBlackTree.Tree)tuple4._2();
        NewRedBlackTree.Tree rr = (NewRedBlackTree.Tree)tuple4._3();
        Object k1 = tuple4._4();
        void rl2 = var14_14;
        void b3 = var15_15;
        void rr2 = var16_16;
        return new Tuple4((Object)this.scala$collection$immutable$NewRedBlackTree$$join(t.scala$collection$immutable$NewRedBlackTree$Tree$$_left, t.scala$collection$immutable$NewRedBlackTree$Tree$$_key, t.scala$collection$immutable$NewRedBlackTree$Tree$$_value, (NewRedBlackTree.Tree)rl2), (Object)b3, (Object)rr2, (Object)var17_17);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> Tuple3<NewRedBlackTree.Tree<A, B>, A, B> splitLast(NewRedBlackTree.Tree<A, B> t) {
        void var5_5;
        void var4_4;
        void var3_3;
        if (t == null) {
            throw null;
        }
        if (t.scala$collection$immutable$NewRedBlackTree$Tree$$_right == null) {
            return new Tuple3((Object)t.scala$collection$immutable$NewRedBlackTree$Tree$$_left, t.scala$collection$immutable$NewRedBlackTree$Tree$$_key, t.scala$collection$immutable$NewRedBlackTree$Tree$$_value);
        }
        Tuple3 tuple3 = this.splitLast(t.scala$collection$immutable$NewRedBlackTree$Tree$$_right);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        NewRedBlackTree.Tree tt = (NewRedBlackTree.Tree)tuple3._1();
        Object kk = tuple3._2();
        Object vv = tuple3._3();
        void tt2 = var3_3;
        return new Tuple3((Object)this.scala$collection$immutable$NewRedBlackTree$$join(t.scala$collection$immutable$NewRedBlackTree$Tree$$_left, t.scala$collection$immutable$NewRedBlackTree$Tree$$_key, t.scala$collection$immutable$NewRedBlackTree$Tree$$_value, (NewRedBlackTree.Tree)tt2), (Object)var4_4, (Object)var5_5);
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> NewRedBlackTree.Tree<A, B> scala$collection$immutable$NewRedBlackTree$$join2(NewRedBlackTree.Tree<A, B> tl, NewRedBlackTree.Tree<A, B> tr) {
        void var6_6;
        void var5_5;
        void var4_4;
        if (tl == null) {
            return tr;
        }
        if (tr == null) {
            return tl;
        }
        Tuple3 tuple3 = this.splitLast(tl);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        NewRedBlackTree.Tree ttl = (NewRedBlackTree.Tree)tuple3._1();
        Object k = tuple3._2();
        Object v = tuple3._3();
        void ttl2 = var4_4;
        return this.scala$collection$immutable$NewRedBlackTree$$join((NewRedBlackTree.Tree)ttl2, (Object)var5_5, (Object)var6_6, tr);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> NewRedBlackTree.Tree<A, B> _union(NewRedBlackTree.Tree<A, B> t1, NewRedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        void var7_7;
        void var6_6;
        void var5_5;
        if (t1 == null || t1 == t2) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        Tuple4 tuple4 = this.split(t1, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_key, ordering);
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        NewRedBlackTree.Tree l1 = (NewRedBlackTree.Tree)tuple4._1();
        NewRedBlackTree.Tree r1 = (NewRedBlackTree.Tree)tuple4._3();
        Object k1 = tuple4._4();
        void l12 = var5_5;
        void r12 = var6_6;
        NewRedBlackTree.Tree tl = this._union((NewRedBlackTree.Tree)l12, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_left, ordering);
        NewRedBlackTree.Tree tr = this._union((NewRedBlackTree.Tree)r12, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_right, ordering);
        return this.scala$collection$immutable$NewRedBlackTree$$join(tl, (Object)var7_7, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tr);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> NewRedBlackTree.Tree<A, B> _intersect(NewRedBlackTree.Tree<A, B> t1, NewRedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        void var7_7;
        void var6_6;
        void var5_5;
        if (t1 == null || t2 == null) {
            return null;
        }
        if (t1 == t2) {
            return t1;
        }
        Tuple4 tuple4 = this.split(t1, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_key, ordering);
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        NewRedBlackTree.Tree l1 = (NewRedBlackTree.Tree)tuple4._1();
        NewRedBlackTree.Tree b = (NewRedBlackTree.Tree)tuple4._2();
        NewRedBlackTree.Tree r1 = (NewRedBlackTree.Tree)tuple4._3();
        Object k1 = tuple4._4();
        void l12 = var5_5;
        void b2 = var6_6;
        void r12 = var7_7;
        NewRedBlackTree.Tree tl = this._intersect((NewRedBlackTree.Tree)l12, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_left, ordering);
        NewRedBlackTree.Tree tr = this._intersect((NewRedBlackTree.Tree)r12, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_right, ordering);
        if (b2 != null) {
            void var8_8;
            return this.scala$collection$immutable$NewRedBlackTree$$join(tl, (Object)var8_8, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tr);
        }
        return this.scala$collection$immutable$NewRedBlackTree$$join2(tl, tr);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> NewRedBlackTree.Tree<A, B> _difference(NewRedBlackTree.Tree<A, B> t1, NewRedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        void var6_6;
        void var5_5;
        if (t1 == null || t2 == null) {
            return t1;
        }
        if (t1 == t2) {
            return null;
        }
        Tuple4 tuple4 = this.split(t1, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_key, ordering);
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        NewRedBlackTree.Tree l1 = (NewRedBlackTree.Tree)tuple4._1();
        NewRedBlackTree.Tree r1 = (NewRedBlackTree.Tree)tuple4._3();
        tuple4._4();
        void l12 = var5_5;
        void r12 = var6_6;
        NewRedBlackTree.Tree tl = this._difference((NewRedBlackTree.Tree)l12, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_left, ordering);
        NewRedBlackTree.Tree tr = this._difference((NewRedBlackTree.Tree)r12, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_right, ordering);
        return this.scala$collection$immutable$NewRedBlackTree$$join2(tl, tr);
    }

    private final NewRedBlackTree.Tree _tail$1(NewRedBlackTree.Tree tree) {
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        NewRedBlackTree.Tree tl = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        if (tl == null) {
            return tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        }
        if (tl.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0) {
            return this.balLeft(tree, this._tail$1(tl), tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right);
        }
        return tree.redWithLeft(this._tail$1(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left));
    }

    private final NewRedBlackTree.Tree _init$1(NewRedBlackTree.Tree tree) {
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        NewRedBlackTree.Tree tr = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        if (tr == null) {
            return tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        }
        if (tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0) {
            return this.balRight(tree, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, this._init$1(tr));
        }
        return tree.redWithRight(this._init$1(tr));
    }

    private final NewRedBlackTree.Tree f$1(int level, int size, Iterator keys$1, Iterator values$1, int maxUsedDepth$1) {
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                Object k = keys$1.next();
                Object v = values$1.next();
                return this.mkTree(level != maxUsedDepth$1 || level == 1, k, v, null, null);
            }
        }
        int leftSize = (size - 1) / 2;
        NewRedBlackTree.Tree left = this.f$1(level + 1, leftSize, keys$1, values$1, maxUsedDepth$1);
        Object k = keys$1.next();
        Object v = values$1.next();
        NewRedBlackTree.Tree right = this.f$1(level + 1, size - 1 - leftSize, keys$1, values$1, maxUsedDepth$1);
        return this.BlackTree(k, v, left, right);
    }

    private final NewRedBlackTree.Tree fk$1(NewRedBlackTree.Tree t, Function2 f$2) {
        NewRedBlackTree.Tree r2;
        if (t == null) {
            throw null;
        }
        Object k = t.scala$collection$immutable$NewRedBlackTree$Tree$$_key;
        Object v = t.scala$collection$immutable$NewRedBlackTree$Tree$$_value;
        NewRedBlackTree.Tree l = t.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        NewRedBlackTree.Tree r = t.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        NewRedBlackTree.Tree l2 = l == null ? null : this.fk$1(l, f$2);
        boolean keep = BoxesRunTime.unboxToBoolean((Object)f$2.apply(k, v));
        NewRedBlackTree.Tree tree = r2 = r == null ? null : this.fk$1(r, f$2);
        if (!keep) {
            return this.scala$collection$immutable$NewRedBlackTree$$join2(l2, r2);
        }
        if (l2 == l && r2 == r) {
            return t;
        }
        return this.scala$collection$immutable$NewRedBlackTree$$join(l2, k, v, r2);
    }

    private static final /* synthetic */ NewRedBlackTree$partitioner$1$ partitioner$lzycompute$1(LazyRef partitioner$module$1, Function2 p$1) {
        synchronized (partitioner$module$1) {
            NewRedBlackTree$partitioner$1$ newRedBlackTree$partitioner$1$ = partitioner$module$1.initialized() ? (NewRedBlackTree$partitioner$1$)partitioner$module$1.value() : (NewRedBlackTree$partitioner$1$)partitioner$module$1.initialize((Object)new NewRedBlackTree$partitioner$1$(p$1));
            return newRedBlackTree$partitioner$1$;
        }
    }

    private final NewRedBlackTree$partitioner$1$ partitioner$2(LazyRef partitioner$module$1, Function2 p$1) {
        if (partitioner$module$1.initialized()) {
            return (NewRedBlackTree$partitioner$1$)partitioner$module$1.value();
        }
        synchronized (partitioner$module$1) {
            NewRedBlackTree$partitioner$1$ newRedBlackTree$partitioner$1$ = partitioner$module$1.initialized() ? (NewRedBlackTree$partitioner$1$)partitioner$module$1.value() : (NewRedBlackTree$partitioner$1$)partitioner$module$1.initialize((Object)new NewRedBlackTree$partitioner$1$(p$1));
            return newRedBlackTree$partitioner$1$;
        }
    }

    private final int h$1(NewRedBlackTree.Tree t, int i) {
        while (t != null) {
            i = t.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0 ? i + 1 : i;
            t = t.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        }
        return i + 1;
    }

    private NewRedBlackTree$() {
        MODULE$ = this;
        this.null2 = new Tuple2(null, null);
    }
}

